/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.packmenu.buttons;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.shadowsoffire.packmenu.ExtendedMenuScreen;
import dev.shadowsoffire.packmenu.buttons.ActionInstance;
import dev.shadowsoffire.packmenu.buttons.AnchorPoint;
import dev.shadowsoffire.packmenu.buttons.ButtonAction;
import java.util.Locale;
import joptsimple.internal.Strings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class JsonButton
extends Button {
    protected ResourceLocation texture = f_93617_;
    protected int u;
    protected int v;
    protected int hoverU;
    protected int hoverV;
    protected int texWidth;
    protected int texHeight;
    protected final int xOff;
    protected final int yOff;
    protected boolean usesWidgets = false;
    protected String langKey;
    protected String hoverKey;
    protected final int fontColor;
    protected final int hoverFontColor;
    protected AnchorPoint anchor = AnchorPoint.DEFAULT;
    protected int textXOff;
    protected int textYOff;
    protected boolean dropShadow;
    protected float scaleX = 1.0f;
    protected float scaleY = 1.0f;
    protected int scrollCounter = 0;
    protected Component hoverMessage;

    public JsonButton(int xPos, int yPos, int width, int height, int fontColor, int hoverFontColor, String langKey, ActionInstance handler) {
        super(xPos, yPos, width, height, (Component)Component.m_237115_((String)langKey), (Button.OnPress)handler, Button.f_252438_);
        handler.setSource(this);
        this.xOff = xPos;
        this.yOff = yPos;
        this.langKey = langKey;
        this.fontColor = fontColor;
        this.hoverFontColor = hoverFontColor;
    }

    public JsonButton texture(ResourceLocation texture, int u, int v, int hoverU, int hoverV, int texWidth, int texHeight) {
        this.texture = texture;
        this.u = u;
        this.v = v;
        this.hoverU = hoverU;
        this.hoverV = hoverV;
        this.texHeight = texHeight;
        this.texWidth = texWidth;
        return this;
    }

    public JsonButton anchor(AnchorPoint anchor) {
        this.anchor = anchor;
        return this;
    }

    public JsonButton usesWidgets(boolean widgets) {
        this.usesWidgets = widgets;
        return this;
    }

    public JsonButton textOffsets(int x, int y) {
        this.textXOff = x;
        this.textYOff = y;
        return this;
    }

    public JsonButton setup(ExtendedMenuScreen screen) {
        this.m_252865_(this.xOff + this.anchor.getX(screen));
        this.m_253211_(this.yOff + this.anchor.getY(screen));
        this.m_93666_((Component)Component.m_237115_((String)this.langKey));
        this.hoverMessage = Component.m_237115_((String)this.hoverKey);
        return this;
    }

    public JsonButton dropShadow(boolean dropShadow) {
        this.dropShadow = dropShadow;
        return this;
    }

    public JsonButton scale(float x, float y) {
        this.scaleX = x;
        this.scaleY = y;
        return this;
    }

    public JsonButton hoverText(String hoverKey) {
        this.hoverKey = Strings.isNullOrEmpty((String)hoverKey) ? this.langKey : hoverKey;
        return this;
    }

    public Component m_6035_() {
        if (this.f_93622_) {
            return this.hoverMessage;
        }
        return super.m_6035_();
    }

    public void m_87963_(GuiGraphics stack, int mouseX, int mouseY, float partial) {
        if (this.f_93624_) {
            if (this.usesWidgets) {
                this.renderWidgetButton(stack, mouseX, mouseY, partial);
            } else {
                this.renderImageButton(stack, mouseX, mouseY, partial);
            }
        }
    }

    public static void drawCenteredStringNoShadow(GuiGraphics stack, Font font, String string, int x, int y, int color) {
        stack.m_280056_(font, string, x - font.m_92895_(string) / 2, y, color, false);
    }

    protected void drawCenteredString(GuiGraphics stack, Font font, String string, int x, int y, int color) {
        if (this.dropShadow) {
            stack.m_280137_(font, string, x, y, color);
        } else {
            JsonButton.drawCenteredStringNoShadow(stack, font, string, x, y, color);
        }
    }

    protected int getVIndex(boolean pIsHovered) {
        int i = 1;
        if (!this.f_93623_) {
            i = 0;
        } else if (pIsHovered) {
            i = 2;
        }
        return i;
    }

    private void renderWidgetButton(GuiGraphics stack, int mouseX, int mouseY, float partial) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        int i = this.getVIndex(this.m_198029_());
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        stack.m_280218_(this.texture, this.m_252754_(), this.m_252907_(), 0, 46 + i * 20, this.f_93618_ / 2, this.f_93619_);
        stack.m_280218_(this.texture, this.m_252754_() + this.f_93618_ / 2, this.m_252907_(), 200 - this.f_93618_ / 2, 46 + i * 20, this.f_93618_ / 2, this.f_93619_);
        this.renderText(stack);
    }

    private void renderImageButton(GuiGraphics stack, int mouseX, int mouseY, float partial) {
        this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        RenderSystem.disableDepthTest();
        int x = this.u;
        int y = this.v;
        if (this.m_198029_()) {
            x = this.hoverU;
            y = this.hoverV;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        stack.m_280168_().m_85836_();
        stack.m_280168_().m_85841_(this.scaleX, this.scaleY, 1.0f);
        stack.m_280163_(this.texture, Math.round((float)this.m_252754_() / this.scaleX), Math.round((float)this.m_252907_() / this.scaleY), (float)x, (float)y, Math.round((float)this.f_93618_ / this.scaleX), Math.round((float)this.f_93619_ / this.scaleY), this.texWidth, this.texHeight);
        stack.m_280168_().m_85849_();
        RenderSystem.enableDepthTest();
        this.renderText(stack);
    }

    protected void renderText(GuiGraphics stack) {
        Minecraft mc = Minecraft.m_91087_();
        int color = this.getFGColor();
        Object buttonText = this.m_6035_().getString();
        int strWidth = mc.f_91062_.m_92895_((String)buttonText);
        if (strWidth <= this.f_93618_ - 6) {
            this.drawCenteredString(stack, mc.f_91062_, (String)buttonText, this.m_252754_() + this.f_93618_ / 2 + this.textXOff, this.m_252907_() + this.f_93619_ / 2 + this.textYOff, color);
        } else if (!this.f_93622_) {
            this.scrollCounter = 0;
            int ellipsisWidth = mc.f_91062_.m_92895_("...");
            if (strWidth > ellipsisWidth) {
                buttonText = this.trimStringToWidth((FormattedText)this.m_6035_(), this.f_93618_ - 6 - ellipsisWidth).getString().trim() + "...";
            }
            this.drawCenteredString(stack, mc.f_91062_, (String)buttonText, this.m_252754_() + this.f_93618_ / 2 + this.textXOff, this.m_252907_() + this.f_93619_ / 2 + this.textYOff, color);
        } else {
            int halfLen = mc.f_91062_.m_92895_((String)buttonText + "      ");
            buttonText = (String)buttonText + "      " + (String)buttonText;
            stack.m_280168_().m_85836_();
            double d0 = mc.m_91268_().m_85449_();
            float y = Minecraft.m_91087_().f_91080_.f_96544_ - this.m_252907_() - this.f_93619_;
            RenderSystem.enableScissor((int)((int)((double)this.m_252754_() * d0)), (int)((int)((double)y * d0)), (int)((int)(d0 * (double)this.f_93618_)), (int)((int)(d0 * (double)this.f_93619_)));
            stack.m_280168_().m_252880_(((float)(-this.scrollCounter) - mc.m_91297_()) % (float)halfLen, 0.0f, 0.0f);
            stack.m_280056_(mc.f_91062_, (String)buttonText, this.m_252754_() + this.f_93618_ / 8 + this.textXOff, this.m_252907_() + this.f_93619_ / 2 + this.textYOff, color, this.dropShadow);
            RenderSystem.disableScissor();
            stack.m_280168_().m_85849_();
        }
    }

    public void tickScrollCounter() {
        ++this.scrollCounter;
    }

    public FormattedText trimStringToWidth(FormattedText str, int width) {
        return (FormattedText)Minecraft.m_91087_().f_91062_.m_92865_().m_92414_(str, width, Style.f_131099_).get(0);
    }

    public int getFGColor() {
        return !this.f_93622_ ? this.fontColor : this.hoverFontColor;
    }

    public static JsonButton deserialize(JsonObject obj) {
        JsonElement x = obj.get("x");
        JsonElement y = obj.get("y");
        JsonElement width = obj.get("width");
        JsonElement height = obj.get("height");
        JsonElement tex = obj.get("texture");
        JsonElement u = obj.get("u");
        JsonElement v = obj.get("v");
        JsonElement hoverU = obj.get("hoverU");
        JsonElement hoverV = obj.get("hoverV");
        JsonElement texWidth = obj.get("texWidth");
        JsonElement texHeight = obj.get("texHeight");
        JsonElement widgets = obj.get("widgets");
        JsonElement langKey = obj.get("langKey");
        JsonElement hoverLangKey = obj.get("hoverLangKey");
        JsonElement action = obj.get("action");
        JsonElement fontColor = obj.get("fontColor");
        JsonElement hoverFontColor = obj.get("hoverFontColor");
        JsonElement anchor = obj.get("anchor");
        JsonElement textX = obj.get("textXOffset");
        JsonElement textY = obj.get("textYOffset");
        JsonElement dropShadow = obj.get("dropShadow");
        JsonElement active = obj.get("active");
        JsonElement scaleX = obj.get("scaleX");
        JsonElement scaleY = obj.get("scaleY");
        ResourceLocation _tex = tex == null ? f_93617_ : new ResourceLocation(tex.getAsString());
        int _u = JsonButton.get(u, 0);
        int _v = JsonButton.get(v, 0);
        int _hoverU = JsonButton.get(hoverU, 0);
        int _hoverV = JsonButton.get(hoverV, 0);
        int _x = JsonButton.get(x, 0);
        int _y = JsonButton.get(y, 0);
        int _width = JsonButton.get(width, 0);
        int _height = JsonButton.get(height, 0);
        int _texWidth = JsonButton.get(texWidth, 256);
        int _texHeight = JsonButton.get(texHeight, 256);
        boolean _widgets = widgets == null ? _tex.toString().contains("widgets") : widgets.getAsBoolean();
        int _fontColor = JsonButton.get(fontColor, 0xFFFFFF);
        int _hoverFontColor = JsonButton.get(hoverFontColor, 0xFFFFFF);
        String displayKey = langKey == null ? "" : langKey.getAsString();
        String hoverKey = hoverLangKey == null ? "" : hoverLangKey.getAsString();
        ButtonAction act = ButtonAction.valueOf(action.getAsString().toUpperCase(Locale.ROOT));
        AnchorPoint _anchor = anchor == null ? AnchorPoint.DEFAULT : AnchorPoint.valueOf(anchor.getAsString());
        Object data = act.readData(obj);
        int _textX = JsonButton.get(textX, 0);
        int _textY = JsonButton.get(textY, -4);
        float _scaleX = JsonButton.get(scaleX, 1.0f);
        float _scaleY = JsonButton.get(scaleY, 1.0f);
        boolean _dropShadow = dropShadow == null ? true : dropShadow.getAsBoolean();
        JsonButton button = new JsonButton(_x, _y, _width, _height, _fontColor, _hoverFontColor, displayKey, new ActionInstance(act, data));
        button.texture(_tex, _u, _v, _hoverU, _hoverV, _texWidth, _texHeight).usesWidgets(_widgets).anchor(_anchor);
        button.textOffsets(_textX, _textY).dropShadow(_dropShadow).scale(_scaleX, _scaleY).hoverText(hoverKey);
        button.f_93623_ = active == null ? true : active.getAsBoolean();
        return button;
    }

    private static int get(JsonElement e, int def) {
        return e == null ? def : e.getAsInt();
    }

    private static float get(JsonElement e, float def) {
        return e == null ? def : e.getAsFloat();
    }
}

