/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.steamboiler;

import mods.railcraft.world.level.block.steamboiler.SteamBoilerBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class FireboxBlock
extends SteamBoilerBlock {
    public static final Property<Boolean> LIT = BlockStateProperties.f_61443_;

    public FireboxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT});
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource random) {
        if (((Boolean)blockState.m_61143_(LIT)).booleanValue()) {
            double x = (double)blockPos.m_123341_() + 0.5;
            double y = (double)blockPos.m_123342_() + 0.4;
            double z = (double)blockPos.m_123343_() + 0.5;
            if (random.m_188500_() < 0.1) {
                level.m_7785_(x, y, z, SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Direction.Axis axis = direction.m_122434_();
                double offset = 0.52;
                double horizontalOffset = random.m_188500_() * 0.6 - 0.3;
                double xOffset = axis == Direction.Axis.X ? (double)direction.m_122429_() * offset : horizontalOffset;
                double verticalOffset = random.m_188500_() * 6.0 / 16.0;
                double zOffset = axis == Direction.Axis.Z ? (double)direction.m_122431_() * offset : horizontalOffset;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + xOffset, y + verticalOffset, z + zOffset, 0.0, 0.0, 0.0);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x + xOffset, y + verticalOffset, z + zOffset, 0.0, 0.0, 0.0);
            }
        }
    }
}

