/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.util.RecipeUtil;
import mods.railcraft.world.item.crafting.RailcraftRecipeSerializers;
import mods.railcraft.world.item.crafting.RailcraftRecipeTypes;
import mods.railcraft.world.level.block.RailcraftBlocks;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CrusherRecipe
implements Recipe<Container> {
    private final ResourceLocation recipeId;
    private final Ingredient ingredient;
    private final List<CrusherOutput> probabilityOutputs;
    private final int processTime;

    public CrusherRecipe(ResourceLocation recipeId, Ingredient ingredient, List<CrusherOutput> probabilityOutputs, int processTime) {
        this.recipeId = recipeId;
        this.ingredient = ingredient;
        this.probabilityOutputs = probabilityOutputs;
        this.processTime = processTime;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public boolean m_5818_(Container inventory, Level level) {
        return this.ingredient.test(inventory.m_8020_(0));
    }

    public ItemStack m_5874_(Container inventory, RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess).m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    @Deprecated
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public List<CrusherOutput> getProbabilityOutputs() {
        return this.probabilityOutputs;
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.ingredient});
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RailcraftRecipeSerializers.CRUSHER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RailcraftRecipeTypes.CRUSHING.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)RailcraftBlocks.CRUSHER.get());
    }

    public static class Serializer
    implements RecipeSerializer<CrusherRecipe> {
        public CrusherRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int processTime = GsonHelper.m_13824_((JsonObject)json, (String)"processTime", (int)200);
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            ArrayList<CrusherOutput> probabilityItems = new ArrayList<CrusherOutput>();
            JsonArray outputs = GsonHelper.m_13933_((JsonObject)json, (String)"outputs");
            for (JsonElement output : outputs) {
                JsonObject outputObj = output.getAsJsonObject();
                double probability = GsonHelper.m_144742_((JsonObject)outputObj, (String)"probability", (double)1.0);
                probability = Mth.m_14008_((double)probability, (double)0.0, (double)1.0);
                int quantity = GsonHelper.m_13824_((JsonObject)outputObj, (String)"count", (int)1);
                Ingredient outputIngredient = Ingredient.m_43917_((JsonElement)outputObj.get("result"));
                probabilityItems.add(new CrusherOutput(outputIngredient, quantity, probability));
            }
            return new CrusherRecipe(recipeId, ingredient, probabilityItems, processTime);
        }

        public CrusherRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int tickCost = buffer.m_130242_();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            List probabilityOutputs = buffer.m_236845_(buf -> new CrusherOutput(Ingredient.m_43940_((FriendlyByteBuf)buf), buf.m_130242_(), buf.readDouble()));
            return new CrusherRecipe(recipeId, ingredient, probabilityOutputs, tickCost);
        }

        public void toNetwork(FriendlyByteBuf buffer, CrusherRecipe recipe) {
            buffer.m_130130_(recipe.processTime);
            recipe.ingredient.m_43923_(buffer);
            buffer.m_236828_(recipe.probabilityOutputs, (buf, item) -> {
                item.output.m_43923_(buf);
                buf.m_130130_(item.quantity);
                buf.writeDouble(item.probability);
            });
        }
    }

    public record CrusherOutput(Ingredient output, int quantity, double probability) {
        public ItemStack getOutput() {
            return RecipeUtil.getPreferredStackbyMod(this.output.m_43908_()).m_255036_(this.quantity);
        }
    }
}

