/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import mods.railcraft.RailcraftConfig;
import mods.railcraft.Translations;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeBlock;
import mods.railcraft.api.charge.ChargeStorage;
import mods.railcraft.charge.ChargeCartStorageImpl;
import mods.railcraft.charge.ChargeNetworkImpl;
import mods.railcraft.charge.ChargeStorageBlockImpl;
import mods.railcraft.util.HumanReadableNumberFormatter;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.StringUtils;

public class ChargeMeterItem
extends Item {
    private static final int SECONDS_TO_RECORD = 5;

    public ChargeMeterItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ChargeBlock chargeBlock;
        ChargeNetworkImpl.ChargeNode node;
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        InteractionResult returnValue = InteractionResult.PASS;
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof ChargeBlock && (node = (ChargeNetworkImpl.ChargeNode)(chargeBlock = (ChargeBlock)block).getMeterAccess(Charge.distribution, state, (ServerLevel)level, pos)) != null && node.isValid() && !node.isGridNull()) {
            player.m_5661_((Component)Component.m_237110_((String)Translations.ChargeMeter.START, (Object[])new Object[]{5}), false);
            node.startUsageRecording(100, avg -> {
                ChargeMeterItem.sendNetworkStat(player, node.getGrid());
                ChargeStorageBlockImpl battery = node.storage().orElse(null);
                if (battery == null) {
                    ChargeMeterItem.sendNodeStat(player, avg, node);
                } else {
                    ChargeMeterItem.sendProducerStat(player, battery, node);
                }
            });
            returnValue = InteractionResult.SUCCESS;
        }
        return returnValue;
    }

    public static void sendCartStat(Player player, Component displayName, ChargeCartStorageImpl cartStorage) {
        player.m_5661_(CommonComponents.m_178396_((Component[])new Component[]{displayName.m_6881_().m_130940_(ChatFormatting.BLUE), ChargeMeterItem.lineFormatter(Translations.ChargeMeter.CHARGE, cartStorage.getEnergyStored(), "FE"), ChargeMeterItem.lineFormatter(Translations.ChargeMeter.DRAW, cartStorage.getDraw(), "FE/t"), ChargeMeterItem.lineFormatter(Translations.ChargeMeter.LOSS, cartStorage.getLosses(), "FE/t")}), false);
    }

    private static void sendNetworkStat(Player player, ChargeNetworkImpl.ChargeGrid grid) {
        player.m_5661_(CommonComponents.m_178396_((Component[])new Component[]{Component.m_237115_((String)Translations.ChargeMeter.NETWORK).m_130940_(ChatFormatting.BLUE), ChargeMeterItem.lineFormatter(Translations.ChargeMeter.SIZE, grid.size(), ""), ChargeMeterItem.lineFormatter(Translations.ChargeMeter.CHARGE, grid.isInfinite() ? "INF" : Integer.valueOf(grid.getCharge()), "FE"), ChargeMeterItem.lineFormatter(Translations.ChargeMeter.DRAW, Float.valueOf(grid.getAverageUsagePerTick()), "FE/t"), ChargeMeterItem.lineFormatter(Translations.ChargeMeter.MAX_DRAW, grid.getMaxDraw(), "FE/t"), ChargeMeterItem.lineFormatter(Translations.ChargeMeter.LOSS, Float.valueOf(grid.getLosses()), "FE/t"), ChargeMeterItem.lineFormatter(Translations.ChargeMeter.EFFICIENCY, (double)grid.getEfficiency() * 100.0, "%")}), false);
    }

    private static void sendNodeStat(Player player, double avg, ChargeNetworkImpl.ChargeNode node) {
        player.m_5661_(CommonComponents.m_178396_((Component[])new Component[]{Component.m_237115_((String)Translations.ChargeMeter.NODE).m_130940_(ChatFormatting.BLUE), ChargeMeterItem.lineFormatter(Translations.ChargeMeter.DRAW, avg, "FE"), ChargeMeterItem.lineFormatter(Translations.ChargeMeter.LOSS, Float.valueOf(node.getChargeSpec().losses()), "FE/t")}), false);
    }

    private static void sendProducerStat(Player player, ChargeStorageBlockImpl battery, ChargeNetworkImpl.ChargeNode node) {
        boolean infiniteBattery = battery.getState() == ChargeStorage.State.INFINITE;
        double loss = (double)node.getChargeSpec().losses() * (Double)RailcraftConfig.SERVER.lossMultiplier.get();
        player.m_5661_(CommonComponents.m_178396_((Component[])new Component[]{Component.m_237115_((String)Translations.ChargeMeter.PRODUCER).m_130940_(ChatFormatting.BLUE), ChargeMeterItem.lineFormatter(Translations.ChargeMeter.CHARGE, infiniteBattery ? "INF" : Integer.valueOf(battery.getAvailableCharge()), "FE"), ChargeMeterItem.lineFormatter(Translations.ChargeMeter.MAX_DRAW, battery.getMaxDraw(), "FE/t"), ChargeMeterItem.lineFormatter(Translations.ChargeMeter.LOSS, loss, "FE/t"), ChargeMeterItem.lineFormatter(Translations.ChargeMeter.EFFICIENCY, (double)battery.getEfficiency() * 100.0, "%")}), false);
    }

    private static Component lineFormatter(String translation, Object data, String unit) {
        if (data instanceof Double) {
            Double doubleArg = (Double)data;
            data = HumanReadableNumberFormatter.format(doubleArg);
        }
        return Component.m_237115_((String)translation).m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)(" " + data + (StringUtils.isEmpty((CharSequence)unit) ? "" : " ") + unit)).m_130940_(ChatFormatting.WHITE));
    }
}

