/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import java.util.Optional;
import mods.railcraft.api.carts.ItemTransferHandler;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.network.RailcraftDataSerializers;
import mods.railcraft.season.Season;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.entity.vehicle.SeasonalCart;
import mods.railcraft.world.entity.vehicle.TunnelBore;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;

public abstract class RailcraftMinecart
extends AbstractMinecartContainer
implements SeasonalCart,
ItemTransferHandler {
    private static final EntityDataAccessor<Season> SEASON = SynchedEntityData.m_135353_(RailcraftMinecart.class, RailcraftDataSerializers.MINECART_SEASON);
    private final Direction[] travelDirectionHistory = new Direction[2];
    @Nullable
    private Direction travelDirection;
    @Nullable
    private Direction verticalTravelDirection;

    protected RailcraftMinecart(EntityType<?> type, Level level) {
        super(type, level);
    }

    protected RailcraftMinecart(EntityType<TunnelBore> type, double x, double y, double z, Level level) {
        super(type, x, y, z, level);
    }

    protected RailcraftMinecart(ItemStack itemStack, EntityType<?> type, double x, double y, double z, Level level) {
        super(type, x, y, z, level);
        this.loadCustomName(itemStack);
    }

    private void loadCustomName(ItemStack itemStack) {
        if (itemStack.m_41788_()) {
            this.m_6593_(itemStack.m_41786_());
        }
    }

    protected void loadFromItemStack(ItemStack itemStack) {
    }

    public Optional<Direction> travelDirection() {
        return Optional.ofNullable(this.travelDirection);
    }

    public Optional<Direction> verticalTravelDirection() {
        return Optional.ofNullable(this.verticalTravelDirection);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SEASON, (Object)Season.DEFAULT);
    }

    @Override
    public Season getSeason() {
        return (Season)((Object)this.f_19804_.m_135370_(SEASON));
    }

    @Override
    public void setSeason(Season season) {
        this.f_19804_.m_135381_(SEASON, (Object)season);
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("season", this.getSeason().m_7912_());
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setSeason(Season.fromName(tag.m_128461_("season")));
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!this.m_9236_().m_5776_()) {
            if (this.hasMenu()) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, data -> data.m_130130_(this.m_19879_()));
            }
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    protected boolean hasMenu() {
        return true;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (this.m_9236_().m_5776_()) {
            for (int slot = 0; slot < this.m_6643_(); ++slot) {
                this.m_6836_(slot, ItemStack.f_41583_);
            }
        }
        super.m_142687_(reason);
    }

    public final void m_7617_(DamageSource source) {
        this.m_6074_();
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            ItemStack itemstack = this.m_142340_().m_41777_();
            if (this.m_8077_()) {
                itemstack.m_41714_(this.m_7770_());
            }
            this.m_19983_(itemstack);
        }
        this.m_219927_(source, this.m_9236_(), (Entity)this);
    }

    public ItemStack m_142340_() {
        ItemStack itemStack = this.m_213728_().m_7968_();
        if (this.m_8077_()) {
            itemStack.m_41714_(this.m_7770_());
        }
        return itemStack;
    }

    protected Item m_213728_() {
        throw new NotImplementedException();
    }

    public AbstractMinecart.Type m_6064_() {
        throw new UnsupportedOperationException();
    }

    public boolean isPoweredCart() {
        return false;
    }

    public boolean canBeRidden() {
        return false;
    }

    protected void updateTravelDirection(BlockPos pos, BlockState state) {
        RailShape shape = TrackUtil.getTrackDirection((BlockGetter)this.m_9236_(), pos, state);
        Direction direction = this.determineTravelDirection(shape);
        Direction lastDirection = this.travelDirectionHistory[1];
        if (lastDirection != null && this.travelDirectionHistory[0] == lastDirection) {
            this.travelDirection = direction;
            this.verticalTravelDirection = this.determineVerticalTravelDirection(shape);
        }
        this.travelDirectionHistory[0] = lastDirection;
        this.travelDirectionHistory[1] = direction;
    }

    @Nullable
    private Direction determineTravelDirection(RailShape shape) {
        return switch (shape) {
            case RailShape.SOUTH_EAST -> {
                if (this.f_19856_ > this.m_20189_()) {
                    yield Direction.EAST;
                }
                yield Direction.SOUTH;
            }
            case RailShape.SOUTH_WEST -> {
                if (this.f_19856_ > this.m_20189_()) {
                    yield Direction.WEST;
                }
                yield Direction.SOUTH;
            }
            case RailShape.NORTH_WEST -> {
                if (this.f_19856_ > this.m_20189_()) {
                    yield Direction.NORTH;
                }
                yield Direction.WEST;
            }
            case RailShape.NORTH_EAST -> {
                if (this.f_19856_ > this.m_20189_()) {
                    yield Direction.NORTH;
                }
                yield Direction.EAST;
            }
            default -> this.m_20185_() - this.f_19854_ > 0.0 ? Direction.EAST : (this.m_20185_() - this.f_19854_ < 0.0 ? Direction.WEST : (this.m_20189_() - this.f_19856_ > 0.0 ? Direction.SOUTH : (this.m_20189_() - this.f_19856_ < 0.0 ? Direction.NORTH : null)));
        };
    }

    @Nullable
    private Direction determineVerticalTravelDirection(RailShape shape) {
        return shape.m_61745_() ? (this.f_19855_ < this.m_20186_() ? Direction.UP : Direction.DOWN) : null;
    }

    @Override
    public boolean canPassItemRequests(ItemStack stack) {
        return false;
    }

    @Override
    public boolean canAcceptPushedItem(RollingStock requester, ItemStack stack) {
        return false;
    }

    @Override
    public boolean canProvidePulledItem(RollingStock requester, ItemStack stack) {
        return false;
    }

    public boolean m_6783_(double distance) {
        return MinecartUtil.isInRangeToRenderDist((AbstractMinecart)this, distance);
    }
}

