/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.integrations.jei.category;

import java.util.List;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mods.railcraft.Translations;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.integrations.jei.RecipeTypes;
import mods.railcraft.integrations.jei.recipe.FluidBoilerJEIRecipe;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.level.material.RailcraftFluids;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public class FluidBoilerRecipeCategory
implements IRecipeCategory<FluidBoilerJEIRecipe> {
    public static final int WIDTH = 117;
    public static final int HEIGHT = 54;
    public static final ResourceLocation BACKGROUND = RailcraftConstants.rl("textures/gui/container/fluid_fueled_steam_boiler.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable flame;
    private final IDrawable bar;

    public FluidBoilerRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(BACKGROUND, 16, 19, 117, 54);
        ItemStack itemStack = new ItemStack((ItemLike)RailcraftItems.FLUID_FUELED_FIREBOX.get());
        this.icon = guiHelper.createDrawableItemStack(itemStack);
        this.flame = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(BACKGROUND, 176, 47, 14, 14), 200, IDrawableAnimated.StartDirection.TOP, true);
        this.bar = guiHelper.createDrawable(BACKGROUND, 176, 61, 6, 43);
    }

    public RecipeType<FluidBoilerJEIRecipe> getRecipeType() {
        return RecipeTypes.FLUID_BOILER;
    }

    public Component getTitle() {
        return Component.m_237115_((String)Translations.Jei.FLUID_BOILER);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(FluidBoilerJEIRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.flame.draw(guiGraphics, 46, 19);
        this.bar.draw(guiGraphics, 24, 6);
        Font font = Minecraft.m_91087_().f_91062_;
        String temp = recipe.temperature() + "\u00b0C";
        guiGraphics.m_280056_(font, temp, this.getBackground().getWidth() - font.m_92895_(temp) - 50, 43, -8355712, false);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FluidBoilerJEIRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 1, 4).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.steam())).setFluidRenderer(10000L, true, 16, 47);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 73, 4).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.fuel())).setFluidRenderer(10000L, true, 16, 47);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 100, 4).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.water())).setFluidRenderer(10000L, true, 16, 47);
    }

    public static List<FluidBoilerJEIRecipe> getBoilerRecipes() {
        return List.of(new FluidBoilerJEIRecipe(new FluidStack((Fluid)RailcraftFluids.CREOSOTE.get(), 10000), new FluidStack((Fluid)Fluids.f_76193_, 10000), new FluidStack((Fluid)RailcraftFluids.STEAM.get(), 10000), 100));
    }
}

