/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.integrations.emi;

import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import mods.railcraft.integrations.emi.RailcraftEmiPlugin;
import mods.railcraft.integrations.jei.category.BlastFurnaceRecipeCategory;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.crafting.BlastFurnaceRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class BlastFurnaceEmiRecipe
extends BasicEmiRecipe {
    private final BlastFurnaceRecipe recipe;

    public BlastFurnaceEmiRecipe(BlastFurnaceRecipe recipe) {
        super(RailcraftEmiPlugin.BLASTING_CATEGORY, recipe.m_6423_(), 82, 54);
        this.recipe = recipe;
        this.inputs.add(EmiIngredient.of((Ingredient)((Ingredient)recipe.m_7527_().get(0))));
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        this.outputs.add(EmiStack.of((ItemStack)recipe.m_8043_(level.m_9598_())));
        if (recipe.getSlagOutput() > 0) {
            this.outputs.add(EmiStack.of((ItemStack)new ItemStack((ItemLike)RailcraftItems.SLAG.get(), recipe.getSlagOutput())));
        }
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(BlastFurnaceRecipeCategory.BACKGROUND, 0, 0, this.width, this.height, 55, 16);
        widgets.addFillingArrow(24, 18, 10000).tooltip((x, y) -> {
            int cookTime = this.recipe.m_43753_();
            if (cookTime > 0) {
                int cookTimeSeconds = cookTime / 20;
                MutableComponent timeString = Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
                return List.of(EmiTooltipComponents.of((Component)timeString));
            }
            return List.of(EmiTooltipComponents.of((Component)Component.m_237119_()));
        });
        widgets.addAnimatedTexture(EmiTexture.FULL_FLAME, 1, 20, 10000, false, true, true);
        widgets.addSlot((EmiIngredient)this.inputs.get(0), 0, 0);
        widgets.addSlot((EmiIngredient)this.outputs.get(0), 56, 0).large(true).recipeContext((EmiRecipe)this);
        if (this.outputs.size() > 1) {
            widgets.addSlot((EmiIngredient)this.outputs.get(1), 60, 36).recipeContext((EmiRecipe)this);
        }
    }
}

