/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.recipes.builders;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.data.recipes.builders.AbstractCookingRecipeBuilder;
import mods.railcraft.world.item.crafting.RailcraftRecipeSerializers;
import net.minecraft.advancements.Advancement;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class BlastFurnaceRecipeBuilder
extends AbstractCookingRecipeBuilder {
    public static final int DEFAULT_COOKING_TIME = 400;
    private final int slagOutput;

    private BlastFurnaceRecipeBuilder(ItemLike result, int count, Ingredient ingredient, float experience, int cookingTime, int slagOutput) {
        super(result, count, ingredient, experience, cookingTime);
        this.slagOutput = slagOutput;
    }

    public static BlastFurnaceRecipeBuilder smelting(ItemLike result, int count, Ingredient ingredient, int multiplier, int slagOutput) {
        return new BlastFurnaceRecipeBuilder(result, count, ingredient, 0.0f, 400 * multiplier, slagOutput);
    }

    public static BlastFurnaceRecipeBuilder smelting(ItemLike result, Ingredient ingredient, int multiplier, int slagOutput) {
        return new BlastFurnaceRecipeBuilder((ItemLike)result.m_5456_(), multiplier, ingredient, 0.0f, 400 * multiplier, slagOutput);
    }

    public static BlastFurnaceRecipeBuilder recycling(ItemLike result, Ingredient ingredient, int multiplier) {
        return new BlastFurnaceRecipeBuilder((ItemLike)result.m_5456_(), multiplier, ingredient, 0.0f, 200 * multiplier, 0);
    }

    public void m_126140_(Consumer<FinishedRecipe> finishedRecipe, ResourceLocation resourceLocation) {
        String path = resourceLocation.m_135815_();
        ResourceLocation customResourceLocation = RailcraftConstants.rl("blast_furnace/" + path);
        ResourceLocation advancementId = customResourceLocation.m_246208_("recipes/");
        finishedRecipe.accept(new Result(customResourceLocation, this.result, this.count, this.ingredient, this.experience, this.cookingTime, this.slagOutput, this.advancement, advancementId));
    }

    private static class Result
    extends AbstractCookingRecipeBuilder.AbstractResult {
        private final int slagOutput;

        public Result(ResourceLocation id, Item result, int count, Ingredient ingredient, float experience, int cookingTime, int slagOutput, Advancement.Builder advancement, ResourceLocation advancementId) {
            super(id, result, count, ingredient, experience, cookingTime, advancement, advancementId);
            this.slagOutput = slagOutput;
        }

        @Override
        protected void addJsonProperty(JsonObject json) {
            if (this.slagOutput != 0) {
                json.addProperty("slagOutput", (Number)this.slagOutput);
            }
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RailcraftRecipeSerializers.BLASTING.get();
        }
    }
}

