/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.packet;

import de.ellpeck.naturesaura.packet.PacketAuraChunk;
import de.ellpeck.naturesaura.packet.PacketClient;
import de.ellpeck.naturesaura.packet.PacketParticleStream;
import de.ellpeck.naturesaura.packet.PacketParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public final class PacketHandler {
    private static final String VERSION = "1";
    private static SimpleChannel network;

    public static void init() {
        network = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("naturesaura", "network"), () -> VERSION, VERSION::equals, VERSION::equals);
        network.registerMessage(0, PacketParticleStream.class, PacketParticleStream::toBytes, PacketParticleStream::fromBytes, PacketParticleStream::onMessage);
        network.registerMessage(1, PacketParticles.class, PacketParticles::toBytes, PacketParticles::fromBytes, PacketParticles::onMessage);
        network.registerMessage(2, PacketAuraChunk.class, PacketAuraChunk::toBytes, PacketAuraChunk::fromBytes, PacketAuraChunk::onMessage);
        network.registerMessage(3, PacketClient.class, PacketClient::toBytes, PacketClient::fromBytes, PacketClient::onMessage);
    }

    public static void sendToAllLoaded(Level level, BlockPos pos, Object message) {
        network.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(pos)), message);
    }

    public static void sendToAllAround(Level level, BlockPos pos, int range, Object message) {
        network.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)range, level.m_46472_())), message);
    }

    public static void sendTo(Player player, Object message) {
        network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), message);
    }
}

