/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.item.ItemPrimedPendant;

public class ItemPrimedPendantConfig
extends ItemConfig {
    private static final String DELIMITER = ";";
    @ConfigurableProperty(category="item", comment="The capacity of the pendant.", requiresMcRestart=true)
    public static int capacity = 5000;
    @ConfigurableProperty(category="item", comment="The amount of Blood to drain after one effect application.", isCommandable=true)
    public static int usage = 10;
    @ConfigurableProperty(category="item", comment="Usage multipliers. Potion ids are first, followed by floating numbers. A number smaller than one blacklists that potion.")
    public static List<String> potionMultipliers = Lists.newArrayList((Object[])new String[]{"minecraft:health_boost;-1", "minecraft:regeneration;10"});

    public ItemPrimedPendantConfig() {
        super((ModBase)EvilCraft._instance, "primed_pendant", eConfig -> new ItemPrimedPendant(new Item.Properties().m_41487_(1)));
    }

    public static double getMultiplier(MobEffect potion) {
        HashMap multipliers = Maps.newHashMap();
        multipliers.clear();
        for (String line : potionMultipliers) {
            String[] split = line.split(DELIMITER);
            if (split.length != 2) {
                throw new IllegalArgumentException("Invalid line '" + line + "' found for a Primed Pendant potion multiplier config.");
            }
            if (!split[0].equals(ForgeRegistries.MOB_EFFECTS.getKey((Object)potion).toString())) continue;
            try {
                double multiplier = 1.0;
                try {
                    multiplier = Double.parseDouble(split[1]);
                }
                catch (NumberFormatException e) {
                    EvilCraft.clog("Invalid ratio '" + split[1] + "' in a Primed Pendant potion multiplier config, using 1.0.", Level.ERROR);
                }
                return multiplier;
            }
            catch (NumberFormatException e) {
                EvilCraft.clog("Invalid line '" + line + "' found for a Primed Pendant potion multiplier config: " + split[0] + " is not a number; skipping.");
            }
        }
        return 1.0;
    }

    protected Collection<ItemStack> getDefaultCreativeTabEntries() {
        return ((ItemPrimedPendant)((Object)this.getInstance())).getDefaultCreativeTabEntries();
    }
}

