/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.monster;

import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.extendedconfig.EntityConfig;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.client.render.entity.ModelPoisonousLibelle;
import org.cyclops.evilcraft.client.render.entity.RenderPoisonousLibelle;
import org.cyclops.evilcraft.entity.monster.EntityPoisonousLibelle;

public class EntityPoisonousLibelleConfig
extends EntityConfig<EntityPoisonousLibelle> {
    @ConfigurableProperty(category="mob", comment="Should the Poisonous Libelle do damage, next to poisoning?", isCommandable=true)
    public static boolean hasAttackDamage = false;
    @ConfigurableProperty(category="mob", comment="The minimum Y-level this mob can spawn at.", isCommandable=true)
    public static int minY = 55;
    @ConfigurableProperty(category="mob", comment="1/X chance on getting poisoned when hit.", isCommandable=true)
    public static int poisonChance = 20;
    @OnlyIn(value=Dist.CLIENT)
    public static ModelLayerLocation MODEL;

    public EntityPoisonousLibelleConfig() {
        super((ModBase)EvilCraft._instance, "poisonous_libelle", eConfig -> EntityType.Builder.m_20704_(EntityPoisonousLibelle::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.5f, 0.45f).m_20719_(), EntityPoisonousLibelleConfig.getDefaultSpawnEggItemConfigConstructor((ModBase)EvilCraft._instance, (String)"poisonous_libelle_spawn_egg", (int)Helpers.RGBToInt((int)57, (int)125, (int)27), (int)Helpers.RGBToInt((int)196, (int)213, (int)57)));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onEntityAttributeCreationEvent);
        DistExecutor.safeCallWhenOn((Dist)Dist.CLIENT, () -> ModelLoader::registerModel);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onForgeRegistered() {
        super.onForgeRegistered();
        ForgeHooksClient.registerLayerDefinition((ModelLayerLocation)MODEL, ModelPoisonousLibelle::createBodyLayer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public EntityRenderer<? super EntityPoisonousLibelle> getRender(EntityRendererProvider.Context renderContext, ItemRenderer itemRenderer) {
        return new RenderPoisonousLibelle(renderContext, this, new ModelPoisonousLibelle(renderContext.m_174023_(MODEL)), 0.5f);
    }

    public void onEntityAttributeCreationEvent(EntityAttributeCreationEvent event) {
        event.put((EntityType)this.getInstance(), Monster.m_33035_().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22279_, 0.625).m_22265_());
    }

    public static class ModelLoader {
        public static Object registerModel() {
            MODEL = new ModelLayerLocation(new ResourceLocation("evilcraft", "poisonous_libelle"), "main");
            return null;
        }
    }
}

