/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.item;

import com.google.common.collect.Sets;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.algorithm.OrganicSpread;
import org.cyclops.evilcraft.core.entity.item.EntityThrowable;
import org.cyclops.evilcraft.item.ItemBiomeExtract;
import org.cyclops.evilcraft.network.packet.ResetChunkColorsPacket;

public class EntityBiomeExtract
extends EntityThrowable {
    private static final EntityDataAccessor<ItemStack> ITEMSTACK_INDEX = SynchedEntityData.m_135353_(EntityBiomeExtract.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

    public EntityBiomeExtract(EntityType<? extends EntityThrowable> type, Level world) {
        super(type, world);
    }

    public EntityBiomeExtract(Level world) {
        this(RegistryEntries.ENTITY_BIOME_EXTRACT, world);
    }

    public EntityBiomeExtract(Level world, LivingEntity entity) {
        this(world, entity, new ItemStack((ItemLike)RegistryEntries.ITEM_BIOME_EXTRACT));
    }

    public EntityBiomeExtract(Level world, LivingEntity entity, ItemStack stack) {
        super(RegistryEntries.ENTITY_BIOME_EXTRACT, world, entity);
        this.setItemStack(stack);
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_6532_(final HitResult movingobjectposition) {
        if (!this.m_9236_().m_5776_() && movingobjectposition.m_6662_() == HitResult.Type.BLOCK) {
            ItemStack itemStack = this.m_7846_();
            final Biome biome = ItemBiomeExtract.getBiome((Registry<Biome>)this.m_9236_().m_9598_().m_175515_(Registries.f_256952_), itemStack);
            if (biome != null) {
                final HashSet updatedChunks = Sets.newHashSet();
                OrganicSpread spread = new OrganicSpread(this.m_9236_(), 2, 5, new OrganicSpread.IOrganicSpreadable(){

                    @Override
                    public boolean isDone(Level world, BlockPos location) {
                        return world.m_204166_(location).m_203334_() == biome;
                    }

                    @Override
                    public void spreadTo(Level world, BlockPos location) {
                        EntityBiomeExtract.setBiome((ServerLevel)world, location, biome);
                        updatedChunks.add(new ChunkPos(location));
                        int color = biome.m_47542_();
                        EntityBiomeExtract.this.showChangedBiome((ServerLevel)world, new BlockPos(location.m_123341_(), ((BlockHitResult)movingobjectposition).m_82425_().m_123342_(), location.m_123343_()), color);
                    }
                });
                BlockPos pos = BlockPos.m_274446_((Position)movingobjectposition.m_82450_());
                for (int i = 0; i < 50; ++i) {
                    spread.spreadTick(pos);
                }
                if (!this.m_9236_().m_5776_()) {
                    for (ChunkPos chunkPos : updatedChunks) {
                        EntityBiomeExtract.updateChunkAfterBiomeChange(this.m_9236_(), chunkPos);
                    }
                }
            }
            this.m_9236_().m_6798_(2002, this.m_20183_(), 16428);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public static void setBiome(ServerLevel world, BlockPos posIn, Biome biome) {
        BiomeManager biomeManager = world.m_7062_();
        int i = posIn.m_123341_() - 2;
        int j = posIn.m_123342_() - 2;
        int k = posIn.m_123343_() - 2;
        int l = i >> 2;
        int i1 = j >> 2;
        int j1 = k >> 2;
        double d0 = (double)(i & 3) / 4.0;
        double d1 = (double)(j & 3) / 4.0;
        double d2 = (double)(k & 3) / 4.0;
        int k1 = 0;
        double d3 = Double.POSITIVE_INFINITY;
        for (int l1 = 0; l1 < 8; ++l1) {
            double d6;
            double d5;
            double d4;
            boolean flag2;
            int k2;
            boolean flag1;
            int j2;
            boolean flag = (l1 & 4) == 0;
            int i2 = flag ? l : l + 1;
            double d7 = BiomeManager.m_186679_((long)biomeManager.f_47863_, (int)i2, (int)(j2 = (flag1 = (l1 & 2) == 0) ? i1 : i1 + 1), (int)(k2 = (flag2 = (l1 & 1) == 0) ? j1 : j1 + 1), (double)(d4 = flag ? d0 : d0 - 1.0), (double)(d5 = flag1 ? d1 : d1 - 1.0), (double)(d6 = flag2 ? d2 : d2 - 1.0));
            if (!(d3 > d7)) continue;
            k1 = l1;
            d3 = d7;
        }
        int l2 = (k1 & 4) == 0 ? l : l + 1;
        int i3 = (k1 & 2) == 0 ? i1 : i1 + 1;
        int j3 = (k1 & 1) == 0 ? j1 : j1 + 1;
        ChunkAccess chunk = world.m_6522_(QuartPos.m_175406_((int)l2), QuartPos.m_175406_((int)j3), ChunkStatus.f_62317_, false);
        if (chunk instanceof ImposterProtoChunk) {
            chunk = ((ImposterProtoChunk)chunk).m_62768_();
        }
        if (chunk != null) {
            Registry biomeRegistry = world.m_9598_().m_175515_(Registries.f_256952_);
            Holder biomeHack = (Holder)biomeRegistry.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)biomeRegistry.m_7981_((Object)biome))).orElseGet(() -> (Holder.Reference)biomeRegistry.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)ForgeRegistries.BIOMES.getKey((Object)biome))).get());
            int minBuildHeight = QuartPos.m_175400_((int)chunk.m_141937_());
            int maxHeight = minBuildHeight + QuartPos.m_175400_((int)chunk.m_141928_()) - 1;
            int dummyY = Mth.m_14045_((int)i3, (int)minBuildHeight, (int)maxHeight);
            int sectionIndex = chunk.m_151564_(QuartPos.m_175402_((int)dummyY));
            ((PalettedContainer)chunk.f_187612_[sectionIndex].m_187996_()).m_156470_(l2 & 3, dummyY & 3, j3 & 3, (Object)biomeHack);
            chunk.m_8092_(true);
        } else {
            CyclopsCore.clog((org.apache.logging.log4j.Level)org.apache.logging.log4j.Level.WARN, (String)("Tried changing biome at non-existing chunk for position " + posIn));
        }
    }

    public static void updateChunkAfterBiomeChange(Level world, ChunkPos chunkPos) {
        LevelChunk chunkSafe = world.m_7726_().m_62227_(chunkPos.f_45578_, chunkPos.f_45579_, false);
        ((ServerChunkCache)world.m_7726_()).f_8325_.m_183262_(chunkPos, false).forEach(player -> {
            player.f_8906_.m_9829_((Packet)new ClientboundLevelChunkWithLightPacket(chunkSafe, (LevelLightEngine)((ServerChunkCache)world.m_7726_()).f_8325_.m_140166_(), null, null));
            EvilCraft._instance.getPacketHandler().sendToPlayer((PacketBase)new ResetChunkColorsPacket(chunkPos.f_45578_, chunkPos.f_45579_), player);
        });
    }

    private void showChangedBiome(ServerLevel world, BlockPos pos, int color) {
        Triple c = Helpers.intToRGB((int)color);
        RandomSource rand = world.f_46441_;
        for (int j = 0; j < 2 + rand.m_188503_(5); ++j) {
            float x = (float)pos.m_123341_() + -0.5f + rand.m_188501_();
            float y = (float)pos.m_123342_() + -0.5f + rand.m_188501_();
            float z = (float)pos.m_123343_() + -0.5f + rand.m_188501_();
            float scale = 0.2f - rand.m_188501_() * 0.2f;
            float red = ((Float)c.getLeft()).floatValue() + rand.m_188501_() * 0.1f;
            float green = ((Float)c.getMiddle()).floatValue() + rand.m_188501_() * 0.1f;
            float blue = ((Float)c.getRight()).floatValue() + rand.m_188501_() * 0.1f;
            float ageMultiplier = 10 + rand.m_188503_(15);
            double motionX = -0.1f + rand.m_188501_() * 0.2f;
            double motionY = 0.1f + rand.m_188501_() * 0.2f;
            double motionZ = -0.1f + rand.m_188501_() * 0.2f;
            world.m_8767_((ParticleOptions)new ParticleBlurData(red, green, blue, scale, ageMultiplier), (double)x, (double)y, (double)z, 1, motionX, motionY, motionZ, 0.1);
        }
    }

    protected float m_7139_() {
        return 0.1f;
    }

    public ItemStack m_7846_() {
        return (ItemStack)this.f_19804_.m_135370_(ITEMSTACK_INDEX);
    }

    private void setItemStack(ItemStack stack) {
        this.f_19804_.m_135381_(ITEMSTACK_INDEX, (Object)stack);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ITEMSTACK_INDEX, (Object)new ItemStack((ItemLike)RegistryEntries.ITEM_BIOME_EXTRACT));
    }
}

