/*
 * Decompiled with CFR 0.152.
 */
package commoble.hyperbox.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class ReturnPointCapability
implements ICapabilitySerializable<CompoundTag> {
    public static final Capability<ReturnPointCapability> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<ReturnPointCapability>(){});
    public static final ResourceLocation ID = new ResourceLocation("hyperbox", "return_point");
    private final LazyOptional<ReturnPointCapability> holder = LazyOptional.of(() -> this);
    public Optional<Data> data = Optional.empty();

    public void setReturnPoint(ResourceKey<Level> key, BlockPos pos) {
        this.data = Optional.of(new Data(key, pos));
    }

    public static ContainerLevelAccess getReturnPoint(ServerPlayer player) {
        MinecraftServer server = player.m_20194_();
        return player.getCapability(INSTANCE).resolve().flatMap(cap -> cap.data.flatMap(data -> data.getWorldPosCallable((ReturnPointCapability)cap, server))).orElseGet(() -> {
            ServerLevel targetWorld = server.m_129880_(player.m_8963_());
            if (targetWorld == null) {
                targetWorld = server.m_129880_(Level.f_46428_);
            }
            return ContainerLevelAccess.m_39289_((Level)targetWorld, (BlockPos)targetWorld.m_220360_());
        });
    }

    public CompoundTag serializeNBT() {
        return (CompoundTag)this.data.flatMap(d -> Data.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, d).result()).orElseGet(CompoundTag::new);
    }

    public void deserializeNBT(CompoundTag tag) {
        this.data = Data.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag).result();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return cap == INSTANCE ? INSTANCE.orEmpty(cap, this.holder) : LazyOptional.empty();
    }

    private record Data(ResourceKey<Level> lastWorld, BlockPos lastPos) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.xmap(s -> ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)s), ResourceKey::m_135782_).fieldOf("last_world").forGetter(Data::lastWorld), (App)BlockPos.f_121852_.fieldOf("last_pos").forGetter(Data::lastPos)).apply((Applicative)instance, Data::new));

        public Optional<ContainerLevelAccess> getWorldPosCallable(ReturnPointCapability cap, MinecraftServer server) {
            ServerLevel world = server.m_129880_(this.lastWorld);
            if (world == null) {
                cap.data = Optional.empty();
                return Optional.empty();
            }
            return Optional.of(ContainerLevelAccess.m_39289_((Level)world, (BlockPos)this.lastPos));
        }
    }
}

