/*
 * Decompiled with CFR 0.152.
 */
package commoble.hyperbox.client;

import commoble.hyperbox.ConfigHelper;
import commoble.hyperbox.Hyperbox;
import commoble.hyperbox.RotationHelper;
import commoble.hyperbox.blocks.HyperboxBlock;
import commoble.hyperbox.client.BlockPreviewRenderer;
import commoble.hyperbox.client.ClientConfig;
import commoble.hyperbox.client.ColorHandlers;
import commoble.hyperbox.client.HyperboxBlockEntityRenderer;
import commoble.hyperbox.client.HyperboxRenderInfo;
import commoble.hyperbox.client.HyperboxScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ClientProxy {
    public static ClientConfig clientConfig = null;

    public static void doClientModInit(IEventBus modBus, IEventBus forgeBus) {
        clientConfig = ConfigHelper.register(ModConfig.Type.CLIENT, ClientConfig::new);
        modBus.addListener(ClientProxy::onClientSetup);
        modBus.addListener(ClientProxy::onRegisterDimensionSpecialEffects);
        modBus.addListener(ClientProxy::onRegisterRenderers);
        modBus.addListener(ClientProxy::onRegisterBlockColors);
        modBus.addListener(ClientProxy::onRegisterItemColors);
        forgeBus.addListener(ClientProxy::onHighlightBlock);
    }

    private static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(ClientProxy::afterClientSetup);
    }

    private static void afterClientSetup() {
        MenuScreens.m_96206_((MenuType)((MenuType)Hyperbox.INSTANCE.hyperboxMenuType.get()), HyperboxScreen::new);
    }

    private static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)Hyperbox.INSTANCE.hyperboxBlockEntityType.get(), HyperboxBlockEntityRenderer::new);
    }

    private static void onRegisterDimensionSpecialEffects(RegisterDimensionSpecialEffectsEvent event) {
        event.register(Hyperbox.HYPERBOX_ID, (DimensionSpecialEffects)new HyperboxRenderInfo());
    }

    private static void onRegisterBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register(ColorHandlers::getHyperboxBlockColor, new Block[]{(Block)Hyperbox.INSTANCE.hyperboxBlock.get()});
        event.register(ColorHandlers::getHyperboxPreviewBlockColor, new Block[]{(Block)Hyperbox.INSTANCE.hyperboxPreviewBlock.get()});
        event.register(ColorHandlers::getApertureBlockColor, new Block[]{(Block)Hyperbox.INSTANCE.apertureBlock.get()});
    }

    private static void onRegisterItemColors(RegisterColorHandlersEvent.Item event) {
        event.register(ColorHandlers::getHyperboxItemColor, new ItemLike[]{(ItemLike)Hyperbox.INSTANCE.hyperboxItem.get()});
    }

    private static void onHighlightBlock(RenderHighlightEvent.Block event) {
        if (((Boolean)ClientProxy.clientConfig.showPlacementPreview.get()).booleanValue()) {
            BlockItem blockItem;
            Block block;
            InteractionHand hand;
            Item item;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            Level level = player.m_9236_();
            if (player != null && level != null && (item = player.m_21120_((hand = player.m_7655_()) == null ? InteractionHand.MAIN_HAND : hand).m_41720_()) instanceof BlockItem && (block = (blockItem = (BlockItem)item).m_40614_()) instanceof HyperboxBlock) {
                HyperboxBlock hyperboxBlock = (HyperboxBlock)block;
                BlockHitResult rayTrace = event.getTarget();
                Direction directionAwayFromTargetedBlock = rayTrace.m_82434_();
                BlockPos placePos = rayTrace.m_82425_().m_121945_(directionAwayFromTargetedBlock);
                BlockState existingState = level.m_8055_(placePos);
                if (existingState.m_60795_() || existingState.m_247087_()) {
                    Vec3 hitVec = rayTrace.m_82450_();
                    Direction attachmentDirection = directionAwayFromTargetedBlock.m_122424_();
                    Vec3 relativeHitVec = hitVec.m_82546_(Vec3.m_82528_((Vec3i)placePos));
                    Direction outputDirection = RotationHelper.getOutputDirectionFromRelativeHitVec(relativeHitVec, attachmentDirection);
                    RotationHelper.getRotationIndexForDirection(attachmentDirection, outputDirection);
                    BlockState state = HyperboxBlock.getStateForPlacement(((HyperboxBlock)((Object)Hyperbox.INSTANCE.hyperboxPreviewBlock.get())).m_49966_(), placePos, attachmentDirection, relativeHitVec);
                    BlockPreviewRenderer.renderBlockPreview(placePos, state, level, event.getCamera().m_90583_(), event.getPoseStack(), event.getMultiBufferSource());
                }
            }
        }
    }
}

