/*
 * Decompiled with CFR 0.152.
 */
package commoble.hyperbox.blocks;

import commoble.hyperbox.Hyperbox;
import commoble.hyperbox.blocks.ApertureBlock;
import commoble.hyperbox.blocks.HyperboxBlock;
import commoble.hyperbox.dimension.HyperboxWorldData;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;

public class ApertureBlockEntity
extends BlockEntity {
    public static final String WEAK_POWER = "weak_power";
    public static final String STRONG_POWER = "strong_power";
    public static final String COLOR = "color";
    private int weakPower = 0;
    private int strongPower = 0;
    private int color = 4863306;

    public static ApertureBlockEntity create(BlockPos pos, BlockState state) {
        return new ApertureBlockEntity((BlockEntityType<? extends ApertureBlockEntity>)((BlockEntityType)Hyperbox.INSTANCE.apertureBlockEntityType.get()), pos, state);
    }

    public ApertureBlockEntity(BlockEntityType<? extends ApertureBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        Level level;
        if (side != null && (level = this.f_58857_) instanceof ServerLevel) {
            HyperboxBlock hyperboxBlock;
            Direction hyperboxFace;
            BlockPos delegatePos;
            BlockEntity delegateBlockEntity;
            BlockState parentState;
            Block parentBlock;
            ServerLevel serverLevel = (ServerLevel)level;
            MinecraftServer server = serverLevel.m_7654_();
            HyperboxWorldData data = HyperboxWorldData.getOrCreate(serverLevel);
            BlockPos parentPos = data.getParentPos();
            ResourceKey<Level> parentLevelKey = data.getParentWorld();
            ServerLevel parentLevel = server.m_129880_(parentLevelKey);
            if (parentLevel != null && (parentBlock = (parentState = parentLevel.m_8055_(parentPos)).m_60734_()) instanceof HyperboxBlock && (delegateBlockEntity = parentLevel.m_7702_(delegatePos = parentPos.m_121945_(hyperboxFace = (hyperboxBlock = (HyperboxBlock)parentBlock).getCurrentFacing(parentState, side.m_122424_())))) != null) {
                return delegateBlockEntity.getCapability(cap, hyperboxFace.m_122424_());
            }
        }
        return super.getCapability(cap, side);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        if (this.color != color) {
            this.color = color;
            this.m_6596_();
            BlockState state = this.m_58900_();
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public int getPower(boolean strong) {
        int output = (strong ? this.strongPower : this.weakPower) - 1;
        return Mth.m_14045_((int)output, (int)0, (int)15);
    }

    public void updatePower(ServerLevel parentWorld, BlockPos neighborPos, BlockState neighborState, Direction directionToNeighbor) {
        int weakPower = neighborState.m_60746_((BlockGetter)parentWorld, neighborPos, directionToNeighbor);
        int strongPower = neighborState.m_60775_((BlockGetter)parentWorld, neighborPos, directionToNeighbor);
        this.updatePower(weakPower, strongPower);
    }

    public void updatePower(int weakPower, int strongPower) {
        if (this.weakPower != weakPower || this.strongPower != strongPower) {
            this.weakPower = weakPower;
            this.strongPower = strongPower;
            BlockState thisState = this.m_58900_();
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, thisState, thisState, 3);
            Direction outputSide = (Direction)thisState.m_61143_((Property)ApertureBlock.FACING);
            if (ForgeEventFactory.onNeighborNotify((Level)this.f_58857_, (BlockPos)this.f_58858_, (BlockState)thisState, EnumSet.of(outputSide), (boolean)true).isCanceled()) {
                return;
            }
            BlockPos adjacentPos = this.f_58858_.m_121945_(outputSide);
            Block thisBlock = thisState.m_60734_();
            this.f_58857_.m_46586_(adjacentPos, thisBlock, this.f_58858_);
            this.f_58857_.m_46590_(adjacentPos, thisBlock, outputSide.m_122424_());
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.writeClientSensitiveData(compound);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.readClientSensitiveData(nbt);
    }

    public CompoundTag writeClientSensitiveData(CompoundTag nbt) {
        nbt.m_128405_(WEAK_POWER, this.weakPower);
        nbt.m_128405_(STRONG_POWER, this.strongPower);
        if (this.color != 4863306) {
            nbt.m_128405_(COLOR, this.color);
        }
        return nbt;
    }

    public void readClientSensitiveData(CompoundTag nbt) {
        this.weakPower = nbt.m_128451_(WEAK_POWER);
        this.strongPower = nbt.m_128451_(STRONG_POWER);
        if (nbt.m_128441_(COLOR)) {
            this.color = nbt.m_128451_(COLOR);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.writeClientSensitiveData(nbt);
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.readClientSensitiveData(pkt.m_131708_());
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.readClientSensitiveData(tag);
    }
}

