/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.util;

import dev.murad.shipping.util.LocoRouteNode;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class LocoRoute
extends HashSet<LocoRouteNode> {
    private static final String NAME_TAG = "name";
    private static final String OWNER_TAG = "owner";
    private static final String NODES_TAG = "nodes";
    @Nullable
    private String name;
    @Nullable
    private String owner;

    public LocoRoute(@Nullable String name, @Nullable String owner, Set<LocoRouteNode> nodes) {
        super(nodes);
        this.name = name;
        this.owner = owner;
    }

    public LocoRoute(Set<LocoRouteNode> nodes) {
        this(null, null, nodes);
    }

    public LocoRoute() {
        this(null, null, new HashSet<LocoRouteNode>());
    }

    public boolean hasCustomName() {
        return this.name != null;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LocoRoute that = (LocoRoute)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.owner, that.owner);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.owner);
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (LocoRouteNode node : this) {
            list.add((Object)node.toNBT());
        }
        tag.m_128365_(NODES_TAG, (Tag)list);
        if (this.hasCustomName()) {
            tag.m_128359_(NAME_TAG, this.name);
        }
        if (this.hasOwner()) {
            tag.m_128359_(OWNER_TAG, this.owner);
        }
        return tag;
    }

    public static LocoRoute fromNBT(CompoundTag tag) {
        String name = null;
        String owner = null;
        if (tag.m_128441_(NAME_TAG)) {
            name = tag.m_128461_(NAME_TAG);
        }
        if (tag.m_128441_(OWNER_TAG)) {
            owner = tag.m_128461_(OWNER_TAG);
        }
        ListTag nodesNBT = tag.m_128437_(NODES_TAG, 10);
        HashSet<LocoRouteNode> nodes = new HashSet<LocoRouteNode>();
        for (int i = 0; i < nodesNBT.size(); ++i) {
            nodes.add(LocoRouteNode.fromNBT(nodesNBT.m_128728_(i)));
        }
        return new LocoRoute(name, owner, nodes);
    }
}

