/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.data;

import de.srendi.advancedperipherals.common.blocks.base.IHarvestableBlock;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockTagsProvider
extends TagsProvider<Block> {
    @NotNull
    private final DeferredRegister<Block> blockRegistry;
    @NotNull
    private final PackOutput packOutput;

    protected BlockTagsProvider(@NotNull PackOutput packOutput, CompletableFuture<HolderLookup.Provider> future, @Nullable ExistingFileHelper existingFileHelper, DeferredRegister<Block> registry) {
        super(packOutput, ForgeRegistries.BLOCKS.getRegistryKey(), future, "advancedperipherals", existingFileHelper);
        this.packOutput = packOutput;
        this.blockRegistry = registry;
    }

    protected void m_6577_(@NotNull HolderLookup.Provider provider) {
        this.blockRegistry.getEntries().stream().map(RegistryObject::get).forEach(block -> {
            if (!(block instanceof IHarvestableBlock)) {
                throw new IllegalArgumentException("For any block you should define harvester logic!");
            }
            IHarvestableBlock harvesterBlock = (IHarvestableBlock)block;
            this.m_206424_(harvesterBlock.getHarvestTag()).m_255204_((ResourceKey)ForgeRegistries.BLOCKS.getResourceKey(block).get());
            this.m_206424_(harvesterBlock.getToolTag()).m_255204_((ResourceKey)ForgeRegistries.BLOCKS.getResourceKey(block).get());
        });
    }

    protected Path getPath(ResourceLocation block) {
        return this.packOutput.m_245114_().resolve("data/" + block.m_135827_() + "/tags/blocks/" + block.m_135815_() + ".json");
    }

    @NotNull
    public String m_6055_() {
        return "Block tags";
    }
}

