/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.villager.trades;

import com.almostreliable.morejs.features.villager.TradeItem;
import com.almostreliable.morejs.features.villager.trades.TransformableTrade;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class PotionTrade
extends TransformableTrade<PotionTrade> {
    List<Potion> potions;
    private Item itemForPotion = Items.f_42589_;
    private boolean onlyBrewablePotion;
    private boolean noBrewablePotion;

    public PotionTrade(TradeItem[] inputs) {
        super(inputs);
        this.potions = BuiltInRegistries.f_256980_.m_123024_().toList();
    }

    public PotionTrade item(Item item) {
        this.itemForPotion = item;
        return this;
    }

    public PotionTrade potions(Potion ... potions) {
        this.potions = Arrays.stream(potions).peek(e -> {
            if (e == null) {
                ConsoleJS.SERVER.error((Object)("Null potion in array: " + Arrays.toString(potions)));
            }
        }).filter(Objects::nonNull).toList();
        return this;
    }

    public PotionTrade onlyBrewablePotion() {
        this.onlyBrewablePotion = true;
        return this;
    }

    public PotionTrade noBrewablePotion() {
        this.noBrewablePotion = false;
        return this;
    }

    @Override
    @Nullable
    public MerchantOffer createOffer(Entity entity, RandomSource random) {
        List<Potion> allowedPotions = this.potions.stream().filter(p -> {
            if (p.m_43488_().isEmpty()) {
                return false;
            }
            if (this.onlyBrewablePotion) {
                return PotionBrewing.m_43511_((Potion)p);
            }
            if (this.noBrewablePotion) {
                return !PotionBrewing.m_43511_((Potion)p);
            }
            return true;
        }).toList();
        if (allowedPotions.isEmpty()) {
            return null;
        }
        Potion potion = allowedPotions.get(random.m_188503_(this.potions.size()));
        ItemStack potionStack = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)this.itemForPotion), (Potion)potion);
        return this.createOffer(potionStack, random);
    }
}

