/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs;

import com.almostreliable.morejs.features.villager.IntRange;
import com.almostreliable.morejs.features.villager.TradeFilter;
import com.almostreliable.morejs.features.villager.TradeItem;
import com.almostreliable.morejs.features.villager.TradeTypes;
import com.almostreliable.morejs.util.LevelUtils;
import com.almostreliable.morejs.util.ResourceOrTag;
import com.almostreliable.morejs.util.Utils;
import com.almostreliable.morejs.util.WeightedList;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;

public class MoreJSBinding {
    @Nullable
    public static BlockPos findStructure(BlockPos position, ServerLevel level, String structure, int chunkRadius) {
        ResourceOrTag<Structure> rot = ResourceOrTag.get(structure, Registries.f_256944_);
        return LevelUtils.findStructure(position, level, rot, chunkRadius);
    }

    @Nullable
    public static BlockPos findBiome(BlockPos position, ServerLevel level, String biome, int chunkRadius) {
        ResourceOrTag<Biome> rot = ResourceOrTag.get(biome, Registries.f_256952_);
        return LevelUtils.findBiome(position, level, rot, chunkRadius);
    }

    public static WeightedList.Builder<Object> weightedList() {
        return new WeightedList.Builder<Object>();
    }

    public static IntRange range(@Nullable Object o) {
        if (o instanceof Number) {
            Number number = (Number)o;
            return new IntRange(number.intValue());
        }
        if (o instanceof List) {
            List list = (List)o;
            return switch (list.size()) {
                case 0 -> IntRange.all();
                case 1 -> MoreJSBinding.range(list.get(0));
                default -> new IntRange(UtilsJS.parseInt(list.get(0), (int)1), UtilsJS.parseInt(list.get(0), (int)5));
            };
        }
        return IntRange.all();
    }

    public static WeightedList<Object> ofWeightedList(@Nullable Object o) {
        if (o instanceof WeightedList.Builder) {
            WeightedList.Builder b = (WeightedList.Builder)o;
            return b.build();
        }
        if (o instanceof WeightedList) {
            return (WeightedList)Utils.cast(o);
        }
        WeightedList.Builder<Object> builder = new WeightedList.Builder<Object>();
        for (Object entry : Utils.asList(o)) {
            List<Object> weightValue = Utils.asList(entry);
            if (weightValue.size() == 2) {
                builder.add(UtilsJS.parseInt((Object)weightValue.get(0), (int)1), weightValue.get(1));
                continue;
            }
            builder.add(1, entry);
        }
        return builder.build();
    }

    public static TradeFilter ofTradeFilter(@Nullable Object o) {
        Object allTypes;
        List list;
        if (o instanceof TradeFilter) {
            TradeFilter filter = (TradeFilter)o;
            return filter;
        }
        if (!(o instanceof Map)) {
            return new TradeFilter(Ingredient.f_43901_, Ingredient.f_43901_, Ingredient.f_43901_);
        }
        Map map = (Map)o;
        if (!(map.containsKey("firstItem") && map.containsKey("secondItem") && map.containsKey("outputItem"))) {
            ConsoleJS.SERVER.error((Object)"Trade filter must contain firstItem, secondItem and outputItem");
            return new TradeFilter(Ingredient.f_43901_, Ingredient.f_43901_, Ingredient.f_43901_);
        }
        TradeFilter filter = new TradeFilter(IngredientJS.of(map.get("firstItem")), IngredientJS.of(map.get("secondItem")), IngredientJS.of(map.get("outputItem")));
        filter.setFirstCountMatcher(MoreJSBinding.range(map.get("firstCount")));
        filter.setSecondCountMatcher(MoreJSBinding.range(map.get("secondCount")));
        filter.setOutputCountMatcher(MoreJSBinding.range(map.get("outputCount")));
        Object v = map.get("types");
        if (v instanceof List) {
            list = (List)v;
            allTypes = Stream.of(TradeTypes.values()).map(Enum::name).collect(Collectors.toSet());
            Set<TradeTypes> types = list.stream().map(Object::toString).filter(arg_0 -> allTypes.contains(arg_0)).map(TradeTypes::valueOf).collect(Collectors.toSet());
            filter.setTradeTypes(types);
        }
        if ((allTypes = map.get("professions")) instanceof List) {
            list = (List)allTypes;
            Set<VillagerProfession> professions = list.stream().map(Object::toString).map(ResourceLocation::m_135820_).filter(Objects::nonNull).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_256735_).m_6612_(arg_0)).flatMap(Optional::stream).collect(Collectors.toSet());
            filter.setProfessions(professions);
        }
        filter.setMerchantLevelMatcher(MoreJSBinding.range(map.get("level")));
        return filter;
    }

    public static TradeItem ofTradeItem(@Nullable Object o) {
        if (o instanceof TradeItem) {
            TradeItem item = (TradeItem)o;
            return item;
        }
        return TradeItem.of(ItemStackJS.of((Object)o));
    }
}

