/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.functionalflora;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.functionalflora.base.FunctionalFlowerBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.moddingx.libx.LibX;
import vazkii.botania.api.block.PetalApothecary;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.client.fx.WispParticleData;

public class Aquapanthus
extends FunctionalFlowerBase {
    public static final int MAX_TICK_TO_NEXT_CHECK = 5;
    public static final int MANA_PER_TICK = 2;
    public static final int TICKS_TO_FILL = 20;
    public static final Set<ResourceLocation> FILLING_SLOW_IDS = ImmutableSet.of((Object)new ResourceLocation("exnihilosequentia", "barrel_wood"), (Object)new ResourceLocation("exnihilosequentia", "barrel_stone"), (Object)new ResourceLocation("excompressum", "oak_crucible"), (Object)new ResourceLocation("excompressum", "spruce_crucible"), (Object)new ResourceLocation("excompressum", "birch_crucible"), (Object)new ResourceLocation("excompressum", "jungle_crucible"), (Object[])new ResourceLocation[]{new ResourceLocation("excompressum", "acacia_crucible"), new ResourceLocation("excompressum", "dark_oak_crucible")});
    public static final Set<ResourceLocation> FILLING_FAST_IDS = ImmutableSet.of((Object)new ResourceLocation("exnihilosequentia", "crucible_wood"), (Object)new ResourceLocation("exnihilosequentia", "crucible_fired"));
    private transient int tickToNextCheck = 0;
    @Nullable
    private BlockPos currentlyFilling = null;
    private int fillingSince = 0;

    public Aquapanthus(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, 0x4444FF, false);
    }

    @Override
    protected void tickFlower() {
        block11: {
            if (!this.f_58857_.f_46443_) {
                if (this.currentlyFilling != null) {
                    if (this.mana >= 2) {
                        if (this.fill()) {
                            this.mana = Mth.m_14045_((int)(this.mana - 2), (int)0, (int)this.maxMana);
                            this.didWork = true;
                            ++this.fillingSince;
                        } else {
                            this.fillingSince = 0;
                            this.currentlyFilling = null;
                        }
                    }
                    LibX.getNetwork().updateBE(this.f_58857_, this.f_58858_);
                    this.m_6596_();
                } else {
                    if (this.tickToNextCheck > 0) {
                        --this.tickToNextCheck;
                        return;
                    }
                    this.tickToNextCheck = 5;
                    BlockPos basePos = this.f_58858_.m_7949_();
                    for (int xd = -3; xd <= 3; ++xd) {
                        for (int zd = -3; zd <= 3; ++zd) {
                            BlockEntity te;
                            BlockPos pos = basePos.m_7918_(xd, 0, zd);
                            BlockState state = this.f_58857_.m_8055_(pos);
                            if (!this.canFill(state, te = this.f_58857_.m_7702_(pos))) continue;
                            this.currentlyFilling = pos;
                            this.fillingSince = 0;
                            this.m_6596_();
                            break block11;
                        }
                    }
                }
            } else if (this.currentlyFilling != null && this.fillingSince > 0) {
                double progress = (double)this.fillingSince / 20.0;
                double x = (double)(this.currentlyFilling.m_123341_() - this.f_58858_.m_123341_()) * progress + (double)this.f_58858_.m_123341_() + 0.5;
                double y = (double)this.f_58858_.m_123342_() + 1.5 * Math.sin(progress * Math.PI);
                double z = (double)(this.currentlyFilling.m_123343_() - this.f_58858_.m_123343_()) * progress + (double)this.f_58858_.m_123343_() + 0.5;
                double xd = (double)(this.currentlyFilling.m_123341_() - this.f_58858_.m_123341_()) * progress / 10.0;
                double yd = Math.sin(progress * Math.PI) / 10.0;
                double zd = (double)(this.currentlyFilling.m_123343_() - this.f_58858_.m_123343_()) * progress / 10.0;
                WispParticleData data = WispParticleData.wisp((float)0.85f, (float)0.1f, (float)0.1f, (float)1.0f, (float)0.25f);
                this.f_58857_.m_7106_((ParticleOptions)data, x, y, z, xd, yd, zd);
                data = WispParticleData.wisp((float)((float)Math.random() * 0.1f + 0.1f), (float)0.2f, (float)0.2f, (float)1.0f, (float)0.9f);
                this.f_58857_.m_7106_((ParticleOptions)data, x, y, z, (double)((float)(Math.random() - 0.5) * 0.05f), (double)((float)(Math.random() - 0.5) * 0.05f), (double)((float)(Math.random() - 0.5) * 0.05f));
            }
        }
    }

    private boolean canFill(BlockState state, @Nullable BlockEntity te) {
        if (state.m_60734_() == Blocks.f_50256_ || state.m_60734_() == Blocks.f_152476_ && (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) < 3) {
            return true;
        }
        if (te instanceof PetalApothecary && ((PetalApothecary)te).getFluid() == PetalApothecary.State.EMPTY) {
            return true;
        }
        if ((FILLING_SLOW_IDS.contains(ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_())) || FILLING_FAST_IDS.contains(ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()))) && te != null) {
            IFluidHandler handler = (IFluidHandler)te.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.UP).orElse(null);
            if (handler != null) {
                int filled = FILLING_FAST_IDS.contains(ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_())) ? handler.fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.SIMULATE) : handler.fill(new FluidStack((Fluid)Fluids.f_76193_, 334), IFluidHandler.FluidAction.SIMULATE);
                return filled > 0 && handler.getFluidInTank(0).getAmount() < handler.getTankCapacity(0);
            }
            return false;
        }
        return false;
    }

    private boolean fill() {
        BlockState state = this.f_58857_.m_8055_(this.currentlyFilling);
        BlockEntity be = this.f_58857_.m_7702_(this.currentlyFilling);
        if (state.m_60734_() == Blocks.f_50256_ || state.m_60734_() == Blocks.f_152476_ && (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) < 3 || be instanceof PetalApothecary && ((PetalApothecary)be).getFluid() == PetalApothecary.State.EMPTY) {
            if (this.fillingSince >= 20) {
                if (state.m_60734_() == Blocks.f_50256_) {
                    this.f_58857_.m_46597_(this.currentlyFilling, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(1)));
                } else if (state.m_60734_() == Blocks.f_152476_) {
                    this.f_58857_.m_46597_(this.currentlyFilling, (BlockState)state.m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(Mth.m_14045_((int)((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) + 1), (int)0, (int)3))));
                } else if (be instanceof PetalApothecary) {
                    ((PetalApothecary)be).setFluid(PetalApothecary.State.WATER);
                    be.m_6596_();
                }
                return false;
            }
            return true;
        }
        if ((FILLING_SLOW_IDS.contains(ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_())) || FILLING_FAST_IDS.contains(ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()))) && be != null) {
            if (this.fillingSince >= 20) {
                IFluidHandler handler = (IFluidHandler)be.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.UP).orElse(null);
                if (handler != null) {
                    if (FILLING_FAST_IDS.contains(ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()))) {
                        handler.fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE);
                    } else {
                        handler.fill(new FluidStack((Fluid)Fluids.f_76193_, 334), IFluidHandler.FluidAction.EXECUTE);
                    }
                    be.m_6596_();
                }
                return false;
            }
            return this.canFill(state, be);
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((BlockPos)this.f_58858_, (int)3);
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("waterFilling")) {
            CompoundTag fillingTag = nbt.m_128469_("waterFilling");
            this.currentlyFilling = new BlockPos(fillingTag.m_128451_("x"), fillingTag.m_128451_("y"), fillingTag.m_128451_("z"));
        } else {
            this.currentlyFilling = null;
        }
        this.fillingSince = nbt.m_128451_("filling_since");
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.currentlyFilling != null) {
            CompoundTag fillingTag = new CompoundTag();
            fillingTag.m_128405_("x", this.currentlyFilling.m_123341_());
            fillingTag.m_128405_("y", this.currentlyFilling.m_123342_());
            fillingTag.m_128405_("z", this.currentlyFilling.m_123343_());
            nbt.m_128365_("waterFilling", (Tag)fillingTag);
            nbt.m_128405_("filling_since", this.fillingSince);
        }
    }

    @Override
    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        if (!this.f_58857_.f_46443_) {
            if (this.currentlyFilling != null) {
                CompoundTag fillingTag = new CompoundTag();
                fillingTag.m_128405_("x", this.currentlyFilling.m_123341_());
                fillingTag.m_128405_("y", this.currentlyFilling.m_123342_());
                fillingTag.m_128405_("z", this.currentlyFilling.m_123343_());
                updateTag.m_128365_("waterFilling", (Tag)fillingTag);
            }
            updateTag.m_128405_("filling_since", this.fillingSince);
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        if (this.f_58857_.f_46443_) {
            if (tag.m_128441_("waterFilling")) {
                CompoundTag fillingTag = tag.m_128469_("waterFilling");
                this.currentlyFilling = new BlockPos(fillingTag.m_128451_("x"), fillingTag.m_128451_("y"), fillingTag.m_128451_("z"));
            } else {
                this.currentlyFilling = null;
            }
            this.fillingSince = tag.m_128451_("filling_since");
        }
        super.handleUpdateTag(tag);
    }
}

