/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigurablePropertyData;
import org.cyclops.cyclopscore.config.IConfigInitializer;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigForge;
import org.cyclops.cyclopscore.config.extendedconfig.FluidConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.init.ModBase;

public class ConfigHandler {
    private final ModBase mod;
    private final LinkedHashSet<ExtendedConfig<?, ?>> configurables = new LinkedHashSet();
    private final Map<String, ExtendedConfig<?, ?>> configDictionary = Maps.newHashMap();
    private final Set<String> categories = Sets.newHashSet();
    private final Map<String, ConfigurablePropertyData> commandableProperties = Maps.newHashMap();
    private final Multimap<String, Pair<ExtendedConfigForge<?, ?>, Callable<?>>> registryEntriesHolder = Multimaps.newListMultimap((Map)Maps.newHashMap(), (Supplier)new Supplier<List<Pair<ExtendedConfigForge<?, ?>, Callable<?>>>>(){

        public List<Pair<ExtendedConfigForge<?, ?>, Callable<?>>> get() {
            return Lists.newArrayList();
        }
    });
    private Set<String> registryEventPassed = Sets.newHashSet();

    public ConfigHandler(ModBase mod) {
        this.mod = mod;
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
    }

    public void initialize(Collection<IConfigInitializer> configInitializers) {
        EnumMap<ModConfig.Type, ForgeConfigSpec.Builder> configBuilders = new EnumMap<ModConfig.Type, ForgeConfigSpec.Builder>(ModConfig.Type.class);
        for (ExtendedConfig extendedConfig : this.configurables) {
            ForgeConfigSpec.Builder configBuilder = (ForgeConfigSpec.Builder)configBuilders.get(ModConfig.Type.COMMON);
            if (configBuilder == null) {
                configBuilder = new ForgeConfigSpec.Builder();
                configBuilders.put(ModConfig.Type.COMMON, configBuilder);
            }
            this.addCategory(extendedConfig.getConfigurableType().getCategory());
            for (ConfigurablePropertyData<?> configProperty : extendedConfig.configProperties.values()) {
                ForgeConfigSpec.Builder configBuilderProperty = (ForgeConfigSpec.Builder)configBuilders.get(configProperty.getConfigLocation());
                if (configBuilderProperty == null) {
                    configBuilderProperty = new ForgeConfigSpec.Builder();
                    configBuilders.put(configProperty.getConfigLocation(), configBuilderProperty);
                }
                this.categories.add(configProperty.getCategory());
                configProperty.onConfigInit(configBuilder);
                if (!configProperty.isCommandable()) continue;
                this.commandableProperties.put(configProperty.getName(), configProperty);
            }
        }
        for (IConfigInitializer iConfigInitializer : configInitializers) {
            iConfigInitializer.initializeConfig(configBuilders);
        }
        for (Map.Entry entry : configBuilders.entrySet()) {
            ModLoadingContext.get().registerConfig((ModConfig.Type)entry.getKey(), (IConfigSpec)((ForgeConfigSpec.Builder)entry.getValue()).build());
        }
    }

    @SubscribeEvent
    public void onLoad(ModConfigEvent.Loading configEvent) {
        this.mod.log(Level.TRACE, "Load config");
        this.syncProcessedConfigs(configEvent.getConfig(), false);
    }

    @SubscribeEvent
    public void onReload(ModConfigEvent.Reloading configEvent) {
        this.mod.log(Level.TRACE, "Reload config");
        this.syncProcessedConfigs(configEvent.getConfig(), true);
    }

    public boolean addConfigurable(ExtendedConfig<?, ?> e) {
        this.addToConfigDictionary(e);
        return this.configurables.add(e);
    }

    public void addToConfigDictionary(ExtendedConfig<?, ?> e) {
        if (e instanceof BlockConfig || e instanceof ItemConfig || e instanceof FluidConfig) {
            this.configDictionary.put(e.getNamedId(), e);
        }
    }

    public void loadModInit() {
        for (ExtendedConfig extendedConfig : this.configurables) {
            this.mod.log(Level.TRACE, "Registering " + extendedConfig.getNamedId());
            extendedConfig.getConfigurableType().getConfigurableTypeAction().onRegisterModInit(extendedConfig);
        }
    }

    public void loadForgeRegistries() {
        for (ExtendedConfig extendedConfig : this.configurables) {
            extendedConfig.getConfigurableType().getConfigurableTypeAction().onRegisterForge(extendedConfig);
        }
    }

    public void loadForgeRegistriesFilled() {
        for (ExtendedConfig extendedConfig : this.configurables) {
            extendedConfig.getConfigurableType().getConfigurableTypeAction().onRegisterForgeFilled(extendedConfig);
        }
    }

    public void loadSetup() {
        for (ExtendedConfig extendedConfig : this.configurables) {
            extendedConfig.getConfigurableType().getConfigurableTypeAction().onRegisterSetup(extendedConfig);
            extendedConfig.onRegistered();
        }
    }

    public void addCategory(String category) {
        this.categories.add(category);
    }

    public void syncProcessedConfigs(ModConfig config, boolean reload) {
        for (ExtendedConfig extendedConfig : this.configurables) {
            for (ConfigurablePropertyData<?> configProperty : extendedConfig.configProperties.values()) {
                configProperty.saveToField();
                extendedConfig.onConfigPropertyReload(configProperty, reload);
            }
        }
    }

    public Map<String, ExtendedConfig<?, ?>> getDictionary() {
        return this.configDictionary;
    }

    public <V> void registerToRegistry(IForgeRegistry<? super V> registry, ExtendedConfigForge<?, V> config, @Nullable Callable<?> callback) {
        if (this.registryEventPassed.contains(registry.getRegistryKey().toString())) {
            throw new IllegalStateException(String.format("Tried registering %s after its registration event.", config.getNamedId()));
        }
        this.registryEntriesHolder.put((Object)registry.getRegistryKey().toString(), (Object)Pair.of(config, callback));
    }

    @SubscribeEvent
    public void onRegistryEvent(RegisterEvent event) {
        if (event.getForgeRegistry() != null) {
            this.registryEventPassed.add(event.getRegistryKey().toString());
            IForgeRegistry registry = event.getForgeRegistry();
            this.registryEntriesHolder.get((Object)registry.getRegistryKey().toString()).forEach(pair -> {
                ExtendedConfigForge config = (ExtendedConfigForge)pair.getLeft();
                registry.register(new ResourceLocation(config.getMod().getModId(), config.getNamedId()), config.getInstance());
                try {
                    if (pair.getRight() != null) {
                        ((Callable)pair.getRight()).call();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    public ModBase getMod() {
        return this.mod;
    }

    public LinkedHashSet<ExtendedConfig<?, ?>> getConfigurables() {
        return this.configurables;
    }

    public Map<String, ExtendedConfig<?, ?>> getConfigDictionary() {
        return this.configDictionary;
    }

    public Set<String> getCategories() {
        return this.categories;
    }

    public Map<String, ConfigurablePropertyData> getCommandableProperties() {
        return this.commandableProperties;
    }

    public Multimap<String, Pair<ExtendedConfigForge<?, ?>, Callable<?>>> getRegistryEntriesHolder() {
        return this.registryEntriesHolder;
    }

    public Set<String> getRegistryEventPassed() {
        return this.registryEventPassed;
    }

    public void setRegistryEventPassed(Set<String> registryEventPassed) {
        this.registryEventPassed = registryEventPassed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigHandler)) {
            return false;
        }
        ConfigHandler other = (ConfigHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ModBase this$mod = this.getMod();
        ModBase other$mod = other.getMod();
        if (this$mod == null ? other$mod != null : !((Object)this$mod).equals(other$mod)) {
            return false;
        }
        LinkedHashSet<ExtendedConfig<?, ?>> this$configurables = this.getConfigurables();
        LinkedHashSet<ExtendedConfig<?, ?>> other$configurables = other.getConfigurables();
        if (this$configurables == null ? other$configurables != null : !((Object)this$configurables).equals(other$configurables)) {
            return false;
        }
        Map<String, ExtendedConfig<?, ?>> this$configDictionary = this.getConfigDictionary();
        Map<String, ExtendedConfig<?, ?>> other$configDictionary = other.getConfigDictionary();
        if (this$configDictionary == null ? other$configDictionary != null : !((Object)this$configDictionary).equals(other$configDictionary)) {
            return false;
        }
        Set<String> this$categories = this.getCategories();
        Set<String> other$categories = other.getCategories();
        if (this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories)) {
            return false;
        }
        Map<String, ConfigurablePropertyData> this$commandableProperties = this.getCommandableProperties();
        Map<String, ConfigurablePropertyData> other$commandableProperties = other.getCommandableProperties();
        if (this$commandableProperties == null ? other$commandableProperties != null : !((Object)this$commandableProperties).equals(other$commandableProperties)) {
            return false;
        }
        Multimap<String, Pair<ExtendedConfigForge<?, ?>, Callable<?>>> this$registryEntriesHolder = this.getRegistryEntriesHolder();
        Multimap<String, Pair<ExtendedConfigForge<?, ?>, Callable<?>>> other$registryEntriesHolder = other.getRegistryEntriesHolder();
        if (this$registryEntriesHolder == null ? other$registryEntriesHolder != null : !this$registryEntriesHolder.equals(other$registryEntriesHolder)) {
            return false;
        }
        Set<String> this$registryEventPassed = this.getRegistryEventPassed();
        Set<String> other$registryEventPassed = other.getRegistryEventPassed();
        return !(this$registryEventPassed == null ? other$registryEventPassed != null : !((Object)this$registryEventPassed).equals(other$registryEventPassed));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ModBase $mod = this.getMod();
        result = result * 59 + ($mod == null ? 43 : ((Object)$mod).hashCode());
        LinkedHashSet<ExtendedConfig<?, ?>> $configurables = this.getConfigurables();
        result = result * 59 + ($configurables == null ? 43 : ((Object)$configurables).hashCode());
        Map<String, ExtendedConfig<?, ?>> $configDictionary = this.getConfigDictionary();
        result = result * 59 + ($configDictionary == null ? 43 : ((Object)$configDictionary).hashCode());
        Set<String> $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 43 : ((Object)$categories).hashCode());
        Map<String, ConfigurablePropertyData> $commandableProperties = this.getCommandableProperties();
        result = result * 59 + ($commandableProperties == null ? 43 : ((Object)$commandableProperties).hashCode());
        Multimap<String, Pair<ExtendedConfigForge<?, ?>, Callable<?>>> $registryEntriesHolder = this.getRegistryEntriesHolder();
        result = result * 59 + ($registryEntriesHolder == null ? 43 : $registryEntriesHolder.hashCode());
        Set<String> $registryEventPassed = this.getRegistryEventPassed();
        result = result * 59 + ($registryEventPassed == null ? 43 : ((Object)$registryEventPassed).hashCode());
        return result;
    }

    public String toString() {
        return "ConfigHandler(mod=" + this.getMod() + ", configurables=" + this.getConfigurables() + ", configDictionary=" + this.getConfigDictionary() + ", categories=" + this.getCategories() + ", commandableProperties=" + this.getCommandableProperties() + ", registryEntriesHolder=" + this.getRegistryEntriesHolder() + ", registryEventPassed=" + this.getRegistryEventPassed() + ")";
    }
}

