/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public abstract class PagedListWidget<D, T>
extends AbstractWidget {
    private PageButton forwardButton;
    private PageButton backButton;
    private int wh;
    private int page;
    protected Supplier<List<T>> list;
    protected T selected;
    private List<ListEntry> listEntries = new ArrayList<ListEntry>();

    public PagedListWidget(int x, int y, int w, int h, int wh) {
        super(x, y, w, h, (Component)Component.m_237119_());
        this.forwardButton = this.addWidgetToGUI(new PageButton(x + w - 24, y + h - 12, true, p_98297_ -> this.pageForward(), true));
        this.backButton = this.addWidgetToGUI(new PageButton(x + 4, y + h - 12, false, p_98287_ -> this.pageBack(), true));
        this.wh = wh;
        int wc = this.getLines();
        for (int i = 0; i < wc; ++i) {
            this.listEntries.add(new ListEntry(i, this.makeElement(x, y + i * wh)));
        }
    }

    private void pageBack() {
        if (this.page > 0) {
            --this.page;
            this.updateContent();
        }
    }

    private void pageForward() {
        if ((this.page + 1) * this.getLines() < this.list.get().size()) {
            ++this.page;
            this.updateContent();
        }
    }

    protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }

    protected void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.f_93624_) {
            Minecraft minecraft = Minecraft.m_91087_();
            MutableComponent c = Component.m_237113_((String)(this.page + 1 + " / " + Math.max(Mth.m_14167_((float)((float)this.list.get().size() / (float)this.getLines())), 1)));
            pGuiGraphics.m_280614_(minecraft.f_91062_, (Component)c, this.m_252754_() + this.m_5711_() / 2 - minecraft.f_91062_.m_92852_((FormattedText)c) / 2, this.m_252907_() + this.m_93694_() - 8, 0x404040, false);
        }
    }

    protected abstract <W extends AbstractWidget> W addWidgetToGUI(W var1);

    protected abstract D makeElement(int var1, int var2);

    protected abstract void updateElement(D var1, T var2);

    public void updateContent() {
        this.listEntries.forEach(ListEntry::update);
        this.page = Mth.m_14045_((int)this.page, (int)0, (int)Math.max(Mth.m_14167_((float)((float)this.list.get().size() / (float)this.getLines())), 0));
        this.backButton.f_93623_ = this.page > 0;
        this.forwardButton.f_93623_ = (this.page + 1) * this.getLines() < this.list.get().size();
    }

    public int getLines() {
        return (this.f_93619_ - 16) / this.wh;
    }

    public void setVisible(boolean visible) {
        this.f_93624_ = visible;
        this.backButton.f_93624_ = visible;
        this.forwardButton.f_93624_ = visible;
        this.listEntries.forEach(ListEntry::update);
    }

    private class ListEntry {
        private final int id;
        private final D disp;

        public ListEntry(int id, D disp) {
            this.id = id;
            this.disp = disp;
        }

        private T getId() {
            if (!PagedListWidget.this.f_93624_) {
                return null;
            }
            List l = PagedListWidget.this.list.get();
            int j = PagedListWidget.this.page * PagedListWidget.this.getLines();
            if (j < 0) {
                j = 0;
            }
            if (this.id + j < l.size()) {
                return l.get(this.id + j);
            }
            return null;
        }

        private void update() {
            PagedListWidget.this.updateElement(this.disp, this.getId());
        }
    }
}

