/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.tom.createores.CreateOreExcavation;
import com.tom.createores.OreDataCapability;
import com.tom.createores.OreVeinGenerator;
import com.tom.createores.recipe.ExcavatingRecipe;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.RandomSpreadGenerator;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientSuggestionProvider;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.client.ClientCommandSourceStack;
import net.minecraftforge.event.RegisterCommandsEvent;

public class COECommand {
    private static final DynamicCommandExceptionType ERROR_VEIN_NOT_FOUND = new DynamicCommandExceptionType(p_214514_ -> Component.m_237110_((String)"command.coe.locate.failed", (Object[])new Object[]{p_214514_}));
    public static final SuggestionProvider<CommandSourceStack> ALL_RECIPES = SuggestionProviders.m_121658_((ResourceLocation)new ResourceLocation("createoreexcavation", "all_recipes"), (ctx, builder) -> {
        RecipeManager rm;
        if (ctx.getSource() instanceof ClientCommandSourceStack || ctx.getSource() instanceof ClientSuggestionProvider) {
            rm = Minecraft.m_91087_().m_91403_().m_105141_();
        } else {
            Object patt6452$temp = ctx.getSource();
            if (patt6452$temp instanceof CommandSourceStack) {
                CommandSourceStack css = (CommandSourceStack)patt6452$temp;
                rm = css.m_81377_().m_129894_();
            } else {
                rm = null;
            }
        }
        Stream<Object> rl = rm != null ? rm.m_44013_(CreateOreExcavation.VEIN_RECIPES.getRecipeType()).stream().map(VeinRecipe::m_6423_) : Stream.empty();
        return SharedSuggestionProvider.m_82957_(rl, (SuggestionsBuilder)builder);
    });

    public static void init() {
    }

    public static void register(RegisterCommandsEvent evt) {
        LiteralArgumentBuilder l = Commands.m_82127_((String)"coe");
        l.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"setvein").requires(s -> s.m_6761_(2))).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"recipe", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(ALL_RECIPES).executes(c -> {
            BlockPos p = BlockPosArgument.m_118242_((CommandContext)c, (String)"pos");
            Recipe rl = ResourceLocationArgument.m_106994_((CommandContext)c, (String)"recipe");
            if (rl instanceof VeinRecipe) {
                COECommand.setVein((CommandSourceStack)c.getSource(), p, rl.m_6423_(), 0.8f);
                ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237110_((String)"command.coe.setvein.success", (Object[])new Object[]{rl.m_6423_()}), true);
                return 1;
            }
            return 0;
        })).then(Commands.m_82129_((String)"multiplier", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1000.0f)).executes(c -> {
            float mul = FloatArgumentType.getFloat((CommandContext)c, (String)"multiplier");
            BlockPos p = BlockPosArgument.m_118242_((CommandContext)c, (String)"pos");
            Recipe rl = ResourceLocationArgument.m_106994_((CommandContext)c, (String)"recipe");
            if (rl.m_6671_() instanceof ExcavatingRecipe) {
                COECommand.setVein((CommandSourceStack)c.getSource(), p, rl.m_6423_(), mul);
                ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237110_((String)"command.coe.setvein.success", (Object[])new Object[]{rl.m_6423_()}), true);
                return 1;
            }
            return 0;
        })))));
        l.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"removevein").requires(s -> s.m_6761_(2))).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(c -> {
            BlockPos p = BlockPosArgument.m_118242_((CommandContext)c, (String)"pos");
            COECommand.setVein((CommandSourceStack)c.getSource(), p, null, 0.0f);
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237110_((String)"command.coe.setvein.success", (Object[])new Object[]{Component.m_237115_((String)"chat.coe.veinFinder.nothing")}), true);
            return 1;
        })));
        l.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"locate").requires(s -> s.m_6761_(2))).then(Commands.m_82129_((String)"recipe", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(ALL_RECIPES).executes(c -> {
            Recipe rl = ResourceLocationArgument.m_106994_((CommandContext)c, (String)"recipe");
            if (rl instanceof VeinRecipe) {
                BlockPos blockpos = BlockPos.m_274446_((Position)((CommandSourceStack)c.getSource()).m_81371_());
                Stopwatch stopwatch = Stopwatch.createStarted((Ticker)Util.f_211544_);
                BlockPos at = OreVeinGenerator.getPicker(((CommandSourceStack)c.getSource()).m_81372_()).locate(rl.m_6423_(), blockpos, ((CommandSourceStack)c.getSource()).m_81372_(), 100);
                stopwatch.stop();
                if (at != null) {
                    int i = Mth.m_14143_((float)RandomSpreadGenerator.distance2d(at, blockpos));
                    MutableComponent component = ComponentUtils.m_130748_((Component)Component.m_237110_((String)"chat.coordinates", (Object[])new Object[]{at.m_123341_(), "~", at.m_123343_()})).m_130938_(p_214489_ -> p_214489_.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + at.m_123341_() + " ~ " + at.m_123343_())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.coordinates.tooltip"))));
                    ((CommandSourceStack)c.getSource()).m_288197_(() -> COECommand.lambda$register$11(rl, (Component)component, i), false);
                    CreateOreExcavation.LOGGER.info("Locating element " + rl.m_6423_() + " took " + stopwatch.elapsed().toMillis() + " ms");
                    return i;
                }
                throw ERROR_VEIN_NOT_FOUND.create((Object)rl.m_6423_().toString());
            }
            throw ERROR_VEIN_NOT_FOUND.create((Object)rl.m_6423_().toString());
        })));
        evt.getDispatcher().register(l);
    }

    private static void setVein(CommandSourceStack css, BlockPos pos, ResourceLocation rl, float mul) {
        ChunkPos p = new ChunkPos(pos);
        OreDataCapability.OreData data = OreDataCapability.getData(css.m_81372_().m_6325_(p.f_45578_, p.f_45579_));
        data.setRecipe(rl);
        data.setLoaded(true);
        data.setRandomMul(mul);
        data.setExtractedAmount(0L);
    }

    private static /* synthetic */ Component lambda$register$11(Recipe rl, Component component, int i) {
        return Component.m_237110_((String)"command.coe.locate.success", (Object[])new Object[]{rl.m_6423_().toString(), component, i});
    }
}

