/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Screens;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.DataStructures.DataHolder;
import com.darkere.crashutils.Network.DataRequestType;
import com.darkere.crashutils.Screens.CUContentPane;
import com.darkere.crashutils.Screens.CUDropDown;
import com.darkere.crashutils.Screens.CUScreen;
import com.darkere.crashutils.Screens.DataListLoader;
import com.darkere.crashutils.Screens.Types.DropDownType;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class DataListGUI
extends CUContentPane {
    CUDropDown SELECTOR;
    DataListLoader loader;
    EditBox filterWidget;

    DataListGUI(CUScreen screen, ResourceKey<Level> dim) {
        super(dim, screen);
        this.updateRenderValues(screen.centerX, screen.centerY);
        this.loader = new DataListLoader(this.XTopLeft, this.YTopLeft, this.XAcross, this.YAcross, screen, dim);
        DataHolder.setRequestType(DataRequestType.ENTITYDATA);
        DataHolder.requestUpdates(0, dim, true);
        this.SELECTOR = new CUDropDown(DropDownType.SELECTOR, screen, Arrays.asList("ENTITIES", "BLOCKENTITIES", "TICKETS", "STATES", "PLAYERS"), "ENTITIES", -192, -105, 80);
        screen.topDropDowns.add(this.SELECTOR);
        this.SELECTOR.setEnabled(true);
        this.loader.loadOrderedEntityList(false);
        Font font = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        this.filterWidget = new EditBox(font, this.centerX - 107, this.centerY - 104, 150, 9 + 2, (Component)CommandUtils.CreateTextComponent("Filter")){

            public boolean m_6375_(double p_94125_, double p_94126_, int p_94127_) {
                if (p_94127_ == 1) {
                    DataListGUI.this.filterWidget.m_94144_("");
                }
                this.m_93692_(true);
                return super.m_6375_(p_94125_, p_94126_, p_94127_);
            }
        };
        this.filterWidget.m_94151_(r -> this.loader.currentList.updateFilter((String)r));
    }

    @Override
    public void render(GuiGraphics guiGraphics, int centerX, int centerY, int mx, int my, float partialTicks) {
        this.filterWidget.m_88315_(guiGraphics, mx, my, partialTicks);
        super.render(guiGraphics, centerX, centerY, mx, my, partialTicks);
        this.loader.currentList.render(guiGraphics, mx, my, partialTicks);
    }

    @Override
    public boolean mouseClicked(double mx, double my, int mouseButton) {
        return this.loader.currentList.checkClick((int)mx, (int)my);
    }

    @Override
    public boolean mouseClickedOutside(double mx, double my, int centerX, int centerY, int mouseButton) {
        if (this.filterWidget.m_5953_(mx, my)) {
            return this.filterWidget.m_6375_(mx, my, mouseButton);
        }
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.filterWidget.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        return this.filterWidget.m_5534_(p_charTyped_1_, p_charTyped_2_);
    }

    @Override
    public void scroll(double x, double y, double delta, int centerX, int centerY) {
        this.loader.currentList.scroll(x, y, delta);
    }

    @Override
    public void updateSelection(DropDownType ddtype, String s) {
        if (ddtype == DropDownType.SELECTOR) {
            switch (s) {
                case "ENTITIES": {
                    DataHolder.setRequestType(DataRequestType.ENTITYDATA);
                    DataHolder.requestUpdates(0, this.screen.dim, !this.firstEntity);
                    this.currentType = DataRequestType.ENTITYDATA;
                    this.firstEntity = true;
                    this.loader.loadOrderedEntityList(false);
                    break;
                }
                case "BLOCKENTITIES": {
                    DataHolder.setRequestType(DataRequestType.TILEENTITYDATA);
                    DataHolder.requestUpdates(0, this.screen.dim, !this.firstTileEntity);
                    this.currentType = DataRequestType.TILEENTITYDATA;
                    this.firstTileEntity = true;
                    this.loader.loadOrderedTileEntityList(false);
                    break;
                }
                case "TICKETS": {
                    DataHolder.setRequestType(DataRequestType.LOADEDCHUNKDATA);
                    DataHolder.requestUpdates(0, this.screen.dim, !this.firstChunks);
                    this.firstChunks = true;
                    this.loader.loadTicketList(false);
                    break;
                }
                case "STATES": {
                    DataHolder.setRequestType(DataRequestType.LOADEDCHUNKDATA);
                    DataHolder.requestUpdates(0, this.screen.dim, !this.firstChunks);
                    this.firstChunks = true;
                    this.loader.loadStateList(false);
                    break;
                }
                case "PLAYERS": {
                    DataHolder.setRequestType(DataRequestType.PLAYERDATA);
                    DataHolder.requestUpdates(0, this.screen.dim, !this.firstPlayer);
                    this.firstPlayer = true;
                    this.loader.loadPlayerList(false);
                }
            }
        }
    }
}

