/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.items;

import com.direwolf20.buildinggadgets2.api.gadgets.GadgetTarget;
import com.direwolf20.buildinggadgets2.client.screen.ScreenOpener;
import com.direwolf20.buildinggadgets2.common.events.ServerBuildList;
import com.direwolf20.buildinggadgets2.common.events.ServerTickHandler;
import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.setup.Config;
import com.direwolf20.buildinggadgets2.util.BuildingUtils;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.GadgetUtils;
import com.direwolf20.buildinggadgets2.util.VectorHelper;
import com.direwolf20.buildinggadgets2.util.context.ItemActionContext;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GadgetDestruction
extends BaseGadget {
    @Override
    public int getEnergyMax() {
        return (Integer)Config.DESTRUCTIONGADGET_MAXPOWER.get();
    }

    @Override
    public int getEnergyCost() {
        return (Integer)Config.DESTRUCTIONGADGET_COST.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        Minecraft mc = Minecraft.m_91087_();
        if (level == null || mc.f_91074_ == null) {
            return;
        }
        tooltip.add((Component)Component.m_237115_((String)"buildinggadgets2.voidwarning").m_130940_(ChatFormatting.RED));
        boolean sneakPressed = Screen.m_96638_();
        if (sneakPressed) {
            // empty if block
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack gadget = player.m_21120_(hand);
        BlockHitResult lookingAt = VectorHelper.getLookingAt(player, gadget);
        ItemActionContext context = new ItemActionContext(lookingAt.m_82425_(), lookingAt, player, level, hand, gadget);
        if (player.m_6144_()) {
            return this.onShiftAction(context);
        }
        if (level.m_5776_()) {
            return InteractionResultHolder.m_19090_((Object)gadget);
        }
        return this.onAction(context);
    }

    @Override
    InteractionResultHolder<ItemStack> onAction(ItemActionContext context) {
        ItemStack gadget = context.stack();
        BlockPos anchor = GadgetNBT.getAnchorPos(gadget);
        Direction anchorSide = GadgetNBT.getAnchorSide(gadget);
        if (context.level().m_8055_(VectorHelper.getLookingAt(context.player(), gadget).m_82425_()) == Blocks.f_50016_.m_49966_() && anchor == null) {
            return InteractionResultHolder.m_19098_((Object)gadget);
        }
        BlockPos startBlock = GadgetDestruction.getHitPos(context);
        Direction facing = anchorSide == null ? context.hitResult().m_82434_() : anchorSide;
        ArrayList<StatePos> destroyList = GadgetUtils.getDestructionArea(context.level(), startBlock, facing, context.player(), gadget);
        ArrayList<BlockPos> destroyPosList = new ArrayList<BlockPos>();
        destroyList.forEach(e -> destroyPosList.add(e.pos));
        destroyPosList.sort(Comparator.comparingDouble(blockPos -> blockPos.m_123331_((Vec3i)context.player().m_20183_())));
        UUID buildUUID = BuildingUtils.removeTickHandler(context.level(), context.player(), destroyPosList, false, true, gadget);
        GadgetUtils.addToUndoList(context.level(), gadget, new ArrayList<StatePos>(), buildUUID);
        GadgetNBT.clearAnchorPos(gadget);
        return InteractionResultHolder.m_19090_((Object)gadget);
    }

    @Override
    InteractionResultHolder<ItemStack> onShiftAction(ItemActionContext context) {
        if (context.level().f_46443_) {
            ScreenOpener.openDestructionScreen(context.stack());
        }
        return super.onShiftAction(context);
    }

    @Override
    public void undo(Level level, Player player, ItemStack gadget) {
        if (!this.canUndo(level, player, gadget)) {
            return;
        }
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(level.m_7654_()).m_129783_());
        UUID buildUUID = GadgetNBT.popUndoList(gadget);
        UUID newBuildUUID = UUID.randomUUID();
        ServerTickHandler.stopBuilding(buildUUID);
        ArrayList<StatePos> undoList = bg2Data.popUndoList(buildUUID);
        if (undoList.isEmpty()) {
            return;
        }
        Collections.reverse(undoList);
        for (StatePos statePos : undoList) {
            if (statePos.state.m_60795_()) continue;
            ServerTickHandler.addToMap(newBuildUUID, statePos, level, GadgetNBT.getRenderTypeByte(gadget), player, false, false, gadget, ServerBuildList.BuildType.UNDO_DESTROY, false, BlockPos.f_121853_);
        }
    }

    @Override
    public GadgetTarget gadgetTarget() {
        return GadgetTarget.DESTRUCTION;
    }
}

