/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.stargate;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.util.INBTSerializable;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.blockstates.StargatePart;

public class StargateBlockCover
implements INBTSerializable<CompoundTag> {
    private ArrayList<StargatePart> parts;
    public boolean canSinkGate = false;
    public HashMap<StargatePart, BlockState> blockStates = new HashMap();

    public StargateBlockCover(ArrayList<StargatePart> parts) {
        this.parts = parts;
    }

    public boolean setBlockAt(StargatePart part, BlockState state) {
        if (this.blockStates.containsKey((Object)part)) {
            return false;
        }
        this.blockStates.put(part, state);
        return true;
    }

    public Optional<BlockState> getBlockAt(StargatePart part) {
        if (this.blockStates.get((Object)part) != null && this.blockStates.get((Object)part).m_60734_() instanceof AbstractStargateBlock) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.blockStates.get((Object)part));
    }

    public Optional<BlockState> removeBlockAt(StargatePart part) {
        BlockState oldState = this.blockStates.get((Object)part);
        this.blockStates.remove((Object)part);
        return Optional.ofNullable(oldState);
    }

    public boolean mineBlockAt(Level level, Player player, StargatePart part, BlockPos pos) {
        Optional<BlockState> removed = this.removeBlockAt(part);
        if (removed.isPresent()) {
            if (!level.m_5776_()) {
                BlockState state = removed.get();
                if (!player.m_7500_() && player.m_36298_(removed.get())) {
                    Block.m_49950_((BlockState)state, (Level)level, (BlockPos)pos);
                }
                level.m_5898_((Player)null, 2001, pos, Block.m_49956_((BlockState)state));
            }
            return true;
        }
        return false;
    }

    public ItemStack getStackAt(HitResult target, BlockGetter level, Player player, StargatePart part, BlockPos pos) {
        Optional<BlockState> removed = this.getBlockAt(part);
        if (removed.isPresent()) {
            BlockState state = removed.get();
            return state.getCloneItemStack(target, level, pos, player);
        }
        return ItemStack.f_41583_;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<StargatePart, BlockState> entry : this.blockStates.entrySet()) {
            DataResult blockStateTag = BlockState.f_61039_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)entry.getValue());
            Optional result = blockStateTag.result();
            if (!result.isPresent()) continue;
            tag.m_128365_(entry.getKey().m_7912_(), (Tag)result.get());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        for (StargatePart part : this.parts) {
            DataResult stateResult;
            Optional result;
            if (!tag.m_128441_(part.m_7912_()) || !(result = (stateResult = BlockState.f_61039_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_(part.m_7912_()))).result()).isPresent()) continue;
            this.blockStates.put(part, (BlockState)result.get());
        }
    }
}

