/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.init;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.common.capabilities.AncientGeneProvider;
import net.povstalec.sgjourney.common.data.BlockEntityList;
import net.povstalec.sgjourney.common.data.StargateNetwork;
import net.povstalec.sgjourney.common.data.StargateNetworkSettings;
import net.povstalec.sgjourney.common.data.TransporterNetwork;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.stargate.Address;
import net.povstalec.sgjourney.common.stargate.Galaxy;
import net.povstalec.sgjourney.common.stargate.SolarSystem;
import net.povstalec.sgjourney.common.stargate.Transporter;

public class CommandInit {
    private static final String STARGATE_NETWORK = "stargateNetwork";
    private static final String TRANSPORTER_NETWORK = "transporterNetwork";
    private static final String GENE = "gene";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)STARGATE_NETWORK).then(Commands.m_82127_((String)"address").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(CommandInit::getAddress))))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)STARGATE_NETWORK).then(Commands.m_82127_((String)"extragalacticAddress").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(CommandInit::getExtragalacticAddress))))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)STARGATE_NETWORK).then(Commands.m_82127_((String)"getAllStargates").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(CommandInit::getStargates))))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)STARGATE_NETWORK).then(Commands.m_82127_((String)"version").executes(CommandInit::getVersion)))).requires(commandSourceStack -> commandSourceStack.m_6761_(0)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)STARGATE_NETWORK).then(Commands.m_82127_((String)"forceStellarUpdate").executes(CommandInit::forceStellarUpdate)))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)STARGATE_NETWORK).then(Commands.m_82127_((String)"settings").then(Commands.m_82127_((String)"get").executes(CommandInit::getSettings))))).requires(commandSourceStack -> commandSourceStack.m_6761_(0)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)STARGATE_NETWORK).then(Commands.m_82127_((String)"settings").then(Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"useDatapackAddresses").then(Commands.m_82129_((String)"useDatapackAddresses", (ArgumentType)BoolArgumentType.bool()).executes(CommandInit::useDatapackAddresses))))))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)STARGATE_NETWORK).then(Commands.m_82127_((String)"settings").then(Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"generateRandomSolarSystems").then(Commands.m_82129_((String)"generateRandomSolarSystems", (ArgumentType)BoolArgumentType.bool()).executes(CommandInit::generateRandomSolarSystems))))))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)STARGATE_NETWORK).then(Commands.m_82127_((String)"settings").then(Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"randomAddressFromSeed").then(Commands.m_82129_((String)"randomAddressFromSeed", (ArgumentType)BoolArgumentType.bool()).executes(CommandInit::randomAddressFromSeed))))))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)TRANSPORTER_NETWORK).then(Commands.m_82127_((String)"getAllTransporters").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(CommandInit::getTransporters))))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)TRANSPORTER_NETWORK).then(Commands.m_82127_((String)"reload").executes(CommandInit::reloadTransporterNetwork)))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)GENE).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82127_((String)"add").then(Commands.m_82127_((String)"ancient").executes(CommandInit::setAncientGene)))))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)GENE).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82127_((String)"add").then(Commands.m_82127_((String)"inherited").executes(CommandInit::setInheritedGene)))))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)GENE).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82127_((String)"add").then(Commands.m_82127_((String)"artificial").executes(CommandInit::setArtificialGene)))))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)GENE).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82127_((String)"remove").executes(CommandInit::removeGene))))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sgjourney").then(Commands.m_82127_((String)"debugInfo").executes(CommandInit::printStargateNetworkInfo))).requires(commandSourceStack -> commandSourceStack.m_6761_(2)));
    }

    private static int getAddress(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        List galaxies;
        ResourceKey dimension = DimensionArgument.m_88808_(context, (String)"dimension").m_46472_();
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        if (player == null || dimension == null) {
            return 1;
        }
        Level level = player.m_9236_();
        ResourceKey currentDimension = level.m_46472_();
        Optional<HashMap<Galaxy.Serializable, Address.Immutable>> galaxiesOptional = Universe.get(level).getGalaxiesFromDimension((ResourceKey<Level>)currentDimension);
        if (galaxiesOptional.isPresent() && !(galaxies = galaxiesOptional.get().entrySet().stream().toList()).isEmpty()) {
            for (int i = 0; i < galaxies.size(); ++i) {
                Map.Entry galaxyEntry = (Map.Entry)galaxies.get(i);
                Galaxy.Serializable galaxy = (Galaxy.Serializable)galaxyEntry.getKey();
                Optional<Address.Immutable> addressOptional = Universe.get(level).getAddressInGalaxyFromDimension(galaxy.getKey().m_135782_().toString(), (ResourceKey<Level>)dimension);
                if (addressOptional.isEmpty()) {
                    ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237113_((String)(dimension.m_135782_().toString() + " ")).m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237115_((String)"message.sgjourney.command.get_address.located").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" ").m_7220_(galaxy.getTranslationName()).m_130940_(ChatFormatting.LIGHT_PURPLE)));
                    continue;
                }
                Address.Immutable address = addressOptional.get();
                ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237115_((String)"message.sgjourney.command.get_address.address").m_7220_((Component)Component.m_237113_((String)(" " + dimension.m_135782_().toString() + " ")).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237115_((String)"message.sgjourney.command.get_address.in_galaxy")).m_7220_((Component)Component.m_237113_((String)" ").m_7220_(galaxy.getTranslationName()).m_7220_((Component)Component.m_237113_((String)" ")).m_130940_(ChatFormatting.LIGHT_PURPLE)).m_7220_((Component)Component.m_237115_((String)"message.sgjourney.command.get_address.is")));
                Style style = Style.f_131099_;
                style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"message.sgjourney.command.click_to_copy.address")));
                style = style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, address.toString()));
                ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237113_((String)address.toString()).m_6270_(style.m_131157_(ChatFormatting.GOLD)));
            }
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237115_((String)"message.sgjourney.command.get_address.no_galaxy").m_130940_(ChatFormatting.DARK_RED));
        return 1;
    }

    private static int getExtragalacticAddress(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ResourceKey dimension = DimensionArgument.m_88808_(context, (String)"dimension").m_46472_();
        Level level = ((CommandSourceStack)context.getSource()).m_230896_().m_9236_();
        Optional<Address.Immutable> addressOptional = Universe.get(level).getExtragalacticAddressFromDimension((ResourceKey<Level>)dimension);
        if (addressOptional.isPresent()) {
            Address.Immutable address = addressOptional.get();
            Style style = Style.f_131099_;
            style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"message.sgjourney.command.click_to_copy.address")));
            Style formatStyle = style = style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, address.toString()));
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"message.sgjourney.command.get_extragalactic_address.address").m_7220_((Component)Component.m_237113_((String)(" " + dimension.m_135782_().toString() + " ")).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237115_((String)"message.sgjourney.command.get_extragalactic_address.is")), false);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)address.toString()).m_6270_(formatStyle.m_131157_(ChatFormatting.LIGHT_PURPLE)), false);
        } else {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"message.sgjourney.command.get_extragalactic_address.none").m_130940_(ChatFormatting.DARK_RED), false);
        }
        return 1;
    }

    private static int getStargates(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        SolarSystem.Serializable solarSystem;
        ResourceKey dimension = DimensionArgument.m_88808_(context, (String)"dimension").m_46472_();
        Level level = ((CommandSourceStack)context.getSource()).m_230896_().m_9236_();
        Optional<SolarSystem.Serializable> solarSystemOptional = Universe.get(level).getSolarSystemFromDimension((ResourceKey<Level>)dimension);
        if (solarSystemOptional.isPresent() && !(solarSystem = solarSystemOptional.get()).getStargates().isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"message.sgjourney.command.get_stargates").m_7220_((Component)Component.m_237113_((String)(" " + dimension.m_135782_().toString())).m_130940_(ChatFormatting.GOLD)), false);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"-------------------------"), false);
            solarSystem.getStargates().stream().forEach(stargate -> {
                ResourceKey<Level> stargateDimension = stargate.getDimension();
                BlockPos stargatePos = stargate.getBlockPos();
                if (stargateDimension.equals((Object)dimension)) {
                    Style style = Style.f_131099_;
                    style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"message.sgjourney.command.click_to_copy.address")));
                    Style formatStyle = style = style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, stargate.get9ChevronAddress().toString()));
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)stargate.get9ChevronAddress().toString()).m_6270_(formatStyle.m_131157_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)(" X: " + stargatePos.m_123341_() + " Y: " + stargatePos.m_123342_() + " Z: " + stargatePos.m_123343_())).m_130940_(ChatFormatting.BLUE)), false);
                }
            });
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"-------------------------"), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_230896_().m_213846_((Component)Component.m_237113_((String)("No Stargates could be located in " + dimension.m_135782_().toString())).m_130940_(ChatFormatting.RED));
        return 1;
    }

    private static int getVersion(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Level level = ((CommandSourceStack)context.getSource()).m_230896_().m_9236_();
        int version = StargateNetwork.get(level).getVersion();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"message.sgjourney.command.stargate_network_version").m_7220_((Component)Component.m_237113_((String)(": " + version))).m_130940_(ChatFormatting.GREEN), false);
        return 1;
    }

    private static int forceStellarUpdate(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Level level = ((CommandSourceStack)context.getSource()).m_230896_().m_9236_();
        StargateNetwork.get(level).stellarUpdate(level.m_7654_(), true);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"message.sgjourney.command.stellar_update").m_130940_(ChatFormatting.RED), true);
        return 1;
    }

    private static int getSettings(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Level level = ((CommandSourceStack)context.getSource()).m_230896_().m_9236_();
        boolean useDatapackAddresses = StargateNetworkSettings.get(level).useDatapackAddresses();
        boolean generateRandomSolarSystems = StargateNetworkSettings.get(level).generateRandomSolarSystems();
        boolean randomAddressFromSeed = StargateNetworkSettings.get(level).randomAddressFromSeed();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"message.sgjourney.command.stargate_network_settings.use_datapack_addresses").m_7220_((Component)Component.m_237113_((String)(": " + useDatapackAddresses))).m_130940_(ChatFormatting.GOLD), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"message.sgjourney.command.stargate_network_settings.generate_random_solar_systems").m_7220_((Component)Component.m_237113_((String)(": " + generateRandomSolarSystems))).m_130940_(ChatFormatting.GOLD), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"message.sgjourney.command.stargate_network_settings.random_addresses_from_seed").m_7220_((Component)Component.m_237113_((String)(": " + randomAddressFromSeed))).m_130940_(ChatFormatting.GOLD), false);
        return 1;
    }

    private static int useDatapackAddresses(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Level level = ((CommandSourceStack)context.getSource()).m_230896_().m_9236_();
        boolean setting = BoolArgumentType.getBool(context, (String)"useDatapackAddresses");
        StargateNetworkSettings.get(level).setUseDatapackAddresses(setting);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"message.sgjourney.command.stargate_network_settings.changed").m_130940_(ChatFormatting.YELLOW), false);
        return 1;
    }

    private static int generateRandomSolarSystems(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Level level = ((CommandSourceStack)context.getSource()).m_230896_().m_9236_();
        boolean setting = BoolArgumentType.getBool(context, (String)"generateRandomSolarSystems");
        StargateNetworkSettings.get(level).setGenerateRandomSolarSystems(setting);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"message.sgjourney.command.stargate_network_settings.changed").m_130940_(ChatFormatting.YELLOW), false);
        return 1;
    }

    private static int randomAddressFromSeed(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Level level = ((CommandSourceStack)context.getSource()).m_230896_().m_9236_();
        boolean setting = BoolArgumentType.getBool(context, (String)"randomAddressFromSeed");
        StargateNetworkSettings.get(level).setRandomAddressFromSeed(setting);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"message.sgjourney.command.stargate_network_settings.changed").m_130940_(ChatFormatting.YELLOW), false);
        return 1;
    }

    private static int getTransporters(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ResourceKey dimension = DimensionArgument.m_88808_(context, (String)"dimension").m_46472_();
        Level level = ((CommandSourceStack)context.getSource()).m_230896_().m_9236_();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"message.sgjourney.command.get_transporters").m_7220_((Component)Component.m_237113_((String)(" " + dimension.m_135782_().toString())).m_130940_(ChatFormatting.GOLD)), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"-------------------------"), false);
        Optional<List<Transporter>> transportersOptional = TransporterNetwork.get(level).getTransportersFromDimension((ResourceKey<Level>)dimension);
        if (transportersOptional.isPresent()) {
            List<Transporter> transporters = transportersOptional.get();
            for (int i = 0; i < transporters.size(); ++i) {
                BlockPos coords = transporters.get(i).getBlockPos();
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("X: " + coords.m_123341_() + " Y: " + coords.m_123342_() + " Z: " + coords.m_123343_())).m_130940_(ChatFormatting.BLUE), false);
            }
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"-------------------------"), false);
        return 1;
    }

    private static int reloadTransporterNetwork(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Level level = ((CommandSourceStack)context.getSource()).m_230896_().m_9236_();
        TransporterNetwork.get(level).reloadNetwork(level.m_7654_(), true);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"message.sgjourney.command.transporter_network_reload").m_130940_(ChatFormatting.RED), true);
        return 1;
    }

    private static int setAncientGene(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.m_91452_(context, (String)"target");
        entity.getCapability(AncientGeneProvider.ANCIENT_GENE).ifPresent(cap -> cap.giveGene());
        return 1;
    }

    private static int setInheritedGene(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.m_91452_(context, (String)"target");
        entity.getCapability(AncientGeneProvider.ANCIENT_GENE).ifPresent(cap -> cap.inheritGene());
        return 1;
    }

    private static int setArtificialGene(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.m_91452_(context, (String)"target");
        entity.getCapability(AncientGeneProvider.ANCIENT_GENE).ifPresent(cap -> cap.implantGene());
        return 1;
    }

    private static int removeGene(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.m_91452_(context, (String)"target");
        entity.getCapability(AncientGeneProvider.ANCIENT_GENE).ifPresent(cap -> cap.removeGene());
        return 1;
    }

    private static int printStargateNetworkInfo(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Level level = ((CommandSourceStack)context.getSource()).m_230896_().m_9236_();
        System.out.println("===============Universe===============");
        Universe.get(level).printDimensions();
        Universe.get(level).printSolarSystems();
        Universe.get(level).printGalaxies();
        System.out.println("===============Stargate Network===============");
        BlockEntityList.get(level).printStargates();
        StargateNetwork.get(level).printConnections();
        System.out.println("===============Transporter Network===============");
        BlockEntityList.get(level).printTransporters();
        TransporterNetwork.get(level).printDimensions();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Printed info onto the console"), false);
        return 1;
    }
}

