/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.events;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.capabilities.AncientGene;
import net.povstalec.sgjourney.common.capabilities.AncientGeneProvider;
import net.povstalec.sgjourney.common.capabilities.BloodstreamNaquadah;
import net.povstalec.sgjourney.common.capabilities.BloodstreamNaquadahProvider;
import net.povstalec.sgjourney.common.config.CommonGeneticConfig;
import net.povstalec.sgjourney.common.data.StargateNetwork;
import net.povstalec.sgjourney.common.data.TransporterNetwork;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.init.TagInit;
import net.povstalec.sgjourney.common.init.VillagerInit;
import net.povstalec.sgjourney.common.items.armor.PersonalShieldItem;
import net.povstalec.sgjourney.common.misc.TreasureMapForEmeraldsTrade;
import net.povstalec.sgjourney.common.stargate.StargateBlockCover;

@Mod.EventBusSubscriber(modid="sgjourney", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        StargateNetwork.get(server).updateNetwork(server);
        StargateNetwork.get(server).addStargates(server);
        TransporterNetwork.get(server).updateNetwork(server);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server = event.getServer();
        if (event.phase.equals((Object)TickEvent.Phase.START) && server != null) {
            StargateNetwork.get(server).handleConnections();
        }
    }

    private static AbstractStargateEntity getStargateAtPos(Level level, BlockPos pos, BlockState blockstate) {
        Block block = blockstate.m_60734_();
        if (block instanceof AbstractStargateBlock) {
            AbstractStargateBlock stargateBlock = (AbstractStargateBlock)block;
            AbstractStargateEntity stargate = stargateBlock.getStargate((BlockGetter)level, pos, blockstate);
            return stargate;
        }
        return null;
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Level level = event.getLevel();
        Entity entity = event.getEntity();
        if (level.m_5776_()) {
            return;
        }
        Entity entity2 = event.getEntity();
        if (entity2 instanceof AbstractVillager) {
            AbstractVillager villager = (AbstractVillager)entity2;
            AncientGene.inheritGene((Entity)villager, CommonGeneticConfig.villager_player_ata_gene_inheritance_chance.get());
        }
        if (entity instanceof LightningBolt) {
            LightningBolt lightning = (LightningBolt)entity;
            Vec3 vec3 = lightning.m_20182_();
            BlockPos strikePosition = new BlockPos((int)Math.round(vec3.f_82479_), (int)Math.round(vec3.f_82480_ - 1.0E-6), (int)Math.round(vec3.f_82481_));
            ArrayList<AbstractStargateEntity> list = new ArrayList<AbstractStargateEntity>();
            BlockState blockstate = level.m_8055_(strikePosition);
            AbstractStargateEntity stargateCandidate = ForgeEvents.getStargateAtPos(level, strikePosition, blockstate);
            if (stargateCandidate != null) {
                list.add(stargateCandidate);
            }
            for (Direction direction : Direction.values()) {
                BlockState state;
                BlockPos pos = strikePosition.m_121945_(direction);
                AbstractStargateEntity stargate2 = ForgeEvents.getStargateAtPos(level, pos, state = level.m_8055_(pos));
                if (stargate2 == null) continue;
                list.add(stargate2);
            }
            HashSet set = new HashSet(list);
            set.stream().forEach(stargate -> stargate.receiveEnergy(100000L, false));
        }
    }

    @SubscribeEvent
    public static void onPlayerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        long seed = ((ServerLevel)player.m_9236_()).m_7328_();
        AncientGene.inheritGene(seed += (long)player.m_20148_().hashCode(), (Entity)player, CommonGeneticConfig.player_ata_gene_inheritance_chance.get());
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (!level.m_46472_().m_135782_().equals((Object)new ResourceLocation("sgjourney", "cavum_tenebrae"))) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_7500_() && player.m_150110_().f_35935_) {
                return;
            }
            if (player.m_5833_() && player.m_150110_().f_35935_) {
                return;
            }
        }
        long daytime = (level.m_46468_() + 6000L) % 24000L;
        double percentage = (double)daytime / 12000.0;
        double sin = Math.sin(percentage * Math.PI - 1.5707963267948966);
        double cos = Math.cos(percentage * Math.PI - 1.5707963267948966);
        Vec3 gravityVector = new Vec3(Math.abs(cos) > 0.2 ? 0.07 * cos : 0.0, sin < 0.0 ? 0.0 : 0.07 * sin, 0.0);
        Vec3 movementVector = entity.m_20184_();
        movementVector = movementVector.m_82549_(gravityVector);
        entity.m_20256_(movementVector);
        entity.f_19789_ *= (float)(-sin + 1.0);
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        LivingEntity entity = event.getEntity();
        Entity attacker = event.getSource().m_7640_();
        float damage = event.getAmount();
        event.setCanceled(ForgeEvents.onAttackOrHurt((Entity)entity, attacker, damage));
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        Entity attacker = event.getSource().m_7640_();
        float damage = event.getAmount();
        event.setCanceled(ForgeEvents.onAttackOrHurt((Entity)entity, attacker, damage));
    }

    private static boolean onAttackOrHurt(Entity entity, Entity attacker, float damage) {
        Player player;
        ItemStack stack;
        if (entity instanceof Player && (stack = (player = (Player)entity).m_6844_(EquipmentSlot.CHEST)).m_150930_((Item)ItemInit.PERSONAL_SHIELD_EMITTER.get()) && PersonalShieldItem.getFluidAmount(stack) > 0) {
            int naquadahDepleted = (int)damage;
            PersonalShieldItem.drainNaquadah(stack, naquadahDepleted);
            if (attacker instanceof LivingEntity) {
                LivingEntity livingAttacker = (LivingEntity)attacker;
                livingAttacker.m_147240_(0.5, player.m_20185_() - attacker.m_20185_(), player.m_20189_() - attacker.m_20189_());
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onProjectileHit(ProjectileImpactEvent event) {
        Player player;
        ItemStack stack;
        EntityHitResult hitResult;
        HitResult hitResult2 = event.getRayTraceResult();
        if (hitResult2 instanceof EntityHitResult && (hitResult2 = (hitResult = (EntityHitResult)hitResult2).m_82443_()) instanceof Player && (stack = (player = (Player)hitResult2).m_6844_(EquipmentSlot.CHEST)).m_150930_((Item)ItemInit.PERSONAL_SHIELD_EMITTER.get()) && PersonalShieldItem.getFluidAmount(stack) > 0) {
            Projectile projectile = event.getProjectile();
            int naquadahDepleted = (int)projectile.m_20184_().m_82553_();
            PersonalShieldItem.drainNaquadah(stack, naquadahDepleted);
            projectile.m_20256_(projectile.m_20184_().m_82548_().m_82490_(0.2));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        Block block;
        BlockPos pos;
        Level level = event.getLevel();
        BlockState state = level.m_8055_(pos = event.getPos());
        if (!state.m_247087_() && (block = (state = level.m_8055_(pos = event.getPos().m_121945_(event.getFace()))).m_60734_()) instanceof AbstractStargateBlock) {
            AbstractStargateBlock stargate = (AbstractStargateBlock)block;
            if (event.getEntity().m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof BlockItem && stargate.setCover(state, level, pos, event.getEntity(), InteractionHand.MAIN_HAND, event.getHitVec())) {
                event.getEntity().m_6674_(InteractionHand.MAIN_HAND);
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onBlockLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        AbstractStargateBlock stargate;
        Optional<StargateBlockCover> blockCover;
        BlockPos pos;
        Level level = event.getLevel();
        BlockState state = level.m_8055_(pos = event.getPos());
        Block block = state.m_60734_();
        if (block instanceof AbstractStargateBlock && (blockCover = (stargate = (AbstractStargateBlock)block).getBlockCover((BlockGetter)level, state, event.getPos())).isPresent() && !blockCover.get().blockStates.isEmpty()) {
            StargatePart part = (StargatePart)((Object)state.m_61143_(AbstractStargateBlock.PART));
            if (blockCover.get().getBlockAt(part).isEmpty()) {
                AbstractStargateEntity stargateEntity = stargate.getStargate((BlockGetter)level, pos, state);
                if (stargateEntity != null) {
                    stargateEntity.spawnCoverParticles();
                }
                event.getEntity().m_5661_((Component)Component.m_237115_((String)"block.sgjourney.stargate.break_cover_blocks"), true);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player;
        Level level;
        AbstractStargateBlock stargate;
        Optional<StargateBlockCover> blockCover;
        Block block = event.getState().m_60734_();
        if (block instanceof AbstractStargateBlock && (blockCover = (stargate = (AbstractStargateBlock)block).getBlockCover((BlockGetter)(level = (player = event.getPlayer()).m_9236_()), event.getState(), event.getPos())).isPresent() && !blockCover.get().blockStates.isEmpty()) {
            StargatePart part = (StargatePart)((Object)event.getState().m_61143_(AbstractStargateBlock.PART));
            if (blockCover.get().mineBlockAt(level, player, part, event.getPos())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesEvent(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            if (!((Entity)event.getObject()).getCapability(BloodstreamNaquadahProvider.BLOODSTREAM_NAQUADAH).isPresent()) {
                event.addCapability(new ResourceLocation("sgjourney", "bloodstream_naquadah"), (ICapabilityProvider)new BloodstreamNaquadahProvider());
            }
            if (!((Entity)event.getObject()).getCapability(AncientGeneProvider.ANCIENT_GENE).isPresent()) {
                event.addCapability(new ResourceLocation("sgjourney", "ancient_gene"), (ICapabilityProvider)new AncientGeneProvider());
            }
        } else if (event.getObject() instanceof AbstractVillager) {
            if (!((Entity)event.getObject()).getCapability(BloodstreamNaquadahProvider.BLOODSTREAM_NAQUADAH).isPresent()) {
                event.addCapability(new ResourceLocation("sgjourney", "bloodstream_naquadah"), (ICapabilityProvider)new BloodstreamNaquadahProvider());
            }
            if (!((Entity)event.getObject()).getCapability(AncientGeneProvider.ANCIENT_GENE).isPresent()) {
                event.addCapability(new ResourceLocation("sgjourney", "ancient_gene"), (ICapabilityProvider)new AncientGeneProvider());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        Player clone = event.getEntity();
        original.reviveCaps();
        original.getCapability(BloodstreamNaquadahProvider.BLOODSTREAM_NAQUADAH).ifPresent(oldCap -> clone.getCapability(BloodstreamNaquadahProvider.BLOODSTREAM_NAQUADAH).ifPresent(newCap -> newCap.copyFrom((BloodstreamNaquadah)oldCap)));
        original.getCapability(AncientGeneProvider.ANCIENT_GENE).ifPresent(oldCap -> clone.getCapability(AncientGeneProvider.ANCIENT_GENE).ifPresent(newCap -> newCap.copyFrom((AncientGene)oldCap)));
        original.invalidateCaps();
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(BloodstreamNaquadah.class);
        event.register(AncientGene.class);
    }

    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        int villagerLevel;
        Int2ObjectMap trades;
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 1;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42516_, 20), new ItemStack((ItemLike)Items.f_42616_, 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 1;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)BlockInit.GOLDEN_IDOL.get(), 1), new ItemStack((ItemLike)Items.f_42616_, 5), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 1;
            ((List)trades.get(villagerLevel)).add(new TreasureMapForEmeraldsTrade(8, TagInit.Structures.ON_ARCHEOLOGIST_MAPS, "filled_map.sgjourney.archeologist", MapDecoration.Type.RED_X, 1, 80));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 2;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 4), new ItemStack((ItemLike)Items.f_42522_, 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 2;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 4), new ItemStack((ItemLike)Items.f_42614_, 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 2;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42417_, 3), new ItemStack((ItemLike)Items.f_42616_, 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 3;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 3), new ItemStack((ItemLike)BlockInit.FIRE_PIT.get(), 4), 1, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 3;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)BlockInit.SANDSTONE_HIEROGLYPHS.get(), 3), new ItemStack((ItemLike)Items.f_42616_, 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 3;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 4), new ItemStack((ItemLike)BlockInit.SANDSTONE_WITH_LAPIS.get(), 3), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 4;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 4), new ItemStack((ItemLike)BlockInit.STONE_SYMBOL.get(), 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 4;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 4), new ItemStack((ItemLike)BlockInit.SANDSTONE_SYMBOL.get(), 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 4;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 4), new ItemStack((ItemLike)BlockInit.RED_SANDSTONE_SYMBOL.get(), 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 4;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42500_, 4), new ItemStack((ItemLike)Items.f_42616_, 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 5;
            ((List)trades.get(villagerLevel)).add(new TreasureMapForEmeraldsTrade.StargateMapTrade(8, "filled_map.sgjourney.chappa_ai", 80));
        }
    }
}

