/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.config.CommonGenerationConfig;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.data.BlockEntityList;
import net.povstalec.sgjourney.common.data.StargateNetworkSettings;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.events.custom.SGJourneyEvents;
import net.povstalec.sgjourney.common.init.TagInit;
import net.povstalec.sgjourney.common.stargate.Address;
import net.povstalec.sgjourney.common.stargate.SolarSystem;
import net.povstalec.sgjourney.common.stargate.Stargate;
import net.povstalec.sgjourney.common.stargate.StargateConnection;

public final class StargateNetwork
extends SavedData {
    private static boolean requireEnergy = !StargateJourneyConfig.disable_energy_use.get();
    private static final String FILE_NAME = "sgjourney-stargate_network";
    private static final String VERSION = "Version";
    private static final String CONNECTIONS = "Connections";
    private static final int updateVersion = 9;
    private MinecraftServer server;
    private Map<String, StargateConnection> connections = new HashMap<String, StargateConnection>();
    private int version = 0;

    public final int getVersion() {
        return this.version;
    }

    private final void updateVersion() {
        this.version = 9;
    }

    public final void updateNetwork(MinecraftServer server) {
        if (this.getVersion() == 9) {
            StargateJourney.LOGGER.info("Stargate Network is up to date (Version: " + this.version + ")");
            return;
        }
        StargateJourney.LOGGER.info("Detected an incompatible Stargate Network version (Version: " + this.getVersion() + ") - updating to version 9");
        this.stellarUpdate(server, false);
    }

    public final void eraseNetwork() {
        this.connections.clear();
        this.m_77762_();
    }

    public final boolean shouldUseDatapackAddresses() {
        return StargateNetworkSettings.get(this.server).useDatapackAddresses();
    }

    public final void stellarUpdate(MinecraftServer server, boolean updateInterfaces) {
        for (Map.Entry<String, StargateConnection> nextConnection : this.connections.entrySet()) {
            StargateConnection connection = nextConnection.getValue();
            connection.terminate(server, Stargate.Feedback.CONNECTION_ENDED_BY_NETWORK);
        }
        StargateJourney.LOGGER.info("Connections terminated");
        StargateNetworkSettings.get(server).updateSettings();
        Universe.get(server).eraseUniverseInfo();
        StargateJourney.LOGGER.info("Universe erased");
        Universe.get(server).generateUniverseInfo(server);
        StargateJourney.LOGGER.info("Universe regenerated");
        this.eraseNetwork();
        StargateJourney.LOGGER.info("Stargate Network erased");
        this.resetStargates(server, updateInterfaces);
        StargateJourney.LOGGER.info("Stargates reset");
        this.updateVersion();
        StargateJourney.LOGGER.info("Version updated");
        this.m_77762_();
    }

    public final void addStargates(MinecraftServer server) {
        HashMap<Address.Immutable, Stargate> stargates = BlockEntityList.get(server).getStargates();
        stargates.entrySet().stream().forEach(stargateInfo -> {
            Stargate mapStargate = (Stargate)stargateInfo.getValue();
            if (mapStargate != null) {
                BlockEntity blockentity;
                ResourceKey<Level> dimension = mapStargate.getDimension();
                BlockPos pos = mapStargate.getBlockPos();
                ServerLevel level = server.m_129880_(dimension);
                if (level != null && (blockentity = server.m_129880_(dimension).m_7702_(pos)) instanceof AbstractStargateEntity) {
                    AbstractStargateEntity stargate = (AbstractStargateEntity)blockentity;
                    this.addStargate(stargate);
                }
            }
        });
    }

    private final void resetStargates(MinecraftServer server, boolean updateInterfaces) {
        HashMap<Address.Immutable, Stargate> stargates = BlockEntityList.get(server).getStargates();
        stargates.entrySet().stream().forEach(stargateInfo -> {
            Address.Immutable address = (Address.Immutable)stargateInfo.getKey();
            Stargate mapStargate = (Stargate)stargateInfo.getValue();
            if (mapStargate != null) {
                ResourceKey<Level> dimension = mapStargate.getDimension();
                BlockPos pos = mapStargate.getBlockPos();
                ServerLevel level = server.m_129880_(dimension);
                if (level != null) {
                    BlockEntity blockentity = server.m_129880_(dimension).m_7702_(pos);
                    if (blockentity instanceof AbstractStargateEntity) {
                        AbstractStargateEntity stargate = (AbstractStargateEntity)blockentity;
                        if (!address.equals(stargate.get9ChevronAddress().immutable())) {
                            this.removeStargate((Level)server.m_129880_(dimension), address);
                        }
                        stargate.resetStargate(Stargate.Feedback.CONNECTION_ENDED_BY_NETWORK, updateInterfaces);
                        this.addStargate(stargate);
                        stargate.updateStargate(updateInterfaces);
                    } else {
                        this.removeStargate((Level)server.m_129880_(dimension), address);
                        BlockEntityList.get(server).removeStargate(address);
                    }
                }
            } else {
                BlockEntityList.get(server).removeStargate(address);
            }
        });
    }

    public final void addStargate(AbstractStargateEntity stargateEntity) {
        Optional<Stargate> stargateOptional = BlockEntityList.get(this.server).addStargate(stargateEntity);
        if (stargateOptional.isPresent()) {
            Stargate stargate = stargateOptional.get();
            Universe.get(this.server).addStargateToDimension(stargate.getDimension(), stargate);
        }
        this.m_77762_();
    }

    public final void removeStargate(Level level, Address.Immutable address) {
        Optional<Stargate> stargate = this.getStargate(address);
        if (stargate.isPresent()) {
            Universe.get(this.server).removeStargateFromDimension((ResourceKey<Level>)level.m_46472_(), stargate.get());
        }
        BlockEntityList.get(level).removeStargate(address);
        StargateJourney.LOGGER.info("Removed " + address.toString() + " from Stargate Network");
        this.m_77762_();
    }

    public final void updateStargate(ServerLevel level, AbstractStargateEntity stargate) {
        Optional<Stargate> stargateOptional = this.getStargate(stargate.get9ChevronAddress().immutable());
        if (stargateOptional.isPresent()) {
            Universe.get(this.server).removeStargateFromDimension((ResourceKey<Level>)level.m_46472_(), stargateOptional.get());
            stargateOptional.get().update(stargate);
            Universe.get(this.server).addStargateToDimension((ResourceKey<Level>)level.m_46472_(), stargateOptional.get());
        }
    }

    public final Optional<Stargate> getStargate(Address.Immutable address) {
        Stargate stargate;
        if (address.getLength() == 8 && (stargate = BlockEntityList.get(this.server).getStargates().get(address)) != null) {
            return Optional.of(stargate);
        }
        return Optional.empty();
    }

    public final void handleConnections() {
        HashMap<String, StargateConnection> connections = new HashMap<String, StargateConnection>();
        connections.putAll(this.connections);
        connections.forEach((connectionID, connection) -> connection.tick(this.server));
        this.m_77762_();
    }

    public final int getOpenTime(String uuid) {
        if (this.connections.containsKey(uuid)) {
            return this.connections.get(uuid).getConnectionTime();
        }
        return 0;
    }

    public final int getTimeSinceLastTraveler(String uuid) {
        if (this.connections.containsKey(uuid)) {
            return this.connections.get(uuid).getTimeSinceLastTraveler();
        }
        return 0;
    }

    public final Stargate.Feedback createConnection(MinecraftServer server, Stargate dialingStargate, Stargate dialedStargate, Address.Type addressType, boolean doKawoosh) {
        StargateConnection.Type connectionType = StargateConnection.getType(server, dialingStargate, dialedStargate);
        if (SGJourneyEvents.onStargateConnect(server, dialingStargate, dialedStargate, connectionType, addressType, doKawoosh)) {
            return Stargate.Feedback.NONE;
        }
        if (!dialedStargate.checkStargateEntity(server)) {
            return dialingStargate.resetStargate(server, Stargate.Feedback.COULD_NOT_REACH_TARGET_STARGATE);
        }
        if (!((Boolean)CommonStargateConfig.allow_interstellar_8_chevron_addresses.get()).booleanValue() && addressType == Address.Type.ADDRESS_8_CHEVRON && connectionType == StargateConnection.Type.INTERSTELLAR) {
            return dialingStargate.resetStargate(server, Stargate.Feedback.INVALID_8_CHEVRON_ADDRESS, true);
        }
        if (!((Boolean)CommonStargateConfig.allow_system_wide_connections.get()).booleanValue() && connectionType == StargateConnection.Type.SYSTEM_WIDE) {
            return dialingStargate.resetStargate(server, Stargate.Feedback.INVALID_SYSTEM_WIDE_CONNECTION, true);
        }
        if (dialingStargate.equals(dialedStargate)) {
            return dialingStargate.resetStargate(server, Stargate.Feedback.SELF_DIAL, true);
        }
        if (dialedStargate.isConnected(server)) {
            return dialingStargate.resetStargate(server, Stargate.Feedback.ALREADY_CONNECTED, true);
        }
        if (dialedStargate.isObstructed(server)) {
            return dialingStargate.resetStargate(server, Stargate.Feedback.TARGET_OBSTRUCTED, true);
        }
        if (requireEnergy) {
            if (dialingStargate.canExtractEnergy(server, connectionType.getEstablishingPowerCost())) {
                dialingStargate.depleteEnergy(server, connectionType.getEstablishingPowerCost(), false);
            } else {
                return dialingStargate.resetStargate(server, Stargate.Feedback.NOT_ENOUGH_POWER, true);
            }
        }
        Optional<AbstractStargateEntity> outgoingStargate = dialingStargate.getStargateEntity(server);
        Optional<AbstractStargateEntity> incomingStargate = dialedStargate.getStargateEntity(server);
        if (outgoingStargate.isPresent() && incomingStargate.isPresent()) {
            StargateConnection connection;
            if (incomingStargate.get().shouldCallForward()) {
                SolarSystem.Serializable solarSystem;
                Optional<Stargate> reroutedStargate;
                Random random = new Random();
                Optional<SolarSystem.Serializable> solarSystemOptional = Universe.get(server).getSolarSystemFromDimension(dialedStargate.getDimension());
                if (solarSystemOptional.isPresent() && (reroutedStargate = (solarSystem = solarSystemOptional.get()).getRandomStargate(random.nextLong())).isPresent()) {
                    while (reroutedStargate.get().getStargateEntity(server).get().shouldCallForward()) {
                        reroutedStargate = solarSystem.getRandomStargate(random.nextLong());
                    }
                    incomingStargate = reroutedStargate.get().getStargateEntity(server);
                }
            }
            if ((connection = StargateConnection.create(connectionType, outgoingStargate.get(), incomingStargate.get(), doKawoosh)) != null) {
                this.addConnection(connection);
                switch (connectionType) {
                    case SYSTEM_WIDE: {
                        return Stargate.Feedback.CONNECTION_ESTABLISHED_SYSTEM_WIDE;
                    }
                    case INTERSTELLAR: {
                        return Stargate.Feedback.CONNECTION_ESTABLISHED_INTERSTELLAR;
                    }
                }
                return Stargate.Feedback.CONNECTION_ESTABLISHED_INTERGALACTIC;
            }
        }
        return Stargate.Feedback.COULD_NOT_REACH_TARGET_STARGATE;
    }

    public final boolean addConnection(StargateConnection connection) {
        if (!this.connections.containsKey(connection.getID())) {
            this.connections.put(connection.getID(), connection);
            return true;
        }
        return false;
    }

    public final boolean hasConnection(String uuid) {
        return this.connections.containsKey(uuid);
    }

    public final void terminateConnection(String uuid, Stargate.Feedback feedback) {
        if (this.hasConnection(uuid)) {
            this.connections.get(uuid).terminate(this.server, feedback);
        }
    }

    public final void removeConnection(String uuid, Stargate.Feedback feedback) {
        if (this.hasConnection(uuid)) {
            this.connections.remove(uuid);
            StargateJourney.LOGGER.info("Removed connection " + uuid);
        } else {
            StargateJourney.LOGGER.error("Could not find connection " + uuid);
        }
        this.m_77762_();
    }

    public final void printConnections() {
        System.out.println("[Connections]");
        this.connections.entrySet().stream().forEach(connectionEntry -> ((StargateConnection)connectionEntry.getValue()).printConnection());
    }

    public final boolean sendStargateMessage(AbstractStargateEntity sendingStargate, String uuid, String messsage) {
        if (this.hasConnection(uuid)) {
            this.connections.get(uuid).sendStargateMessage(sendingStargate, messsage);
            return true;
        }
        return false;
    }

    public final void sendStargateTransmission(AbstractStargateEntity sendingStargate, String uuid, int transmissionJumps, int frequency, String transmission) {
        if (this.hasConnection(uuid)) {
            this.connections.get(uuid).sendStargateTransmission(sendingStargate, transmissionJumps, frequency, transmission);
        }
    }

    public final float checkStargateShieldingState(AbstractStargateEntity sendingStargate, String uuid) {
        if (this.hasConnection(uuid)) {
            return this.connections.get(uuid).checkStargateShieldingState(sendingStargate);
        }
        return 0.0f;
    }

    private final CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(VERSION, this.version);
        tag.m_128365_(CONNECTIONS, (Tag)this.serializeConnections());
        return tag;
    }

    private final CompoundTag serializeConnections() {
        CompoundTag connectionsTag = new CompoundTag();
        this.connections.forEach((connectionID, connection) -> connectionsTag.m_128365_(connectionID, (Tag)connection.serialize()));
        return connectionsTag;
    }

    private final void deserialize(CompoundTag tag) {
        this.version = tag.m_128451_(VERSION);
        this.deserializeConnections(tag.m_128469_(CONNECTIONS));
    }

    private final void deserializeConnections(CompoundTag tag) {
        tag.m_128431_().forEach(connectionID -> this.connections.put((String)connectionID, StargateConnection.deserialize(this.server, connectionID, tag.m_128469_(connectionID))));
    }

    public static final void findStargates(ServerLevel level) {
        StargateJourney.LOGGER.info("Attempting to locate the Stargate Structure in " + level.m_46472_().m_135782_().toString());
        int xOffset = (Integer)CommonGenerationConfig.stargate_generation_center_x_chunk_offset.get();
        int zOffset = (Integer)CommonGenerationConfig.stargate_generation_center_z_chunk_offset.get();
        BlockPos blockpos = level.m_215011_(TagInit.Structures.HAS_STARGATE, new BlockPos(xOffset * 16, 0, zOffset * 16), 150, false);
        if (blockpos == null) {
            StargateJourney.LOGGER.info("Stargate Structure not found");
            return;
        }
        ArrayList stargates = new ArrayList();
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                ChunkAccess chunk = level.m_46865_(blockpos.m_122030_(16 * x).m_122020_(16 * z));
                Set positions = chunk.m_5928_();
                positions.stream().forEach(pos -> {
                    BlockEntity patt17396$temp = level.m_7702_(pos);
                    if (patt17396$temp instanceof AbstractStargateEntity) {
                        AbstractStargateEntity stargate = (AbstractStargateEntity)patt17396$temp;
                        stargates.add(stargate);
                    }
                });
            }
        }
        if (stargates.isEmpty()) {
            StargateJourney.LOGGER.info("No Stargates found in Stargate Structure");
            return;
        }
        stargates.stream().forEach(stargate -> stargate.onLoad());
    }

    public StargateNetwork(MinecraftServer server) {
        this.server = server;
    }

    public static StargateNetwork create(MinecraftServer server) {
        return new StargateNetwork(server);
    }

    public static StargateNetwork load(MinecraftServer server, CompoundTag tag) {
        StargateNetwork data = StargateNetwork.create(server);
        data.server = server;
        data.deserialize(tag);
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag = this.serialize();
        return tag;
    }

    @Nonnull
    public static StargateNetwork get(Level level) {
        if (level.m_5776_()) {
            throw new RuntimeException("Don't access this client-side!");
        }
        return StargateNetwork.get(level.m_7654_());
    }

    @Nonnull
    public static StargateNetwork get(MinecraftServer server) {
        DimensionDataStorage storage = server.m_129783_().m_8895_();
        return (StargateNetwork)storage.m_164861_(tag -> StargateNetwork.load(server, tag), () -> StargateNetwork.create(server), FILE_NAME);
    }
}

