/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.stargate;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.dhd.AbstractDHDEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.compatibility.cctweaked.CCTweakedCompatibility;
import net.povstalec.sgjourney.common.compatibility.cctweaked.StargatePeripheralWrapper;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.packets.ClientBoundSoundPackets;
import net.povstalec.sgjourney.common.packets.ClientboundUniverseStargateUpdatePacket;
import net.povstalec.sgjourney.common.stargate.Address;
import net.povstalec.sgjourney.common.stargate.Stargate;
import org.jetbrains.annotations.NotNull;

public class UniverseStargateEntity
extends AbstractStargateEntity {
    public static final boolean FAST_ROTATION = (Boolean)CommonStargateConfig.universe_fast_rotation.get();
    public static final int MAX_ROTATION = 54 * (FAST_ROTATION ? 2 : 3);
    public static final int ROTATION_INCREASE = 1;
    public static final int ANGLE = MAX_ROTATION / 54;
    public static final int ROTATION_THIRD = MAX_ROTATION / 3;
    public static final int RESET_DEGREES = ROTATION_THIRD * 2;
    public static final int WAIT_TICKS = 20;
    public int animationTicks = 1;
    protected static final String UNIVERSAL = "sgjourney:universal";
    protected static final String POINT_OF_ORIGIN = "sgjourney:universal";
    protected static final String SYMBOLS = "sgjourney:universal";
    public int oldRotation = RESET_DEGREES;
    public int rotation = RESET_DEGREES;
    public Address addressBuffer = new Address(true);
    public int symbolBuffer = 0;

    public UniverseStargateEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.UNIVERSE_STARGATE.get(), new ResourceLocation("sgjourney", "universe/universe"), pos, state, Stargate.Gen.GEN_1, 1);
        this.setOpenSoundLead(8);
        this.symbolBounds = 35;
    }

    @Override
    public void onLoad() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.setPointOfOrigin("sgjourney:universal");
        this.setSymbols("sgjourney:universal");
        super.onLoad();
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.oldRotation = this.rotation = tag.m_128451_("Rotation");
        this.addressBuffer.fromArray(tag.m_128465_("AddressBuffer"));
        this.symbolBuffer = tag.m_128451_("SymbolBuffer");
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Rotation", this.rotation);
        tag.m_128385_("AddressBuffer", this.addressBuffer.toArray());
        tag.m_128405_("SymbolBuffer", this.symbolBuffer);
    }

    @Override
    public void updateDHD() {
        if (this.hasDHD()) {
            ((AbstractDHDEntity)((Object)this.dhd.get())).updateDHD(!this.isConnected() || this.isConnected() && this.isDialingOut() ? this.addressBuffer : new Address(), this.addressBuffer.hasPointOfOrigin() || this.isConnected());
        }
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public boolean isRotating() {
        return this.rotation != this.oldRotation;
    }

    @Override
    public Stargate.Feedback engageSymbol(int symbol) {
        if (this.f_58857_.m_5776_()) {
            return Stargate.Feedback.NONE;
        }
        if (this.isSymbolOutOfBounds(symbol)) {
            return this.setRecentFeedback(Stargate.Feedback.SYMBOL_OUT_OF_BOUNDS);
        }
        if (this.isConnected()) {
            if (symbol == 0) {
                return this.disconnectStargate(Stargate.Feedback.CONNECTION_ENDED_BY_DISCONNECT, true);
            }
            return this.setRecentFeedback(Stargate.Feedback.ENCODE_WHEN_CONNECTED);
        }
        if (symbol == 0 && !this.isConnected() && this.addressBuffer.getLength() == 0) {
            return this.setRecentFeedback(Stargate.Feedback.INCOMPLETE_ADDRESS);
        }
        if (this.addressBuffer.containsSymbol(symbol)) {
            return this.setRecentFeedback(Stargate.Feedback.SYMBOL_IN_ADDRESS);
        }
        if (this.addressBuffer.getLength() == 0 && this.address.getLength() == 0) {
            this.startSound();
        }
        this.addressBuffer.addSymbol(symbol);
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientboundUniverseStargateUpdatePacket(this.f_58858_, this.symbolBuffer, this.addressBuffer.toArray(), this.animationTicks, this.rotation, this.oldRotation));
        return this.setRecentFeedback(Stargate.Feedback.SYMBOL_ENCODED);
    }

    @Override
    protected Stargate.Feedback lockPrimaryChevron() {
        return super.lockPrimaryChevron();
    }

    @Override
    public Stargate.Feedback encodeChevron(int symbol, boolean incoming, boolean encode) {
        ++this.symbolBuffer;
        ++this.animationTicks;
        Stargate.Feedback feedback = super.encodeChevron(symbol, incoming, encode);
        return feedback;
    }

    public void startSound() {
        if (!this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.UniverseStart(this.f_58858_));
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, UniverseStargateEntity stargate) {
        if (!stargate.isConnected() && stargate.addressBuffer.getLength() > stargate.symbolBuffer) {
            if (stargate.animationTicks <= 0) {
                stargate.rotateToSymbol(stargate.addressBuffer.getSymbol(stargate.symbolBuffer), true);
            } else if (stargate.animationTicks >= 20) {
                stargate.animationTicks = 0;
            } else if (stargate.animationTicks > 0) {
                ++stargate.animationTicks;
            }
        } else if (!stargate.isConnected() && stargate.addressBuffer.getLength() == 0) {
            stargate.rotateToDefault();
        } else {
            stargate.updateClient();
        }
        if (!stargate.f_58857_.m_5776_()) {
            if (stargate.isRotating()) {
                PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(stargate.f_58858_)), (Object)new ClientBoundSoundPackets.StargateRotation(stargate.f_58858_, false));
            } else {
                PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(stargate.f_58858_)), (Object)new ClientBoundSoundPackets.StargateRotation(stargate.f_58858_, true));
            }
        }
        AbstractStargateEntity.tick(level, pos, state, stargate);
    }

    public int getDesiredRotation(int desiredSymbol) {
        int whole = desiredSymbol / 4;
        int leftover = desiredSymbol % 4;
        return 3 * (ANGLE / 2) + whole * MAX_ROTATION / 9 + ANGLE * leftover;
    }

    public void rotate(boolean clockwise) {
        this.rotation = clockwise ? --this.rotation : ++this.rotation;
        if (this.rotation >= MAX_ROTATION) {
            this.rotation -= MAX_ROTATION;
            this.oldRotation -= MAX_ROTATION;
        } else if (this.rotation < 0) {
            this.rotation += MAX_ROTATION;
            this.oldRotation += MAX_ROTATION;
        }
        this.m_6596_();
    }

    public boolean isCurrentSymbol(int desiredSymbol) {
        return this.getDesiredRotation(desiredSymbol) == this.rotation;
    }

    @Override
    public int getRedstoneSymbolOutput() {
        int halfRotation = this.rotation / 2;
        if (halfRotation % 6 == 0 || halfRotation % 6 == 1) {
            return 0;
        }
        int emptyASymbols = halfRotation / 6 + 1;
        int emptyBSymbols = halfRotation / 6;
        int result = this.rotation / 2 - emptyASymbols - emptyBSymbols;
        return result % 12 + 1;
    }

    @Override
    public int getRedstoneSegmentOutput() {
        return (this.rotation / ROTATION_THIRD + 1) * 5;
    }

    public float getRotation(float partialTick) {
        return StargateJourneyConfig.disable_smooth_animations.get() ? (float)this.getRotation() : Mth.m_14179_((float)partialTick, (float)this.oldRotation, (float)this.rotation);
    }

    private void rotateToSymbol(int desiredSymbol, boolean engage) {
        this.oldRotation = this.rotation;
        if (this.isCurrentSymbol(desiredSymbol)) {
            if (!engage) {
                return;
            }
            this.updateClient();
            if (this.isCurrentSymbol(0)) {
                this.lockPrimaryChevron();
            } else {
                this.encodeChevron(desiredSymbol, false, false);
            }
            this.updateClient();
        } else if (((Boolean)CommonStargateConfig.universe_best_direction.get()).booleanValue()) {
            this.rotate(this.getBestRotationDirection(desiredSymbol));
        } else {
            this.rotate(this.getAlternatingRotationDirection(this.getAddress().getLength()));
        }
    }

    private void rotateToDefault() {
        this.oldRotation = this.rotation;
        if (this.rotation == RESET_DEGREES) {
            this.updateClient();
        } else {
            this.rotate(UniverseStargateEntity.getBestRotationDirection(RESET_DEGREES, this.rotation));
        }
    }

    private boolean getAlternatingRotationDirection(int addressLength) {
        return addressLength % 2 == 1;
    }

    private boolean getBestRotationDirection(int desiredSymbol) {
        int whole = desiredSymbol / 4;
        int leftover = desiredSymbol % 4;
        double desiredPosition = 3 * (ANGLE / 2) + whole * MAX_ROTATION / 9 + ANGLE * leftover;
        double position = this.rotation;
        return UniverseStargateEntity.getBestRotationDirection(desiredPosition, position);
    }

    private static boolean getBestRotationDirection(double desiredRotation, double rotation) {
        double difference = desiredRotation - rotation;
        if (difference >= (double)(MAX_ROTATION / 2)) {
            rotation = MAX_ROTATION;
        } else if (difference <= (double)(-MAX_ROTATION / 2)) {
            rotation = -MAX_ROTATION;
        }
        double lowerBound = desiredRotation - 1.0;
        return rotation > lowerBound;
    }

    @Override
    protected void resetAddress(boolean updateInterfaces) {
        this.animationTicks = 1;
        this.symbolBuffer = 0;
        this.addressBuffer.reset();
        super.resetAddress(updateInterfaces);
    }

    @Override
    public void updateClient() {
        super.updateClient();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientboundUniverseStargateUpdatePacket(this.f_58858_, this.symbolBuffer, this.addressBuffer.toArray(), this.animationTicks, this.rotation, this.oldRotation));
    }

    @Override
    public void playRotationSound() {
        if (!this.spinSound.isPlaying()) {
            this.spinSound.playSound();
        }
    }

    @Override
    public void stopRotationSound() {
        this.spinSound.stopSound();
    }

    @Override
    public Stargate.ChevronLockSpeed getChevronLockSpeed() {
        return (Stargate.ChevronLockSpeed)((Object)CommonStargateConfig.universe_chevron_lock_speed.get());
    }

    @Override
    public void registerInterfaceMethods(StargatePeripheralWrapper wrapper) {
        CCTweakedCompatibility.registerUniverseStargateMethods(wrapper);
    }

    @Override
    public void doWhileDialed(int openTime, Stargate.ChevronLockSpeed chevronLockSpeed) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (openTime == 1) {
            this.startSound();
        }
        this.rotateToSymbol(0, false);
    }
}

