/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.tech.TransportRingsEntity;
import net.povstalec.sgjourney.common.data.TransporterNetwork;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.packets.ClientboundRingPanelUpdatePacket;
import net.povstalec.sgjourney.common.stargate.Transporter;
import org.jetbrains.annotations.NotNull;

public class RingPanelEntity
extends BlockEntity {
    public static final String INVENTORY = "Inventory";
    private BlockPos targetPos;
    public ArrayList<BlockPos> ringsPos = new ArrayList();
    public ArrayList<Component> ringsName = new ArrayList();
    private final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    private TransportRingsEntity transportRings;

    public RingPanelEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.RING_PANEL.get(), pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_(INVENTORY));
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        nbt.m_128365_(INVENTORY, (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(nbt);
    }

    private void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public void m_7651_() {
        super.m_7651_();
        this.handler.invalidate();
        this.drops();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(6){

            protected void onContentsChanged(int slot) {
                RingPanelEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                switch (slot) {
                    case 0: {
                        return stack.m_41720_() == ItemInit.MEMORY_CRYSTAL.get();
                    }
                    case 1: {
                        return stack.m_41720_() == ItemInit.MEMORY_CRYSTAL.get();
                    }
                    case 2: {
                        return stack.m_41720_() == ItemInit.MEMORY_CRYSTAL.get();
                    }
                    case 3: {
                        return stack.m_41720_() == ItemInit.MEMORY_CRYSTAL.get();
                    }
                    case 4: {
                        return stack.m_41720_() == ItemInit.MEMORY_CRYSTAL.get();
                    }
                    case 5: {
                        return stack.m_41720_() == ItemInit.MEMORY_CRYSTAL.get();
                    }
                }
                return false;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(capability, side);
    }

    public void getNearest6Rings(Level level, BlockPos pos, double maxDistance) {
        if (this.transportRings == null) {
            return;
        }
        Optional<List<Transporter>> transporterListOptional = TransporterNetwork.get(level).getTransportersFromDimension((ResourceKey<Level>)level.m_46472_());
        if (transporterListOptional.isEmpty()) {
            return;
        }
        List<Transporter> transporters = transporterListOptional.get();
        transporters.sort((transportRingsA, transportRingsB) -> Long.valueOf(this.distanceSqr(this.m_58899_(), transportRingsA.getBlockPos())).compareTo(this.distanceSqr(this.m_58899_(), transportRingsB.getBlockPos())));
        this.ringsPos.clear();
        this.ringsName.clear();
        int ringsFound = transporters.size();
        int j = 0;
        if (ringsFound > 0 && transporters.get(0).getBlockPos().equals((Object)this.transportRings.m_58899_())) {
            ++j;
        }
        for (int i = 0; i < 6 && j < ringsFound; ++i, ++j) {
            Transporter transporter = transporters.get(j);
            this.ringsPos.add(transporter.getBlockPos());
            this.ringsName.add(transporter.getName());
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(this.f_58858_)), (Object)new ClientboundRingPanelUpdatePacket(this.f_58858_, this.ringsPos, this.ringsName));
    }

    protected List<TransportRingsEntity> getNearbyTransportRings(int maxDistance) {
        ArrayList<TransportRingsEntity> transportRingsList = new ArrayList<TransportRingsEntity>();
        for (int x = -maxDistance / 16; x <= maxDistance / 16; ++x) {
            for (int z = -maxDistance / 16; z <= maxDistance / 16; ++z) {
                ChunkAccess chunk = this.f_58857_.m_46865_(this.m_58899_().m_122030_(16 * x).m_122020_(16 * z));
                Set positions = chunk.m_5928_();
                positions.stream().forEach(pos -> {
                    BlockEntity patt6304$temp = this.f_58857_.m_7702_(pos);
                    if (patt6304$temp instanceof TransportRingsEntity) {
                        TransportRingsEntity transportRings = (TransportRingsEntity)patt6304$temp;
                        transportRingsList.add(transportRings);
                    }
                });
            }
        }
        return transportRingsList;
    }

    private long distanceSqr(BlockPos pos, BlockPos targetPos) {
        int x = Math.abs(targetPos.m_123341_() - pos.m_123341_());
        int y = Math.abs(targetPos.m_123342_() - pos.m_123342_());
        int z = Math.abs(targetPos.m_123343_() - pos.m_123343_());
        long distance = x * x + y * y + z * z;
        return distance;
    }

    public TransportRingsEntity findNearestTransportRings(int maxDistance) {
        Iterator<TransportRingsEntity> iterator;
        List<TransportRingsEntity> transportRingsList = this.getNearbyTransportRings(maxDistance);
        transportRingsList.sort((transportRingsA, transportRingsB) -> Long.valueOf(this.distanceSqr(this.m_58899_(), transportRingsA.m_58899_())).compareTo(this.distanceSqr(this.m_58899_(), transportRingsB.m_58899_())));
        if (!transportRingsList.isEmpty() && (iterator = transportRingsList.iterator()).hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public void setTransportRings() {
        if (this.m_58904_() == null) {
            return;
        }
        this.transportRings = this.findNearestTransportRings(16);
    }

    public void activateRings(int chosenNumber) {
        ItemStack stack = this.itemHandler.getStackInSlot(chosenNumber);
        if (!stack.m_41619_() && stack.m_41783_().m_128441_("coordinates")) {
            int[] coordinates = this.itemHandler.getStackInSlot(chosenNumber).m_41783_().m_128465_("coordinates");
            this.targetPos = new BlockPos(coordinates[0], coordinates[1], coordinates[2]);
        } else if (chosenNumber < this.ringsPos.size()) {
            this.targetPos = this.ringsPos.get(chosenNumber);
        }
        if (this.targetPos == null) {
            return;
        }
        if (this.transportRings == null || !this.transportRings.canTransport()) {
            return;
        }
        BlockEntity targetRings = this.f_58857_.m_7702_(this.targetPos);
        if (targetRings instanceof TransportRingsEntity) {
            TransportRingsEntity target = (TransportRingsEntity)targetRings;
            if (!target.canTransport()) {
                return;
            }
            this.transportRings.activate(this.targetPos);
        }
    }

    public int[] getTargetCoords(int chosenNumber) {
        ItemStack stack = this.itemHandler.getStackInSlot(chosenNumber);
        if (!stack.m_41619_() && stack.m_41783_().m_128441_("coordinates")) {
            return this.itemHandler.getStackInSlot(chosenNumber).m_41783_().m_128465_("coordinates");
        }
        return new int[]{0, 0, 0};
    }
}

