/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.resourcepack;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.fml.common.Mod;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.ClassicStargateVariant;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.ClientStargateVariants;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.MilkyWayStargateVariant;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.PegasusStargateVariant;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.TollanStargateVariant;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.UniverseStargateVariant;
import net.povstalec.sgjourney.common.stargate.StargateVariant;

public class ResourcepackReloadListener {
    public static final String PATH = "sgjourney";
    public static final String STARGATE_VARIANT = "stargate_variant";
    public static final String UNIVERSE = "universe";
    public static final String MILKY_WAY = "milky_way";
    public static final String PEGASUS = "pegasus";
    public static final String TOLLAN = "tollan";
    public static final String CLASSIC = "classic";
    public static final ResourceLocation UNIVERSE_STARGATE = new ResourceLocation("sgjourney", "universe_stargate");
    public static final ResourceLocation MILKY_WAY_STARGATE = new ResourceLocation("sgjourney", "milky_way_stargate");
    public static final ResourceLocation PEGASUS_STARGATE = new ResourceLocation("sgjourney", "pegasus_stargate");
    public static final ResourceLocation TOLLAN_STARGATE = new ResourceLocation("sgjourney", "tollan_stargate");
    public static final ResourceLocation CLASSIC_STARGATE = new ResourceLocation("sgjourney", "classic_stargate");
    private static Minecraft minecraft = Minecraft.m_91087_();

    @Mod.EventBusSubscriber(modid="sgjourney", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ReloadListener
    extends SimpleJsonResourceReloadListener {
        public ReloadListener() {
            super(new GsonBuilder().create(), ResourcepackReloadListener.PATH);
        }

        protected void apply(Map<ResourceLocation, JsonElement> jsonMap, ResourceManager manager, ProfilerFiller filler) {
            StargateJourney.LOGGER.debug("---------- Loading Stargate Variants ----------");
            ClientStargateVariants.clear();
            ClientPacketListener clientPacketListener = minecraft.m_91403_();
            if (clientPacketListener != null) {
                RegistryAccess registries = clientPacketListener.m_105152_();
                Registry variantRegistry = registries.m_175515_(StargateVariant.REGISTRY_KEY);
                for (Map.Entry stargateVariantEntry : variantRegistry.m_6579_()) {
                    ((StargateVariant)stargateVariantEntry.getValue()).resetMissing();
                }
            }
            for (Map.Entry<ResourceLocation, JsonElement> jsonEntry : jsonMap.entrySet()) {
                ResourceLocation location = jsonEntry.getKey();
                JsonElement element = jsonEntry.getValue();
                if (!ReloadListener.canShortenPath(location, ResourcepackReloadListener.STARGATE_VARIANT)) continue;
                if (ReloadListener.canShortenPath(location = ReloadListener.shortenPath(location, ResourcepackReloadListener.STARGATE_VARIANT), ResourcepackReloadListener.UNIVERSE)) {
                    ReloadListener.addUniverseStargateVariant(ReloadListener.shortenPath(location, ResourcepackReloadListener.UNIVERSE), element);
                    continue;
                }
                if (ReloadListener.canShortenPath(location, ResourcepackReloadListener.MILKY_WAY)) {
                    ReloadListener.addMilkyWayStargateVariant(ReloadListener.shortenPath(location, ResourcepackReloadListener.MILKY_WAY), element);
                    continue;
                }
                if (ReloadListener.canShortenPath(location, ResourcepackReloadListener.PEGASUS)) {
                    ReloadListener.addPegasusStargateVariant(ReloadListener.shortenPath(location, ResourcepackReloadListener.PEGASUS), element);
                    continue;
                }
                if (ReloadListener.canShortenPath(location, ResourcepackReloadListener.TOLLAN)) {
                    ReloadListener.addTollanStargateVariant(ReloadListener.shortenPath(location, ResourcepackReloadListener.TOLLAN), element);
                    continue;
                }
                if (!ReloadListener.canShortenPath(location, ResourcepackReloadListener.CLASSIC)) continue;
                ReloadListener.addClassicStargateVariant(ReloadListener.shortenPath(location, ResourcepackReloadListener.CLASSIC), element);
            }
        }

        private static void addUniverseStargateVariant(ResourceLocation location, JsonElement element) {
            try {
                JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)ResourcepackReloadListener.STARGATE_VARIANT);
                UniverseStargateVariant stargateVariant = (UniverseStargateVariant)UniverseStargateVariant.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, msg -> StargateJourney.LOGGER.error("Failed to parse Stargate Variant", msg));
                ClientStargateVariants.addUniverseStargateVariant(location, stargateVariant);
                StargateJourney.LOGGER.debug("Loaded Universe Stargate Variant: " + location.toString());
            }
            catch (RuntimeException e) {
                StargateJourney.LOGGER.error("Could not load Universe Stargate Variant: " + location.toString());
                StargateJourney.LOGGER.error(e.getMessage());
            }
        }

        private static void addMilkyWayStargateVariant(ResourceLocation location, JsonElement element) {
            try {
                JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)ResourcepackReloadListener.STARGATE_VARIANT);
                MilkyWayStargateVariant stargateVariant = (MilkyWayStargateVariant)MilkyWayStargateVariant.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, msg -> StargateJourney.LOGGER.error("Failed to parse Stargate Variant", msg));
                ClientStargateVariants.addMilkyWayStargateVariant(location, stargateVariant);
                StargateJourney.LOGGER.debug("Loaded Milky Way Stargate Variant: " + location.toString());
            }
            catch (RuntimeException e) {
                StargateJourney.LOGGER.error("Could not load Milky Way Stargate Variant: " + location.toString());
                StargateJourney.LOGGER.error(e.getMessage());
            }
        }

        private static void addPegasusStargateVariant(ResourceLocation location, JsonElement element) {
            try {
                JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)ResourcepackReloadListener.STARGATE_VARIANT);
                PegasusStargateVariant stargateVariant = (PegasusStargateVariant)PegasusStargateVariant.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, msg -> StargateJourney.LOGGER.error("Failed to parse Stargate Variant", msg));
                ClientStargateVariants.addPegasusStargateVariant(location, stargateVariant);
                StargateJourney.LOGGER.debug("Loaded Pegasus Stargate Variant: " + location.toString());
            }
            catch (RuntimeException e) {
                StargateJourney.LOGGER.error("Could not load Pegasus Stargate Variant: " + location.toString());
                StargateJourney.LOGGER.error(e.getMessage());
            }
        }

        private static void addTollanStargateVariant(ResourceLocation location, JsonElement element) {
            try {
                JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)ResourcepackReloadListener.STARGATE_VARIANT);
                TollanStargateVariant stargateVariant = (TollanStargateVariant)TollanStargateVariant.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, msg -> StargateJourney.LOGGER.error("Failed to parse Stargate Variant", msg));
                ClientStargateVariants.addTollanStargateVariant(location, stargateVariant);
                StargateJourney.LOGGER.debug("Loaded Tollan Stargate Variant: " + location.toString());
            }
            catch (RuntimeException e) {
                StargateJourney.LOGGER.error("Could not load Tollan Stargate Variant: " + location.toString());
                StargateJourney.LOGGER.error(e.getMessage());
            }
        }

        private static void addClassicStargateVariant(ResourceLocation location, JsonElement element) {
            try {
                JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)ResourcepackReloadListener.STARGATE_VARIANT);
                ClassicStargateVariant stargateVariant = (ClassicStargateVariant)ClassicStargateVariant.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, msg -> StargateJourney.LOGGER.error("Failed to parse Stargate Variant", msg));
                ClientStargateVariants.addClassicStargateVariant(location, stargateVariant);
                StargateJourney.LOGGER.debug("Loaded Classic Stargate Variant: " + location.toString());
            }
            catch (RuntimeException e) {
                StargateJourney.LOGGER.error("Could not load Classic Stargate Variant: " + location.toString());
                StargateJourney.LOGGER.error(e.getMessage());
            }
        }

        public static void registerReloadListener(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)new ReloadListener());
        }

        private static boolean canShortenPath(ResourceLocation location, String shortenBy) {
            return location.m_135815_().startsWith(shortenBy) && location.m_135815_().length() > shortenBy.length();
        }

        private static ResourceLocation shortenPath(ResourceLocation location, String shortenBy) {
            return location.m_247449_(location.m_135815_().substring(shortenBy.length() + 1));
        }
    }
}

