/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import dan200.computercraft.core.util.Nullability;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public final class OptionScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("computercraft", "textures/gui/blank_screen.png");
    public static final int BUTTON_WIDTH = 100;
    public static final int BUTTON_HEIGHT = 20;
    private static final int PADDING = 16;
    private static final int FONT_HEIGHT = 9;
    private int x;
    private int y;
    private int innerWidth;
    private int innerHeight;
    @Nullable
    private MultiLineLabel messageRenderer;
    private final Component message;
    private final List<AbstractWidget> buttons;
    private final Runnable exit;
    private final Screen originalScreen;

    private OptionScreen(Component title, Component message, List<AbstractWidget> buttons, Runnable exit, Screen originalScreen) {
        super(title);
        this.message = message;
        this.buttons = buttons;
        this.exit = exit;
        this.originalScreen = originalScreen;
    }

    public static void show(Minecraft minecraft, Component title, Component message, List<AbstractWidget> buttons, Runnable exit) {
        minecraft.m_91152_((Screen)new OptionScreen(title, message, buttons, exit, OptionScreen.unwrap(minecraft.f_91080_)));
    }

    public static Screen unwrap(Screen screen) {
        Screen screen2;
        if (screen instanceof OptionScreen) {
            OptionScreen option = (OptionScreen)screen;
            screen2 = option.getOriginalScreen();
        } else {
            screen2 = screen;
        }
        return screen2;
    }

    public void m_7856_() {
        super.m_7856_();
        int buttonWidth = 100 * this.buttons.size() + 16 * (this.buttons.size() - 1);
        int innerWidth = this.innerWidth = Math.max(256, buttonWidth + 32);
        this.messageRenderer = MultiLineLabel.m_94341_((Font)this.f_96547_, (FormattedText)this.message, (int)(innerWidth - 32));
        int textHeight = this.messageRenderer.m_5770_() * 9 + 32;
        this.innerHeight = textHeight + (this.buttons.isEmpty() ? 0 : this.buttons.get(0).m_93694_()) + 16;
        this.x = (this.f_96543_ - innerWidth) / 2;
        this.y = (this.f_96544_ - this.innerHeight) / 2;
        int x = (this.f_96543_ - buttonWidth) / 2;
        for (AbstractWidget button : this.buttons) {
            button.m_264152_(x, this.y + textHeight);
            this.m_142416_((GuiEventListener)button);
            x += 116;
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        graphics.m_280218_(BACKGROUND, this.x, this.y, 0, 0, this.innerWidth, 16);
        graphics.m_280163_(BACKGROUND, this.x, this.y + 16, 0.0f, 16.0f, this.innerWidth, this.innerHeight - 32, this.innerWidth, 16);
        graphics.m_280218_(BACKGROUND, this.x, this.y + this.innerHeight - 16, 0, 240, this.innerWidth, 16);
        Nullability.assertNonNull(this.messageRenderer).m_6516_(graphics, this.x + 16, this.y + 16, 9, 0x404040);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    public void m_7379_() {
        this.exit.run();
    }

    public static AbstractWidget newButton(Component component, Button.OnPress clicked) {
        return Button.m_253074_((Component)component, (Button.OnPress)clicked).m_252987_(0, 0, 100, 20).m_253136_();
    }

    public Screen getOriginalScreen() {
        return this.originalScreen;
    }
}

