/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.managed;

import com.lowdragmc.lowdraglib.syncdata.managed.IManagedVar;
import java.util.Map;

public class ManagedHolder<T>
implements IManagedVar<T> {
    private static Map<Class<?>, Class<?>> primitiveToWrapper = Map.of(Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Short.TYPE, Short.class);
    private T value;
    private final Class<T> type;

    public ManagedHolder(T value, Class<T> type) {
        this.type = type;
        this.set(value);
    }

    public static <T> ManagedHolder<T> of(T value) {
        return new ManagedHolder<T>(value, value.getClass());
    }

    public static <T> ManagedHolder<T> ofType(Class<T> type) {
        if (type.isPrimitive()) {
            type = primitiveToWrapper.get(type);
        }
        return new ManagedHolder<Object>(null, type);
    }

    @Override
    public T value() {
        return this.value;
    }

    @Override
    public void set(T value) {
        if (value != null && !this.type.isInstance(value)) {
            throw new IllegalArgumentException("Value is not of type " + this.type);
        }
        this.value = value;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }
}

