/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@LDLRegister(name="text_texture", group="widget.basic")
public class TextTextureWidget
extends Widget
implements IConfigurableWidget {
    @Configurable(name="ldlib.gui.editor.name.text")
    private Component lastComponent;
    @Configurable(name="ldlib.gui.editor.name.text", subConfigurable=true)
    private final TextTexture textTexture = new TextTexture();
    private Supplier<Component> textSupplier;

    public TextTextureWidget() {
        this(0, 0, 50, 50, "Text");
    }

    public TextTextureWidget(int xPosition, int yPosition, int width, int height) {
        this(xPosition, yPosition, width, height, "");
    }

    public TextTextureWidget(int xPosition, int yPosition, int width, int height, String text) {
        super(xPosition, yPosition, width, height);
        this.textTexture.setDropShadow(true);
        this.textTexture.setWidth(width);
        this.textTexture.setSupplier(() -> this.lastComponent == null ? "" : this.lastComponent.getString());
        if (this.isRemote()) {
            this.lastComponent = Component.m_237115_((String)text);
        }
        this.setText(text);
    }

    @ConfigSetter(field="lastComponent")
    public void setLastComponent(Component component) {
        this.lastComponent = component;
        this.setText(component);
    }

    @Override
    @ConfigSetter(field="size")
    public void setSize(Size size) {
        super.setSize(size);
        this.textTexture.setWidth(size.width);
    }

    public TextTextureWidget textureStyle(Consumer<TextTexture> consumer) {
        consumer.accept(this.textTexture);
        return this;
    }

    public TextTextureWidget setText(String text) {
        this.textSupplier = () -> Component.m_237115_((String)text);
        return this;
    }

    public TextTextureWidget setText(Component text) {
        this.textSupplier = () -> text;
        return this;
    }

    public TextTextureWidget setText(Supplier<Component> textSupplier) {
        this.textSupplier = textSupplier;
        return this;
    }

    @Override
    public void writeInitialData(FriendlyByteBuf buffer) {
        super.writeInitialData(buffer);
        if (!this.isClientSideWidget) {
            buffer.writeBoolean(true);
            this.lastComponent = this.textSupplier.get();
            buffer.m_130083_(this.lastComponent);
        } else {
            buffer.writeBoolean(false);
        }
    }

    @Override
    public void readInitialData(FriendlyByteBuf buffer) {
        super.readInitialData(buffer);
        if (buffer.readBoolean()) {
            this.lastComponent = buffer.m_130238_();
        }
    }

    @Override
    public void detectAndSendChanges() {
        Component latest;
        super.detectAndSendChanges();
        if (!this.isClientSideWidget && !(latest = this.textSupplier.get()).equals(this.lastComponent)) {
            this.lastComponent = latest;
            this.writeUpdateInfo(-1, buffer -> buffer.m_130083_(this.lastComponent));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
        if (id == -1) {
            this.lastComponent = buffer.m_130238_();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateScreen() {
        Component latest;
        super.updateScreen();
        if (this.isClientSideWidget && !(latest = this.textSupplier.get()).equals(this.lastComponent)) {
            this.lastComponent = latest;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        Position position = this.getPosition();
        Size size = this.getSize();
        this.textTexture.draw(graphics, mouseX, mouseY, position.x, position.y, size.width, size.height);
        this.drawOverlay(graphics, mouseX, mouseY, partialTicks);
    }

    public Component getLastComponent() {
        return this.lastComponent;
    }

    public TextTexture getTextTexture() {
        return this.textTexture;
    }
}

