/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.texture;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.TransformTexture;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@LDLRegister(name="progress_texture", group="texture")
public class ProgressTexture
extends TransformTexture {
    @Configurable
    protected FillDirection fillDirection = FillDirection.LEFT_TO_RIGHT;
    @Configurable
    protected IGuiTexture emptyBarArea;
    @Configurable
    protected IGuiTexture filledBarArea;
    protected double progress;
    private boolean demo;

    public ProgressTexture() {
        this(new ResourceTexture("ldlib:textures/gui/progress_bar_fuel.png").getSubTexture(0.0, 0.0, 1.0, 0.5), new ResourceTexture("ldlib:textures/gui/progress_bar_fuel.png").getSubTexture(0.0, 0.5, 1.0, 0.5));
        this.fillDirection = FillDirection.DOWN_TO_UP;
        this.demo = true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateTick() {
        if (this.emptyBarArea != null) {
            this.emptyBarArea.updateTick();
        }
        if (this.filledBarArea != null) {
            this.filledBarArea.updateTick();
        }
        if (this.demo) {
            this.progress = (double)Math.abs(System.currentTimeMillis() % 2000L) / 2000.0;
        }
    }

    public ProgressTexture(IGuiTexture emptyBarArea, IGuiTexture filledBarArea) {
        this.emptyBarArea = emptyBarArea;
        this.filledBarArea = filledBarArea;
    }

    public void setProgress(double progress) {
        this.progress = Mth.m_14008_((double)0.0, (double)progress, (double)1.0);
    }

    public ProgressTexture setFillDirection(FillDirection fillDirection) {
        this.fillDirection = fillDirection;
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void drawInternal(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        if (this.emptyBarArea != null) {
            this.emptyBarArea.draw(graphics, mouseX, mouseY, x, y, width, height);
        }
        if (this.filledBarArea != null) {
            float drawnU = (float)this.fillDirection.getDrawnU(this.progress);
            float drawnV = (float)this.fillDirection.getDrawnV(this.progress);
            float drawnWidth = (float)this.fillDirection.getDrawnWidth(this.progress);
            float drawnHeight = (float)this.fillDirection.getDrawnHeight(this.progress);
            float X = x + drawnU * (float)width;
            float Y = y + drawnV * (float)height;
            float W = (float)width * drawnWidth;
            float H = (float)height * drawnHeight;
            this.filledBarArea.drawSubArea(graphics, X, Y, W, H, drawnU, drawnV, drawnWidth * (float)width / (float)width, drawnHeight * (float)height / (float)height);
        }
    }

    @Override
    public void setUIResource(Resource<IGuiTexture> texturesResource) {
        if (this.emptyBarArea != null) {
            this.emptyBarArea.setUIResource(texturesResource);
        }
        if (this.filledBarArea != null) {
            this.filledBarArea.setUIResource(texturesResource);
        }
    }

    public IGuiTexture getEmptyBarArea() {
        return this.emptyBarArea;
    }

    public IGuiTexture getFilledBarArea() {
        return this.filledBarArea;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum FillDirection {
        LEFT_TO_RIGHT{

            @Override
            public double getDrawnHeight(double progress) {
                return 1.0;
            }
        }
        ,
        RIGHT_TO_LEFT{

            @Override
            public double getDrawnU(double progress) {
                return 1.0 - progress;
            }

            @Override
            public double getDrawnHeight(double progress) {
                return 1.0;
            }
        }
        ,
        UP_TO_DOWN{

            @Override
            public double getDrawnWidth(double progress) {
                return 1.0;
            }
        }
        ,
        DOWN_TO_UP{

            @Override
            public double getDrawnV(double progress) {
                return 1.0 - progress;
            }

            @Override
            public double getDrawnWidth(double progress) {
                return 1.0;
            }
        }
        ,
        ALWAYS_FULL{

            @Override
            public double getDrawnHeight(double progress) {
                return 1.0;
            }

            @Override
            public double getDrawnWidth(double progress) {
                return 1.0;
            }
        };


        public double getDrawnU(double progress) {
            return 0.0;
        }

        public double getDrawnV(double progress) {
            return 0.0;
        }

        public double getDrawnWidth(double progress) {
            return progress;
        }

        public double getDrawnHeight(double progress) {
            return progress;
        }
    }

    public static class Auto
    extends ProgressTexture {
        public Auto(IGuiTexture emptyBarArea, IGuiTexture filledBarArea) {
            super(emptyBarArea, filledBarArea);
        }

        @Override
        public void updateTick() {
            this.progress = (double)Math.abs(System.currentTimeMillis() % 2000L) / 2000.0;
        }
    }
}

