/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.texture;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.texture.TransformTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@LDLRegister(name="item_stack_texture", group="texture")
public class ItemStackTexture
extends TransformTexture {
    @Configurable(name="ldlib.gui.editor.name.items")
    public final ItemStack[] itemStack;
    private int index = 0;
    private int ticks = 0;
    @Configurable(name="ldlib.gui.editor.name.color")
    private int color = -1;
    private long lastTick;

    public ItemStackTexture() {
        this(Items.f_42410_.m_5456_());
    }

    public ItemStackTexture(ItemStack ... itemStacks) {
        this.itemStack = itemStacks;
    }

    public ItemStackTexture(Item ... items) {
        this.itemStack = new ItemStack[items.length];
        for (int i = 0; i < items.length; ++i) {
            this.itemStack[i] = new ItemStack((ItemLike)items[i]);
        }
    }

    @Override
    public ItemStackTexture setColor(int color) {
        this.color = color;
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateTick() {
        if (Minecraft.m_91087_().f_91073_ != null) {
            long tick = Minecraft.m_91087_().f_91073_.m_46467_();
            if (tick == this.lastTick) {
                return;
            }
            this.lastTick = tick;
        }
        if (this.itemStack.length > 1 && ++this.ticks % 20 == 0 && ++this.index == this.itemStack.length) {
            this.index = 0;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void drawInternal(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        if (this.itemStack.length == 0) {
            return;
        }
        this.updateTick();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_((float)width / 16.0f, (float)height / 16.0f, 1.0f);
        graphics.m_280168_().m_252880_(x * 16.0f / (float)width, y * 16.0f / (float)height, -200.0f);
        DrawerHelper.drawItemStack(graphics, this.itemStack[this.index], 0, 0, this.color, null);
        graphics.m_280168_().m_85849_();
    }
}

