/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.widget;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.parameter.ExposedParameter;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.parameter.ParameterNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.widget.DraggablePanelWidget;
import com.lowdragmc.lowdraglib.gui.graphprocessor.widget.GraphViewWidget;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SelectableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.layout.Layout;
import com.lowdragmc.lowdraglib.utils.TypeAdapter;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.Nullable;

public class ParameterPanelWidget
extends DraggablePanelWidget {
    private final GraphViewWidget graphView;
    private DraggableScrollableWidgetGroup nodeListView;
    private final Map<ExposedParameter<?>, SelectableWidgetGroup> mapping = new HashMap();
    @Nullable
    private ExposedParameter<?> selectedParameter;
    private boolean firstClick;
    private ExposedParameter<?> firstClickParameter;
    private long firstClickTime;

    public ParameterPanelWidget(GraphViewWidget graphView, int x, int y, int width, int height) {
        super("graph_processor.parameter_panel", x, y, width, height);
        this.graphView = graphView;
    }

    @Override
    protected void loadWidgets() {
        super.loadWidgets();
        this.mapping.clear();
        if (this.graphView.getGraph().exposedParameters.isEmpty()) {
            this.setVisible(false);
        }
        this.nodeListView = new DraggableScrollableWidgetGroup(3, 2, this.content.getSizeWidth() - 6, this.content.getSizeHeight() - 4);
        this.nodeListView.setYScrollBarWidth(4).setYBarStyle(null, ColorPattern.T_WHITE.rectTexture().setRadius(2.0f));
        this.nodeListView.setLayout(Layout.VERTICAL_LEFT);
        this.nodeListView.setLayoutPadding(3);
        for (ExposedParameter parameter : this.graphView.getGraph().exposedParameters.values()) {
            SelectableWidgetGroup selectableWidgetGroup = new SelectableWidgetGroup(0, 0, this.nodeListView.getSizeWidth() - 4, 12);
            selectableWidgetGroup.setDraggingProvider(() -> this.createParameterNode(parameter), (n, pos) -> new TextTexture(n.getDisplayName()));
            String displayName = parameter.getDisplayName();
            int nameWidth = Minecraft.m_91087_().f_91062_.m_92895_(displayName);
            selectableWidgetGroup.addWidget(new ImageWidget(0, 0, 5 + nameWidth + 15, 12, ColorPattern.GRAY.rectTexture().setRadius(5.0f)));
            selectableWidgetGroup.addWidget(new ImageWidget(0, 0, selectableWidgetGroup.getSizeWidth() - 2, 12, new TextTexture(TypeAdapter.getTypeDisplayName(parameter.type)).setWidth(selectableWidgetGroup.getSizeWidth()).setType(TextTexture.TextType.RIGHT)));
            if (parameter.getAccessor() == ExposedParameter.ParameterAccessor.Get) {
                selectableWidgetGroup.addWidget(new ImageWidget(5, 1, nameWidth, 12, new TextTexture(displayName).setWidth(nameWidth).setType(TextTexture.TextType.LEFT_ROLL)));
                selectableWidgetGroup.addWidget(new ImageWidget(5 + nameWidth + 2, 2, 8, 8, Icons.RADIOBOX_MARKED.copy().setColor(TypeAdapter.getTypeColor(parameter.type))));
            } else {
                selectableWidgetGroup.addWidget(new ImageWidget(15, 1, nameWidth, 12, new TextTexture(displayName).setWidth(nameWidth).setType(TextTexture.TextType.LEFT_ROLL)));
                selectableWidgetGroup.addWidget(new ImageWidget(3, 2, 8, 8, Icons.RADIOBOX_MARKED.copy().setColor(TypeAdapter.getTypeColor(parameter.type))));
            }
            selectableWidgetGroup.setOnSelected(s -> {
                this.selectedParameter = parameter;
            });
            selectableWidgetGroup.setOnUnSelected(s -> {
                this.selectedParameter = null;
            });
            selectableWidgetGroup.setSelectedTexture(ColorPattern.T_GRAY.rectTexture());
            this.nodeListView.addWidget(selectableWidgetGroup);
            this.mapping.put(parameter, selectableWidgetGroup);
        }
        this.nodeListView.setLayout(Layout.NONE);
        this.nodeListView.setLayoutPadding(0);
        this.nodeListView.computeMax();
        this.content.addWidget(this.nodeListView);
    }

    private ParameterNode createParameterNode(ExposedParameter<?> parameter) {
        ParameterNode node = new ParameterNode();
        node.parameterIdentifier = parameter.identifier;
        node.parameter = parameter;
        return node;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean result = super.mouseClicked(mouseX, mouseY, button);
        if (button == 0 && this.nodeListView.isMouseOverElement(mouseX, mouseY) && this.selectedParameter != null && this.mapping.get(this.selectedParameter).isMouseOverElement(mouseX, mouseY)) {
            if (this.firstClick && this.firstClickParameter.equals(this.selectedParameter) && this.gui.getTickCount() - this.firstClickTime < 10L) {
                this.graphView.addNodeToCenter(this.createParameterNode(this.selectedParameter));
                this.selectedParameter = null;
                return true;
            }
            this.firstClick = true;
            this.firstClickParameter = this.selectedParameter;
            this.firstClickTime = this.gui.getTickCount();
        }
        return result;
    }

    public GraphViewWidget getGraphView() {
        return this.graphView;
    }

    public DraggableScrollableWidgetGroup getNodeListView() {
        return this.nodeListView;
    }

    public Map<ExposedParameter<?>, SelectableWidgetGroup> getMapping() {
        return this.mapping;
    }

    @Nullable
    public ExposedParameter<?> getSelectedParameter() {
        return this.selectedParameter;
    }

    public boolean isFirstClick() {
        return this.firstClick;
    }

    public ExposedParameter<?> getFirstClickParameter() {
        return this.firstClickParameter;
    }

    public long getFirstClickTime() {
        return this.firstClickTime;
    }
}

