/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.utils;

import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import java.text.NumberFormat;
import org.joml.Vector3f;

@LDLRegister(name="print", group="graph_processor.node.utils")
public class PrintNode
extends BaseNode {
    private static NumberFormat numberFormat = NumberFormat.getInstance();
    @InputPort
    public Object in;

    @Override
    public int getMinWidth() {
        return 150;
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        father.addConfigurators(new WrapperConfigurator("", new ImageWidget(0, 0, 140, 15, new TextTexture("").setWidth(140).setType(TextTexture.TextType.ROLL_ALWAYS).setSupplier(() -> this.in == null ? "null" : PrintNode.format(this.in)))).setRemoveTitleBar(true));
    }

    public static String format(Object obj) {
        if (obj instanceof Number) {
            return numberFormat.format(obj);
        }
        if (obj instanceof Vector3f) {
            Vector3f vec = (Vector3f)obj;
            return vec.toString(numberFormat);
        }
        return obj.toString();
    }

    static {
        numberFormat.setMaximumFractionDigits(6);
        numberFormat.setMinimumFractionDigits(0);
    }
}

