/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.data.resource;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.NumberConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.ui.ConfigPanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.ResourcePanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.resource.ResourceContainer;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.widget.HsbColorWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import javax.annotation.Nullable;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;

@LDLRegister(name="ldlib.gui.editor.group.colors", group="resource")
public class ColorsResource
extends Resource<Integer> {
    public static final String RESOURCE_NAME = "ldlib.gui.editor.group.colors";

    @Override
    public void buildDefault() {
        for (ColorPattern color : ColorPattern.values()) {
            this.data.put(color.name(), color.color);
        }
    }

    @Override
    public String name() {
        return RESOURCE_NAME;
    }

    @Override
    public ResourceContainer<Integer, ImageWidget> createContainer(ResourcePanel panel) {
        ResourceContainer<Integer, ImageWidget> container = new ResourceContainer<Integer, ImageWidget>(this, panel);
        container.setWidgetSupplier(k -> new ImageWidget(0, 0, 30, 30, new ColorRectTexture(this.getResourceOrDefault((String)k, -1), (String)k){
            final /* synthetic */ String val$k;
            {
                this.val$k = string;
                super(color);
            }

            @Override
            public void updateTick() {
                this.color = ColorsResource.this.getResourceOrDefault(this.val$k, -1);
            }
        })).setDragging(this::getResource, ColorRectTexture::new).setOnEdit(k -> this.openTextureConfigurator(container, (String)k)).setOnAdd(key -> -1);
        return container;
    }

    private void openTextureConfigurator(ResourceContainer<Integer, ImageWidget> container, final String key) {
        container.getPanel().getEditor().getConfigPanel().openConfigurator(ConfigPanel.Tab.RESOURCE, new IConfigurable(){

            @Override
            public void buildConfigurator(ConfiguratorGroup father) {
                WrapperConfigurator configurator = new WrapperConfigurator("color", wrapper -> new HsbColorWidget(0, 0, 150, 150).setOnChanged(newColor -> {
                    ColorsResource.this.addResource(key, newColor);
                    wrapper.notifyChanges();
                }).setColorSupplier(() -> ColorsResource.this.getResourceOrDefault(key, -1)).setColor(ColorsResource.this.getResourceOrDefault(key, -1)));
                NumberConfigurator r = new NumberConfigurator("R", () -> (int)(ColorUtils.red(ColorsResource.this.getResourceOrDefault(key, -1)) * 255.0f), value -> {
                    int lastColor = ColorsResource.this.getResourceOrDefault(key, -1);
                    ColorsResource.this.addResource(key, ColorUtils.color(ColorUtils.alpha(lastColor), (float)value.intValue() / 255.0f, ColorUtils.green(lastColor), ColorUtils.blue(lastColor)));
                }, -1, true).setRange(0, 255);
                NumberConfigurator g = new NumberConfigurator("G", () -> (int)(ColorUtils.green(ColorsResource.this.getResourceOrDefault(key, -1)) * 255.0f), value -> {
                    int lastColor = ColorsResource.this.getResourceOrDefault(key, -1);
                    ColorsResource.this.addResource(key, ColorUtils.color(ColorUtils.alpha(lastColor), ColorUtils.red(lastColor), (float)value.intValue() / 255.0f, ColorUtils.blue(lastColor)));
                }, -1, true).setRange(0, 255);
                NumberConfigurator b = new NumberConfigurator("B", () -> (int)(ColorUtils.blue(ColorsResource.this.getResourceOrDefault(key, -1)) * 255.0f), value -> {
                    int lastColor = ColorsResource.this.getResourceOrDefault(key, -1);
                    ColorsResource.this.addResource(key, ColorUtils.color(ColorUtils.alpha(lastColor), ColorUtils.red(lastColor), ColorUtils.green(lastColor), (float)value.intValue() / 255.0f));
                }, -1, true).setRange(0, 255);
                NumberConfigurator a = new NumberConfigurator("A", () -> (int)(ColorUtils.alpha(ColorsResource.this.getResourceOrDefault(key, -1)) * 255.0f), value -> {
                    int lastColor = ColorsResource.this.getResourceOrDefault(key, -1);
                    ColorsResource.this.addResource(key, ColorUtils.color((float)value.intValue() / 255.0f, ColorUtils.red(lastColor), ColorUtils.green(lastColor), ColorUtils.blue(lastColor)));
                }, -1, true).setRange(0, 255);
                father.addConfigurators(configurator, r, g, b, a);
            }
        });
    }

    @Override
    @Nullable
    public Tag serialize(Integer value) {
        return IntTag.m_128679_((int)value);
    }

    @Override
    public Integer deserialize(Tag nbt) {
        Integer n;
        if (nbt instanceof IntTag) {
            IntTag intTag = (IntTag)nbt;
            n = intTag.m_7047_();
        } else {
            n = -1;
        }
        return n;
    }
}

