/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.gui;

import com.dannyandson.tinyredstone.TinyRedstone;
import com.dannyandson.tinyredstone.gui.ModWidget;
import com.dannyandson.tinyredstone.items.Blueprint;
import com.dannyandson.tinyredstone.network.BlueprintSync;
import com.dannyandson.tinyredstone.network.ModNetworkHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class BlueprintGUI
extends Screen {
    private static final int WIDTH = 120;
    private static final int HEIGHT = 90;
    private final ResourceLocation GUI = new ResourceLocation("tinyredstone", "textures/gui/transparent.png");
    private final ItemStack blueprint;
    private boolean dialogOpen = false;
    private Button button;

    protected BlueprintGUI(ItemStack blueprint) {
        super((Component)Component.m_237115_((String)"tinyredstone.gui.blueprint.msg"));
        this.blueprint = blueprint;
    }

    protected void m_7856_() {
        int relX = (this.f_96543_ - 120) / 2;
        int relY = (this.f_96544_ - 90) / 2;
        this.m_142416_((GuiEventListener)new ModWidget(relX - 1, relY - 1, 122, 92, -1442840576));
        this.m_142416_((GuiEventListener)new ModWidget(relX, relY, 120, 90, -1997607186));
        this.m_142416_((GuiEventListener)ModWidget.buildButton(relX + 20, relY + 50, 80, 20, (Component)Component.m_237115_((String)"tinyredstone.close"), button -> this.close()));
        this.button = this.blueprint.m_41782_() ? ModWidget.buildButton(relX + 20, relY + 20, 80, 20, (Component)Component.m_237115_((String)"tinyredstone.export"), button -> this.exportToFile()) : ModWidget.buildButton(relX + 20, relY + 20, 80, 20, (Component)Component.m_237115_((String)"tinyredstone.import"), button -> this.importFromFile());
        this.m_142416_((GuiEventListener)this.button);
    }

    private void close() {
        this.f_96541_.m_91152_(null);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.f_96541_.m_91097_().m_174784_(this.GUI);
        int relX = (this.f_96543_ - 120) / 2;
        int relY = (this.f_96544_ - 90) / 2;
        guiGraphics.m_280218_(this.GUI, relX, relY, 0, 0, 120, 90);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public static void open(ItemStack blueprint) {
        Minecraft.m_91087_().m_91152_((Screen)new BlueprintGUI(blueprint));
    }

    public void exportToFile() {
        if (!this.dialogOpen) {
            this.dialogOpen = true;
            this.f_169369_.remove(this.button);
            this.f_169369_.add(new ModWidget((this.f_96543_ - 120) / 2 + 20, (this.f_96544_ - 90) / 2 + 20, 80, 20, -12303292));
            new Thread(() -> {
                MemoryStack stack = MemoryStack.stackPush();
                PointerBuffer filters = stack.mallocPointer(1);
                filters.put(stack.UTF8((CharSequence)"*.json"));
                filters.flip();
                String path = TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)Component.m_237115_((String)"tinyredstone.save_file").getString(), (CharSequence)"blueprint.json", (PointerBuffer)filters, null);
                this.dialogOpen = false;
                stack.pop();
                if (path != null) {
                    try {
                        File file = new File(path);
                        if (file.createNewFile()) {
                            FileWriter writer = new FileWriter(path);
                            writer.write(this.blueprint.m_41783_().toString());
                            writer.close();
                        }
                    }
                    catch (IOException e) {
                        TinyRedstone.LOGGER.error("IOException attempting to save blueprint json to file: " + e.getLocalizedMessage());
                    }
                }
            }).start();
        }
    }

    public void importFromFile() {
        if (!this.dialogOpen) {
            this.dialogOpen = true;
            this.f_169369_.remove(this.button);
            this.f_169369_.add(new ModWidget((this.f_96543_ - 120) / 2 + 20, (this.f_96544_ - 90) / 2 + 20, 80, 20, -12303292));
            new Thread(() -> {
                MemoryStack stack = MemoryStack.stackPush();
                PointerBuffer filters = stack.mallocPointer(2);
                filters.put(stack.UTF8((CharSequence)""));
                filters.put(stack.UTF8((CharSequence)"*.json"));
                filters.flip();
                String path = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)Component.m_237115_((String)"tinyredstone.choose_file").getString(), null, (PointerBuffer)filters, (CharSequence)"JSON File (*.json)", (boolean)false);
                this.dialogOpen = false;
                stack.pop();
                if (path != null) {
                    StringBuilder data = new StringBuilder();
                    try {
                        File file = new File(path);
                        Scanner scanner = new Scanner(file);
                        while (scanner.hasNextLine()) {
                            data.append(scanner.nextLine());
                        }
                        scanner.close();
                    }
                    catch (FileNotFoundException e) {
                        TinyRedstone.LOGGER.error("FileNotFoundException attempting to load blueprint json to file: " + e.getLocalizedMessage());
                    }
                    try {
                        CompoundTag nbt = TagParser.m_129359_((String)data.toString());
                        CompoundTag cleanNBT = Blueprint.cleanUpBlueprintNBT(nbt);
                        if (cleanNBT != null) {
                            this.blueprint.m_41751_(cleanNBT);
                            ModNetworkHandler.sendToServer(new BlueprintSync(cleanNBT));
                        }
                    }
                    catch (CommandSyntaxException e) {
                        TinyRedstone.LOGGER.error("Exception reading JSON from user file: ", (Throwable)e);
                    }
                }
            }).start();
        }
    }
}

