/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.datagen.recipe.combiner;

import com.smashingmods.alchemistry.datagen.recipe.combiner.CombinerRecipeBuilder;
import com.smashingmods.alchemistry.registry.BlockRegistry;
import com.smashingmods.alchemylib.api.item.IngredientStack;
import com.smashingmods.alchemylib.datagen.DatagenHelpers;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;

public class CombinerRecipeProvider {
    private final Consumer<FinishedRecipe> consumer;

    public CombinerRecipeProvider(Consumer<FinishedRecipe> pConsumer) {
        this.consumer = pConsumer;
    }

    public static void register(Consumer<FinishedRecipe> pConsumer) {
        new CombinerRecipeProvider(pConsumer).register();
    }

    private void register() {
        this.combiner((ItemLike)((Block)BlockRegistry.REACTOR_GLASS.get()).m_5456_(), DatagenHelpers.toIngredientStack((String)"silicon_dioxide"), DatagenHelpers.toIngredientStack((String)"lead_oxide"));
        this.combiner((ItemLike)Items.f_42799_, DatagenHelpers.toIngredientStack((String)"oxygen"), DatagenHelpers.toIngredientStack((String)"cellulose", (int)2));
        this.combiner((ItemLike)Items.f_42800_, DatagenHelpers.toIngredientStack((String)"oxygen"), DatagenHelpers.toIngredientStack((String)"cellulose", (int)2));
        this.combiner((ItemLike)Items.f_41826_, DatagenHelpers.toIngredientStack((String)"oxygen"), DatagenHelpers.toIngredientStack((String)"cellulose", (int)2));
        this.combiner((ItemLike)Items.f_41827_, DatagenHelpers.toIngredientStack((String)"oxygen"), DatagenHelpers.toIngredientStack((String)"cellulose", (int)2));
        this.combiner((ItemLike)Items.f_41828_, DatagenHelpers.toIngredientStack((String)"oxygen"), DatagenHelpers.toIngredientStack((String)"cellulose", (int)2));
        this.combiner((ItemLike)Items.f_42801_, DatagenHelpers.toIngredientStack((String)"oxygen"), DatagenHelpers.toIngredientStack((String)"cellulose", (int)2));
        this.combiner((ItemLike)Items.f_42619_, DatagenHelpers.toIngredientStack((String)"cellulose"), DatagenHelpers.toIngredientStack((String)"beta_carotene"));
        this.combiner((ItemLike)Items.f_42620_, DatagenHelpers.toIngredientStack((String)"starch"), DatagenHelpers.toIngredientStack((String)"potassium", (int)4));
        this.combiner((ItemLike)Items.f_42404_, DatagenHelpers.toIngredientStack((String)"triglyceride"), DatagenHelpers.toIngredientStack((String)"sucrose"));
        this.combiner((ItemLike)Items.f_42577_, DatagenHelpers.toIngredientStack((String)"triglyceride"), DatagenHelpers.toIngredientStack((String)"sucrose"));
        this.combiner((ItemLike)Items.f_42578_, DatagenHelpers.toIngredientStack((String)"triglyceride"), DatagenHelpers.toIngredientStack((String)"sucrose"));
        this.combiner((ItemLike)Items.f_42733_, DatagenHelpers.toIngredientStack((String)"triglyceride"), DatagenHelpers.toIngredientStack((String)"sucrose"), DatagenHelpers.toIngredientStack((String)"iron_oxide"));
        this.combiner((ItemLike)Items.f_42732_, DatagenHelpers.toIngredientStack((String)"sucrose"), DatagenHelpers.toIngredientStack((String)"iron_oxide"));
        this.combiner((ItemLike)Items.f_42686_, DatagenHelpers.toIngredientStack((String)"lutetium", (int)64), DatagenHelpers.toIngredientStack((String)"titanium", (int)64), DatagenHelpers.toIngredientStack((String)"dysprosium", (int)64), DatagenHelpers.toIngredientStack((String)"mendelevium", (int)64));
        this.combiner((ItemLike)Items.f_41870_, DatagenHelpers.toIngredientStack((String)"keratin", (int)2), DatagenHelpers.toIngredientStack((String)"triglyceride", (int)1));
        this.combiner((ItemLike)Items.f_42616_, DatagenHelpers.toIngredientStack((String)"beryl", (int)8), DatagenHelpers.toIngredientStack((String)"chromium", (int)8), DatagenHelpers.toIngredientStack((String)"vanadium", (int)4));
        this.combiner((ItemLike)Items.f_42534_, DatagenHelpers.toIngredientStack((String)"sodium", (int)6), DatagenHelpers.toIngredientStack((String)"mullite", (int)3), DatagenHelpers.toIngredientStack((String)"calcium_sulfide", (int)2), DatagenHelpers.toIngredientStack((String)"silicon", (int)3));
        this.combiner((ItemLike)Items.f_42329_, DatagenHelpers.toIngredientStack((String)"water"), DatagenHelpers.toIngredientStack((String)"cellulose"), DatagenHelpers.toIngredientStack((String)"kaolinite"));
        this.combiner((ItemLike)Items.f_151034_, DatagenHelpers.toIngredientStack((String)"silicon_dioxide", (int)1), DatagenHelpers.toIngredientStack((String)"aluminum", (int)1), DatagenHelpers.toIngredientStack((String)"iron", (int)1));
        this.combiner((ItemLike)Items.f_42051_, DatagenHelpers.toIngredientStack((String)"silicon_dioxide", (int)1), DatagenHelpers.toIngredientStack((String)"aluminum_oxide", (int)1));
        this.combiner((ItemLike)Items.f_42276_, DatagenHelpers.toIngredientStack((String)"water"), DatagenHelpers.toIngredientStack((String)"cellulose"), DatagenHelpers.toIngredientStack((String)"kaolinite"));
        this.combiner((ItemLike)Items.f_42093_, DatagenHelpers.toIngredientStack((String)"water"), DatagenHelpers.toIngredientStack((String)"chitin"), DatagenHelpers.toIngredientStack((String)"kaolinite"), DatagenHelpers.toIngredientStack((String)"silicon_dioxide"));
        this.combiner((ItemLike)Items.f_42447_, DatagenHelpers.toIngredientStack((String)"water", (int)16), new ItemStack((ItemLike)Items.f_42446_));
        this.combiner((ItemLike)Items.f_42455_, DatagenHelpers.toIngredientStack((String)"calcium", (int)4), DatagenHelpers.toIngredientStack((String)"protein", (int)2), DatagenHelpers.toIngredientStack((String)"water", (int)16), new ItemStack((ItemLike)Items.f_42446_));
        this.combiner((ItemLike)Items.f_42153_, DatagenHelpers.toIngredientStack((String)"iron_oxide", (int)9), DatagenHelpers.toIngredientStack((String)"strontium_carbonate", (int)9));
        this.combiner((ItemLike)Items.f_42451_, DatagenHelpers.toIngredientStack((String)"iron_oxide"), DatagenHelpers.toIngredientStack((String)"strontium_carbonate"));
    }

    private void combiner(ItemLike pOutput, Object ... pInput) {
        this.combiner(pOutput, null, pInput);
    }

    private void combiner(ItemLike pOutput, @Nullable ICondition pCondition, Object ... pInput) {
        ArrayList<IngredientStack> ingredientStackList = new ArrayList<IngredientStack>();
        for (Object obj : pInput) {
            if (obj instanceof ItemLike) {
                ItemLike itemLike = (ItemLike)obj;
                ingredientStackList.add(new IngredientStack(itemLike));
                continue;
            }
            if (obj instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)obj;
                ingredientStackList.add(new IngredientStack(itemStack));
                continue;
            }
            if (obj instanceof IngredientStack) {
                IngredientStack ingredientStack = (IngredientStack)obj;
                ingredientStackList.add(ingredientStack);
                continue;
            }
            if (!(obj instanceof String)) continue;
            String itemTag = (String)obj;
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(itemTag));
            ingredientStackList.add(new IngredientStack(Ingredient.m_204132_((TagKey)tagKey)));
        }
        if (pCondition == null) {
            this.combiner(new ItemStack(pOutput), ingredientStackList);
        } else {
            this.combiner(new ItemStack(pOutput), ingredientStackList, pCondition);
        }
    }

    private void combiner(ItemLike pOutput, List<Object> pInput, @Nullable ICondition pCondition) {
        ArrayList<IngredientStack> ingredientStackList = new ArrayList<IngredientStack>();
        for (Object obj : pInput) {
            if (obj instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)obj;
                ingredientStackList.add(new IngredientStack(itemStack));
                continue;
            }
            if (!(obj instanceof String)) continue;
            String itemTag = (String)obj;
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(itemTag));
            ingredientStackList.add(new IngredientStack(Ingredient.m_204132_((TagKey)tagKey)));
        }
        if (pCondition == null) {
            this.combiner(new ItemStack(pOutput), ingredientStackList);
        } else {
            this.combiner(new ItemStack(pOutput), ingredientStackList, pCondition);
        }
    }

    private void combiner(ItemStack pOutput, List<IngredientStack> pInput, ICondition pCondition) {
        ResourceLocation recipeId = ForgeRegistries.ITEMS.getKey((Object)pOutput.m_41720_());
        ConditionalRecipe.builder().addCondition(pCondition).addRecipe(arg_0 -> ((RecipeBuilder)CombinerRecipeBuilder.createRecipe(pOutput, pInput, Objects.requireNonNull(recipeId)).m_126145_(String.format("%s:combiner", "alchemistry")).m_126132_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)DatagenHelpers.getLocation((ItemStack)pOutput, (String)"combiner", (String)"alchemistry")))).m_176498_(arg_0)).build(this.consumer, new ResourceLocation("alchemistry", String.format("combiner/%s", recipeId.m_135815_())));
    }

    private void combiner(ItemStack pOutput, List<IngredientStack> pInput) {
        CombinerRecipeBuilder.createRecipe(pOutput, pInput, Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)pOutput.m_41720_()))).m_126145_(String.format("%s:combiner", "alchemistry")).m_126132_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)DatagenHelpers.getLocation((ItemStack)pOutput, (String)"combiner", (String)"alchemistry"))).m_176498_(this.consumer);
    }
}

