/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.item.crafting;

import com.google.gson.JsonObject;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(modid="aquaculture", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConditionFactory {
    @SubscribeEvent
    public static void registerConditions(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.RECIPE_SERIALIZERS)) {
            CraftingHelper.register((IConditionSerializer)NeptuniumItems.Serializer.INSTANCE);
            CraftingHelper.register((IConditionSerializer)NeptuniumArmor.Serializer.INSTANCE);
        }
    }

    public static class NeptuniumItems
    implements ICondition {
        private static final NeptuniumItems INSTANCE = new NeptuniumItems();
        private static final ResourceLocation NAME = new ResourceLocation("aquaculture", "neptunium_items_enabled");

        public ResourceLocation getID() {
            return NAME;
        }

        public boolean test(ICondition.IContext context) {
            return (Boolean)AquaConfig.NEPTUNIUM_OPTIONS.enableNeptuniumItems.get();
        }

        public static class Serializer
        implements IConditionSerializer<NeptuniumItems> {
            private static final Serializer INSTANCE = new Serializer();

            public void write(JsonObject json, NeptuniumItems value) {
                json.addProperty("value", Boolean.valueOf(value.test(ICondition.IContext.EMPTY)));
            }

            public NeptuniumItems read(JsonObject json) {
                return INSTANCE;
            }

            public ResourceLocation getID() {
                return NAME;
            }
        }
    }

    public static class NeptuniumArmor
    implements ICondition {
        private static final NeptuniumArmor INSTANCE = new NeptuniumArmor();
        private static final ResourceLocation NAME = new ResourceLocation("aquaculture", "neptunium_armor_enabled");

        public ResourceLocation getID() {
            return NAME;
        }

        public boolean test(ICondition.IContext context) {
            return (Boolean)AquaConfig.NEPTUNIUM_OPTIONS.enableNeptuniumArmor.get();
        }

        public static class Serializer
        implements IConditionSerializer<NeptuniumArmor> {
            private static final Serializer INSTANCE = new Serializer();

            public void write(JsonObject json, NeptuniumArmor value) {
                json.addProperty("value", Boolean.valueOf(value.test(ICondition.IContext.EMPTY)));
            }

            public NeptuniumArmor read(JsonObject json) {
                return INSTANCE;
            }

            public ResourceLocation getID() {
                return NAME;
            }
        }
    }
}

