/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.twilightdelight.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;

public class FieryCuttingRecipe
extends CuttingBoardRecipe {
    private final Level level;
    private final Vec3 pos;

    public static Optional<CuttingBoardRecipe> transform(Level level, Vec3 pos, Optional<CuttingBoardRecipe> optional) {
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new FieryCuttingRecipe(level, pos, optional.get()));
    }

    private static Ingredient extract(NonNullList<Ingredient> ingredients) {
        return ingredients.size() == 0 ? Ingredient.f_43901_ : (Ingredient)ingredients.get(0);
    }

    private FieryCuttingRecipe(Level level, Vec3 pos, CuttingBoardRecipe recipe) {
        super(recipe.m_6423_(), recipe.m_6076_(), FieryCuttingRecipe.extract((NonNullList<Ingredient>)recipe.m_7527_()), recipe.getTool(), recipe.getRollableResults(), recipe.getSoundEventID());
        this.level = level;
        this.pos = pos;
    }

    public List<ItemStack> rollResults(RandomSource rand, int fortuneLevel) {
        List prev = super.rollResults(rand, fortuneLevel);
        ArrayList<ItemStack> ans = new ArrayList<ItemStack>();
        int particle = 0;
        for (ItemStack stack : prev) {
            SimpleContainer cont = new SimpleContainer(new ItemStack[]{stack});
            Optional opt = this.level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)cont, this.level);
            if (opt.isEmpty()) {
                ans.add(stack);
                continue;
            }
            ItemStack result = ((SmeltingRecipe)opt.get()).m_5874_((Container)cont, this.level.m_9598_());
            result.m_41764_(stack.m_41613_());
            ans.add(result);
            particle += stack.m_41613_();
        }
        if (particle > 0) {
            this.spawnParticlesAndPlaySound(particle);
        }
        return ans;
    }

    private void spawnParticlesAndPlaySound(int particle) {
        this.spawnCuttingParticles(particle);
        this.playSound(SoundEvents.f_11937_, 1.0f, 1.0f);
    }

    private void playSound(SoundEvent sound, float volume, float pitch) {
        if (this.level != null) {
            this.level.m_6263_(null, this.pos.m_7096_(), this.pos.m_7098_(), this.pos.m_7094_(), sound, SoundSource.BLOCKS, volume, pitch);
        }
    }

    private void spawnCuttingParticles(int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 vec3d = new Vec3(((double)this.level.f_46441_.m_188501_() - 0.5) * 0.1, (double)this.level.f_46441_.m_188501_() * 0.05, ((double)this.level.f_46441_.m_188501_() - 0.5) * 0.1);
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                sl.m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.pos.m_7096_(), this.pos.m_7098_(), this.pos.m_7094_(), 1, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 0.0);
                continue;
            }
            this.level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.pos.m_7096_(), this.pos.m_7098_(), this.pos.m_7094_(), vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
        }
    }
}

