/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.terminal;

import appeng.api.features.Locatables;
import appeng.api.implementations.blockentities.IWirelessAccessPoint;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.networking.IGrid;
import appeng.api.networking.security.IActionHost;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.core.AEConfig;
import appeng.items.tools.powered.WirelessTerminalItem;
import appeng.menu.locator.MenuLocators;
import appeng.util.Platform;
import appeng.util.inv.AppEngInternalInventory;
import de.mari_023.ae2wtlib.AE2wtlib;
import de.mari_023.ae2wtlib.terminal.GridResult;
import de.mari_023.ae2wtlib.terminal.IUniversalWirelessTerminalItem;
import de.mari_023.ae2wtlib.wut.WUTHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public abstract class ItemWT
extends WirelessTerminalItem
implements IUniversalWirelessTerminalItem {
    public ItemWT() {
        super(AEConfig.instance().getWirelessTerminalBattery(), new Item.Properties().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level w, Player player, InteractionHand hand) {
        ItemStack is = player.m_21120_(hand);
        if (this.checkUniversalPreconditions(is, player)) {
            this.open(player, is, MenuLocators.forHand((Player)player, (InteractionHand)hand), false);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)is);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)is);
    }

    @Nullable
    public ItemMenuHost getMenuHost(Player player, int slot, ItemStack stack, @Nullable BlockPos pos) {
        return WUTHandler.wirelessTerminals.get(WUTHandler.getCurrentTerminal(stack)).wTMenuHostFactory().create(player, slot, stack, (p, subMenu) -> this.tryOpen(player, MenuLocators.forInventorySlot((int)slot), stack, true));
    }

    @Nullable
    public static IActionHost findQuantumBridge(Level level, long frequency) {
        IActionHost quantumBridge = (IActionHost)Locatables.quantumNetworkBridges().get(level, frequency);
        if (quantumBridge == null) {
            quantumBridge = (IActionHost)Locatables.quantumNetworkBridges().get(level, -frequency);
        }
        return quantumBridge;
    }

    public static long getQEFrequency(ItemStack stack, @Nullable AppEngInternalInventory inventory) {
        CompoundTag c;
        ItemStack is;
        if (inventory == null) {
            inventory = new AppEngInternalInventory(null, 1);
            inventory.readFromNBT(stack.m_41784_(), "singularity");
        }
        if (!(is = inventory.getStackInSlot(0)).m_41619_() && (c = is.m_41783_()) != null) {
            return c.m_128454_("freq");
        }
        return 0L;
    }

    private static boolean hasQuantumUpgrade(ItemStack stack, @Nullable IUpgradeInventory inventory) {
        if (inventory == null) {
            inventory = UpgradeInventories.forItem((ItemStack)stack, (int)WUTHandler.getUpgradeCardCount());
        }
        return inventory.isInstalled((ItemLike)AE2wtlib.QUANTUM_BRIDGE_CARD);
    }

    @Nullable
    public static IActionHost getQuantumBridge(ItemStack itemStack, Level level, @Nullable AppEngInternalInventory singularityInventory, @Nullable IUpgradeInventory upgradeInventory) {
        if (level.m_5776_()) {
            return null;
        }
        if (!ItemWT.hasQuantumUpgrade(itemStack, upgradeInventory)) {
            return null;
        }
        long frequency = ItemWT.getQEFrequency(itemStack, singularityInventory);
        if (frequency == 0L) {
            return null;
        }
        return ItemWT.findQuantumBridge(level, frequency);
    }

    private GridResult getLinkedGrid(ItemStack item, Level level) {
        if (!(level instanceof ServerLevel)) {
            return GridResult.invalid(GridResult.GridStatus.NotServer);
        }
        ServerLevel serverLevel = (ServerLevel)level;
        GridResult grid = this.getAccessPointLinkedGrid(item, serverLevel);
        if (grid.status().isValid()) {
            return grid;
        }
        IActionHost quantumBridge = ItemWT.getQuantumBridge(item, level, null, null);
        if (quantumBridge == null) {
            return grid;
        }
        if (quantumBridge.getActionableNode() == null) {
            return GridResult.invalid(GridResult.GridStatus.NotFound);
        }
        if (!quantumBridge.getActionableNode().isPowered()) {
            return GridResult.invalid(GridResult.GridStatus.NotPowered);
        }
        return GridResult.valid(quantumBridge.getActionableNode().getGrid());
    }

    private GridResult getAccessPointLinkedGrid(ItemStack item, ServerLevel level) {
        GlobalPos linkedPos = this.getLinkedPosition(item);
        if (linkedPos == null) {
            return GridResult.invalid(GridResult.GridStatus.NotLinked);
        }
        ServerLevel linkedLevel = level.m_7654_().m_129880_(linkedPos.m_122640_());
        if (linkedLevel == null) {
            return GridResult.invalid(GridResult.GridStatus.NotFound);
        }
        BlockEntity be = Platform.getTickingBlockEntity((Level)linkedLevel, (BlockPos)linkedPos.m_122646_());
        if (!(be instanceof IWirelessAccessPoint)) {
            return GridResult.invalid(GridResult.GridStatus.NotFound);
        }
        IWirelessAccessPoint accessPoint = (IWirelessAccessPoint)be;
        IGrid grid = accessPoint.getGrid();
        if (grid == null) {
            return GridResult.invalid(GridResult.GridStatus.NotFound);
        }
        if (!grid.getEnergyService().isNetworkPowered()) {
            return GridResult.invalid(GridResult.GridStatus.NotPowered);
        }
        return GridResult.valid(grid);
    }

    @Override
    @Nullable
    public IGrid getLinkedGrid(ItemStack item, Level level, @Nullable Player sendMessagesTo) {
        GridResult grid = this.getLinkedGrid(item, level);
        if (grid.status().getError() != null && sendMessagesTo != null && !level.m_5776_()) {
            sendMessagesTo.m_5661_(grid.status().getError(), true);
        }
        return grid.grid();
    }

    @Deprecated
    public static ItemStack getSavedSlot(ItemStack hostItem, String slot) {
        if (!(hostItem.m_41720_() instanceof IUniversalWirelessTerminalItem)) {
            return ItemStack.f_41583_;
        }
        return ItemStack.m_41712_((CompoundTag)hostItem.m_41784_().m_128469_(slot));
    }

    @Deprecated
    public static void setSavedSlot(ItemStack hostItem, ItemStack savedItem, String slot) {
        if (!(hostItem.m_41720_() instanceof IUniversalWirelessTerminalItem)) {
            return;
        }
        CompoundTag wctTag = hostItem.m_41784_();
        if (savedItem.m_41619_()) {
            wctTag.m_128473_(slot);
        } else {
            wctTag.m_128365_(slot, (Tag)savedItem.m_41739_(new CompoundTag()));
        }
    }

    public static boolean getBoolean(ItemStack hostItem, String key) {
        if (!(hostItem.m_41720_() instanceof IUniversalWirelessTerminalItem)) {
            return false;
        }
        return hostItem.m_41784_().m_128471_(key);
    }

    public static void setBoolean(ItemStack hostItem, boolean b, String key) {
        if (!(hostItem.m_41720_() instanceof IUniversalWirelessTerminalItem)) {
            return;
        }
        CompoundTag wctTag = hostItem.m_41784_();
        wctTag.m_128379_(key, b);
    }
}

