/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import io.netty.buffer.Unpooled;
import java.util.List;
import javax.annotation.Nonnull;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.blocks.BlockSaw;
import mob_grinding_utils.fakeplayer.MGUFakePlayer;
import mob_grinding_utils.inventory.server.ContainerSaw;
import mob_grinding_utils.items.ItemSawUpgrade;
import mob_grinding_utils.tile.TileEntityInventoryHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class TileEntitySaw
extends TileEntityInventoryHelper
implements MenuProvider {
    public boolean active;
    public int animationTicks;
    public int prevAnimationTicks;
    private static final int[] SLOTS = new int[]{0, 1, 2, 3, 4, 5};

    public TileEntitySaw(BlockPos pos, BlockState state) {
        super(ModBlocks.SAW.getTileEntityType(), 6, pos, state);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        if (t instanceof TileEntitySaw) {
            TileEntitySaw tile = (TileEntitySaw)t;
            if (tile.active) {
                tile.prevAnimationTicks = tile.animationTicks;
                if (tile.animationTicks < 360) {
                    tile.animationTicks += 18;
                }
                if (tile.animationTicks >= 360) {
                    tile.animationTicks -= 360;
                    tile.prevAnimationTicks -= 360;
                }
            } else {
                tile.animationTicks = 0;
                tile.prevAnimationTicks = 0;
            }
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        if (t instanceof TileEntitySaw) {
            TileEntitySaw tile = (TileEntitySaw)t;
            if (level.m_46467_() % 10L == 0L && level.m_8055_(blockPos).m_60734_() instanceof BlockSaw && ((Boolean)level.m_8055_(blockPos).m_61143_((Property)BlockSaw.POWERED)).booleanValue()) {
                tile.activateBlock();
            }
        }
    }

    public void setActive(boolean isActive) {
        this.active = isActive;
        this.m_58904_().m_7260_(this.f_58858_, this.m_58904_().m_8055_(this.f_58858_), this.m_58904_().m_8055_(this.f_58858_), 3);
    }

    protected Entity activateBlock() {
        List list = this.m_58904_().m_45976_(LivingEntity.class, new AABB((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (double)this.f_58858_.m_123341_() + 1.0, (double)this.f_58858_.m_123342_() + 1.0, (double)this.f_58858_.m_123343_() + 1.0).m_82377_(0.0625, 0.0625, 0.0625));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity == null || !(entity instanceof LivingEntity)) continue;
            MGUFakePlayer fakePlayer = (MGUFakePlayer)((Object)MGUFakePlayer.get((ServerLevel)this.m_58904_(), this.f_58858_.m_123341_(), -100.0, this.f_58858_.m_123343_()).get());
            ItemStack tempSword = new ItemStack((ItemLike)ModItems.NULL_SWORD.get(), 1);
            if (!tempSword.m_41782_()) {
                tempSword.m_41751_(new CompoundTag());
            }
            if (this.hasSharpnessUpgrade()) {
                tempSword.m_41663_(Enchantments.f_44977_, ((ItemStack)this.getItems().get(0)).m_41613_() * 10);
            }
            if (this.hasLootingUpgrade()) {
                tempSword.m_41663_(Enchantments.f_44982_, ((ItemStack)this.getItems().get(1)).m_41613_());
            }
            if (this.hasFlameUpgrade()) {
                tempSword.m_41663_(Enchantments.f_44981_, ((ItemStack)this.getItems().get(2)).m_41613_());
            }
            if (this.hasSmiteUpgrade()) {
                tempSword.m_41663_(Enchantments.f_44978_, ((ItemStack)this.getItems().get(3)).m_41613_() * 10);
            }
            if (this.hasArthropodUpgrade()) {
                tempSword.m_41663_(Enchantments.f_44979_, ((ItemStack)this.getItems().get(4)).m_41613_() * 10);
            }
            if (this.hasBeheadingUpgrade()) {
                tempSword.m_41783_().m_128405_("beheadingValue", ((ItemStack)this.getItems().get(5)).m_41613_());
            }
            fakePlayer.m_21008_(InteractionHand.MAIN_HAND, tempSword);
            fakePlayer.m_5706_(entity);
            fakePlayer.m_36334_();
            fakePlayer.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        return null;
    }

    private boolean hasSharpnessUpgrade() {
        return !((ItemStack)this.getItems().get(0)).m_41619_() && ((ItemStack)this.getItems().get(0)).m_41720_() == ModItems.SAW_UPGRADE_SHARPNESS.get();
    }

    private boolean hasLootingUpgrade() {
        return !((ItemStack)this.getItems().get(1)).m_41619_() && ((ItemStack)this.getItems().get(1)).m_41720_() == ModItems.SAW_UPGRADE_LOOTING.get();
    }

    private boolean hasFlameUpgrade() {
        return !((ItemStack)this.getItems().get(2)).m_41619_() && ((ItemStack)this.getItems().get(2)).m_41720_() == ModItems.SAW_UPGRADE_FIRE.get();
    }

    private boolean hasSmiteUpgrade() {
        return !((ItemStack)this.getItems().get(3)).m_41619_() && ((ItemStack)this.getItems().get(3)).m_41720_() == ModItems.SAW_UPGRADE_SMITE.get();
    }

    private boolean hasArthropodUpgrade() {
        return !((ItemStack)this.getItems().get(4)).m_41619_() && ((ItemStack)this.getItems().get(4)).m_41720_() == ModItems.SAW_UPGRADE_ARTHROPOD.get();
    }

    private boolean hasBeheadingUpgrade() {
        return !((ItemStack)this.getItems().get(5)).m_41619_() && ((ItemStack)this.getItems().get(5)).m_41720_() == ModItems.SAW_UPGRADE_BEHEADING.get();
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.active = nbt.m_128471_("active");
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("active", this.active);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(net, packet);
        this.m_142466_(packet.m_131708_());
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        }
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        if (stack.m_41720_() instanceof ItemSawUpgrade) {
            switch (slot) {
                case 0: {
                    if (stack.m_41720_() == ModItems.SAW_UPGRADE_SHARPNESS.get()) {
                        return true;
                    }
                }
                case 1: {
                    if (stack.m_41720_() == ModItems.SAW_UPGRADE_LOOTING.get()) {
                        return true;
                    }
                }
                case 2: {
                    if (stack.m_41720_() == ModItems.SAW_UPGRADE_FIRE.get()) {
                        return true;
                    }
                }
                case 3: {
                    if (stack.m_41720_() == ModItems.SAW_UPGRADE_SMITE.get()) {
                        return true;
                    }
                }
                case 4: {
                    if (stack.m_41720_() == ModItems.SAW_UPGRADE_ARTHROPOD.get()) {
                        return true;
                    }
                }
                case 5: {
                    if (stack.m_41720_() != ModItems.SAW_UPGRADE_BEHEADING.get()) break;
                    return true;
                }
            }
        }
        return false;
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.getItems(), (int)index);
    }

    @Override
    public int m_6893_() {
        return 10;
    }

    public int[] m_7071_(Direction side) {
        return SLOTS;
    }

    public boolean m_7155_(int slot, ItemStack stack, Direction direction) {
        return this.m_7013_(slot, stack);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public AbstractContainerMenu m_7208_(int windowID, Inventory playerInventory, Player player) {
        return new ContainerSaw(windowID, playerInventory, new FriendlyByteBuf(Unpooled.buffer()).m_130064_(this.f_58858_));
    }

    @Nonnull
    public Component m_5446_() {
        return Component.m_237115_((String)"block.mob_grinding_utils.saw");
    }
}

