/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import com.mojang.authlib.GameProfile;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IGUITextFieldSensitive;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.SecurityStationBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.inventory.SentryTurretMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.minigun.AbstractGunAmmoItem;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.EntityDistanceComparator;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.StringFilterEntitySelector;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class SentryTurretBlockEntity
extends AbstractTickingBlockEntity
implements IRedstoneControl<SentryTurretBlockEntity>,
IGUITextFieldSensitive,
MenuProvider {
    private static final int INVENTORY_SIZE = 4;
    public static final String NBT_ENTITY_FILTER = "entityFilter";
    private final ItemStackHandler inventory = new TurretItemStackHandler(this);
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.inventory);
    @GuiSynced
    private String entityFilter = "@mob";
    @GuiSynced
    private final RedstoneController<SentryTurretBlockEntity> rsController = new RedstoneController<SentryTurretBlockEntity>(this);
    @DescSynced
    private double range;
    @DescSynced
    private boolean activated;
    @DescSynced
    private ItemStack minigunColorStack = ItemStack.f_41583_;
    private Minigun minigun;
    @DescSynced
    private int targetEntityId = -1;
    @DescSynced
    private boolean sweeping;
    private final SentryTurretEntitySelector entitySelector = new SentryTurretEntitySelector();
    private double rangeSq;
    private Vec3 tileVec;
    @DescSynced
    private float idleYaw;

    public SentryTurretBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<?>)((BlockEntityType)ModBlockEntities.SENTRY_TURRET.get()), pos, state, 4);
    }

    @Override
    public void tickServer() {
        LivingEntity target;
        super.tickServer();
        if (this.getMinigun().getAttackTarget() == null && this.rsController.shouldRun()) {
            this.getMinigun().setSweeping(true);
            if ((this.nonNullLevel().m_46467_() & 0xFL) == 0L) {
                List entities = this.nonNullLevel().m_6443_(LivingEntity.class, this.getTargetingBoundingBox(), (Predicate)((Object)this.entitySelector));
                if (entities.size() > 0) {
                    entities.sort(new EntityDistanceComparator(this.m_58899_()));
                    this.getMinigun().setAttackTarget((LivingEntity)entities.get(0));
                    this.targetEntityId = ((LivingEntity)entities.get(0)).m_19879_();
                } else if (this.targetEntityId > 0) {
                    this.getMinigun().setReturning(true);
                    this.targetEntityId = -1;
                }
            }
        } else {
            this.getMinigun().setSweeping(false);
        }
        if ((target = this.getMinigun().getAttackTarget()) != null) {
            if (this.rsController.shouldRun() && this.entitySelector.test((Entity)target)) {
                if ((this.nonNullLevel().m_46467_() & 7L) == 0L) {
                    this.getFakePlayer().m_6034_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5);
                    boolean usedUpAmmo = this.getMinigun().tryFireMinigun((Entity)target);
                    if (usedUpAmmo) {
                        this.clearEmptyAmmo();
                    }
                }
            } else {
                this.getMinigun().setAttackTarget(null);
                this.getMinigun().minigunYaw = this.idleYaw;
                this.targetEntityId = -1;
            }
        }
    }

    @Override
    public void tickCommonPost() {
        super.tickCommonPost();
        this.getMinigun().setIdleYaw(this.idleYaw);
        this.getMinigun().tick((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5);
    }

    private void clearEmptyAmmo() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (!(stack.m_41720_() instanceof AbstractGunAmmoItem) || stack.m_41773_() < stack.m_41776_()) continue;
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    @Override
    public void serializeExtraItemData(CompoundTag blockEntityTag, boolean preserveState) {
        blockEntityTag.m_128359_(NBT_ENTITY_FILTER, this.getText(0));
    }

    private boolean canTurretSeeEntity(Entity entity) {
        Vec3 entityVec = new Vec3(entity.m_20185_() + (double)(entity.m_20205_() / 2.0f), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_() + (double)(entity.m_20205_() / 2.0f));
        ClipContext ctx = new ClipContext(entityVec, this.tileVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity);
        BlockHitResult trace = this.nonNullLevel().m_45547_(ctx);
        return trace.m_82425_().equals((Object)this.m_58899_());
    }

    private AABB getTargetingBoundingBox() {
        return new AABB(this.m_58899_(), this.m_58899_()).m_82400_(this.range);
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82400_(1.0);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.tileVec = new Vec3((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5);
        this.updateAmmo();
        this.onFilterChanged(this.entityFilter);
    }

    @Override
    public void onDescUpdate() {
        super.onDescUpdate();
        Entity entity = this.nonNullLevel().m_6815_(this.targetEntityId);
        if (entity instanceof LivingEntity) {
            this.getMinigun().setAttackTarget((LivingEntity)entity);
        } else {
            this.getMinigun().setAttackTarget(null);
            this.getMinigun().setReturning(true);
        }
    }

    public Minigun getMinigun() {
        if (this.minigun == null) {
            this.minigun = new MinigunSentryTurret(this.nonNullLevel().f_46443_ ? null : this.getFakePlayer());
            this.minigun.setWorld(this.m_58904_());
        }
        return this.minigun;
    }

    private Player getFakePlayer() {
        return FakePlayerFactory.get((ServerLevel)((ServerLevel)this.m_58904_()), (GameProfile)new GameProfile(null, "Sentry Turret"));
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Items", (Tag)this.inventory.serializeNBT());
        tag.m_128359_(NBT_ENTITY_FILTER, this.entityFilter);
        tag.m_128350_("idleYaw", this.idleYaw);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("Items"));
        this.idleYaw = tag.m_128457_("idleYaw");
        this.setText(0, tag.m_128461_(NBT_ENTITY_FILTER));
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    public RedstoneController<SentryTurretBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        this.rsController.parseRedstoneMode(tag);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new SentryTurretMenu(i, playerInventory, this.m_58899_());
    }

    public void setIdleYaw(float idleYaw) {
        this.idleYaw = Minigun.clampYaw(idleYaw);
    }

    private void updateAmmo() {
        ItemStack ammo = ItemStack.f_41583_;
        for (int i = 0; i < this.inventory.getSlots() && (ammo = this.inventory.getStackInSlot(i)).m_41619_(); ++i) {
        }
        this.getMinigun().setAmmoStack(ammo);
        this.recalculateRange();
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap(Direction side) {
        return this.invCap;
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        if (this.m_58904_() != null) {
            this.recalculateRange();
        }
        this.getMinigun().setInfiniteAmmo(this.getUpgrades(ModUpgrades.CREATIVE.get()) > 0);
    }

    private void recalculateRange() {
        this.range = 16 + Math.min(16, this.getUpgrades(ModUpgrades.RANGE.get()));
        ItemStack ammoStack = this.getMinigun().getAmmoStack();
        Item item = ammoStack.m_41720_();
        if (item instanceof AbstractGunAmmoItem) {
            AbstractGunAmmoItem ammo = (AbstractGunAmmoItem)item;
            this.range *= (double)ammo.getRangeMultiplier(ammoStack);
        }
        this.rangeSq = this.range * this.range;
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.entityFilter = text;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.onFilterChanged(text);
            if (this.minigun != null) {
                this.minigun.setAttackTarget(null);
            }
        }
    }

    private void onFilterChanged(String text) {
        this.entitySelector.setFilter(text);
        this.m_6596_();
    }

    @Override
    public String getText(int textFieldID) {
        return this.entityFilter;
    }

    private class TurretItemStackHandler
    extends BaseItemStackHandler {
        TurretItemStackHandler(BlockEntity te) {
            super(te, 4);
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            SentryTurretBlockEntity.this.updateAmmo();
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.m_41619_() || itemStack.m_41720_() instanceof AbstractGunAmmoItem;
        }
    }

    private class SentryTurretEntitySelector
    extends StringFilterEntitySelector {
        private SentryTurretEntitySelector() {
        }

        public boolean test(Entity entity) {
            Player player;
            if (entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_() || this.isExcludedBySecurityStations(player))) {
                return false;
            }
            return super.test((Object)entity) && this.inRange(entity) && SentryTurretBlockEntity.this.canTurretSeeEntity(entity);
        }

        private boolean inRange(Entity entity) {
            return PneumaticCraftUtils.distBetweenSq((Vec3i)new BlockPos(SentryTurretBlockEntity.this.m_58899_().m_123341_(), SentryTurretBlockEntity.this.m_58899_().m_123342_(), SentryTurretBlockEntity.this.m_58899_().m_123343_()), entity.m_20185_(), entity.m_20186_(), entity.m_20189_()) <= SentryTurretBlockEntity.this.rangeSq;
        }

        private boolean isExcludedBySecurityStations(Player player) {
            Iterator iterator = SecurityStationBlockEntity.getSecurityStations(SentryTurretBlockEntity.this.m_58904_(), SentryTurretBlockEntity.this.m_58899_(), false).iterator();
            if (iterator.hasNext()) {
                while (iterator.hasNext()) {
                    if (((SecurityStationBlockEntity)iterator.next()).doesAllowPlayer(player)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private class MinigunSentryTurret
    extends Minigun {
        MinigunSentryTurret(Player fakePlayer) {
            super(fakePlayer, true);
        }

        @Override
        public boolean isMinigunActivated() {
            return SentryTurretBlockEntity.this.activated;
        }

        @Override
        public void setMinigunActivated(boolean activated) {
            if (!this.world.f_46443_) {
                SentryTurretBlockEntity.this.activated = activated;
            }
        }

        @Override
        public void setAmmoColorStack(@Nonnull ItemStack ammo) {
            if (!this.world.f_46443_) {
                SentryTurretBlockEntity.this.minigunColorStack = ammo;
            }
        }

        @Override
        public int getAmmoColor() {
            return this.getAmmoColor(SentryTurretBlockEntity.this.minigunColorStack);
        }

        @Override
        public void playSound(SoundEvent soundName, float volume, float pitch) {
            this.world.m_5594_(null, SentryTurretBlockEntity.this.m_58899_(), soundName, SoundSource.BLOCKS, volume, pitch);
        }

        @Override
        public Vec3 getMuzzlePosition() {
            Vec3 centre = Vec3.m_82512_((Vec3i)SentryTurretBlockEntity.this.getPosition());
            LivingEntity target = SentryTurretBlockEntity.this.minigun.getAttackTarget();
            if (target == null) {
                return null;
            }
            Vec3 offset = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0).m_82546_(centre).m_82520_(0.0, 0.5, 0.0).m_82541_().m_82490_(1.5);
            return centre.m_82549_(offset);
        }

        @Override
        public Vec3 getLookAngle() {
            return Vec3.m_82498_((float)this.minigunPitch, (float)this.minigunYaw).m_82541_();
        }

        @Override
        public float getParticleScale() {
            return 1.0f;
        }

        @Override
        public void setSweeping(boolean sweeping) {
            SentryTurretBlockEntity.this.sweeping = sweeping;
        }

        @Override
        public boolean isSweeping() {
            return SentryTurretBlockEntity.this.sweeping;
        }

        @Override
        public PacketPlayMovingSound.MovingSoundFocus getSoundSource() {
            return PacketPlayMovingSound.MovingSoundFocus.of(SentryTurretBlockEntity.this);
        }

        @Override
        public boolean isValid() {
            return !SentryTurretBlockEntity.this.m_58901_();
        }
    }
}

