/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor.options;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.gui.ProgrammerScreen;
import me.desht.pneumaticcraft.client.gui.ProgrammerWidgetAreaRenderer;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.DroneDebugClientHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.debug.DroneDebugEntry;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.IAreaProvider;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetStart;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;

public class DroneDebuggerOptions
extends IOptionPage.SimpleOptionPage<DroneDebugClientHandler> {
    private static final int PROGRAMMING_MARGIN = 20;
    private static final int PROGRAMMING_START_Y = 40;
    private final IDroneBase selectedDrone = PneumaticArmorItem.getDebuggedDrone();
    private ProgrammerWidgetAreaRenderer programmerUnit;
    private int programmingStartX;
    private int programmingWidth;
    private int programmingHeight;
    private IProgWidget areaShowingWidget;
    private Button showActive;
    private Button showStart;
    private WidgetCheckBox followCheckbox;
    private static int areaShowWidgetId = -1;

    public DroneDebuggerOptions(IGuiScreen screen, DroneDebugClientHandler upgradeHandler) {
        super(screen, upgradeHandler);
    }

    public static void clearAreaShowWidgetId() {
        areaShowWidgetId = -1;
    }

    public IDroneBase getSelectedDrone() {
        return this.selectedDrone;
    }

    @Override
    public void populateGui(IGuiScreen gui) {
        this.showStart = new WidgetButtonExtended(30, 128, 150, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.debug.showStart", new Object[0]), b -> this.gotoStartWidget());
        gui.addWidget(this.showStart);
        this.showActive = new WidgetButtonExtended(30, 150, 150, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.debug.showActive", new Object[0]), b -> this.programmerUnit.gotoPiece(this.selectedDrone.getActiveWidget()));
        gui.addWidget(this.showActive);
        this.followCheckbox = new WidgetCheckBox(30, 176, -1, (Component)Component.m_237113_((String)" ").m_7220_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.debug.followActive", new Object[0])));
        this.followCheckbox.m_252865_(180 - this.followCheckbox.m_5711_());
        gui.addWidget(this.followCheckbox);
        Screen guiScreen = this.getGuiScreen().getScreen();
        this.programmingStartX = 20;
        this.programmingWidth = guiScreen.f_96543_ - 40;
        this.programmingHeight = guiScreen.f_96544_ - 20 - 40;
        this.programmerUnit = new DebugWidgetAreaRenderer(guiScreen, this.selectedDrone != null ? this.selectedDrone.getProgWidgets() : new ArrayList(), 0, 0, new Rect2i(this.programmingStartX, 40, this.programmingWidth, this.programmingHeight), 0, 0, 0);
        if (this.isDroneValid()) {
            this.gotoStartWidget();
        }
    }

    public void gotoStartWidget() {
        this.programmerUnit.gotoPiece(ProgrammerScreen.findWidget(Objects.requireNonNull(this.selectedDrone).getProgWidgets(), ProgWidgetStart.class));
    }

    private boolean isDroneValid() {
        return this.selectedDrone != null && this.selectedDrone.isDroneStillValid();
    }

    @Override
    public void renderPre(GuiGraphics graphics, int x, int y, float partialTicks) {
        graphics.m_280509_(this.programmingStartX, 40, this.programmingStartX + this.programmingWidth, 40 + this.programmingHeight, 0x55000000);
    }

    @Override
    public void renderPost(GuiGraphics graphics, int x, int y, float partialTicks) {
        Screen guiScreen = this.getGuiScreen().getScreen();
        Font font = this.getGuiScreen().getFontRenderer();
        int screenWidth = guiScreen.f_96543_;
        int screenHeight = guiScreen.f_96544_;
        if (this.isDroneValid()) {
            graphics.m_280648_(font, PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.debug.droneName", this.selectedDrone.getDroneName().getString()).m_7532_(), 20, screenHeight - 15, -1);
            graphics.m_280648_(font, PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.debug.routine", this.selectedDrone.getLabel()).m_7532_(), screenWidth / 2, screenHeight - 15, -1);
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
        this.programmerUnit.render(graphics, x, y, true, true);
        this.programmerUnit.renderForeground(graphics, x, y, null, font);
        graphics.m_280168_().m_85849_();
        this.followCheckbox.m_88315_(graphics, x, y, partialTicks);
        if (this.isDroneValid()) {
            ((DroneDebugClientHandler)this.getClientUpgradeHandler()).getShowingPositions().clear();
            if (this.areaShowingWidget != null) {
                int widgetId = this.selectedDrone.getProgWidgets().indexOf(this.areaShowingWidget);
                DroneDebugEntry entry = this.selectedDrone.getDebugger().getDebugEntry(widgetId);
                if (entry != null && entry.hasCoords()) {
                    ((DroneDebugClientHandler)this.getClientUpgradeHandler()).getShowingPositions().add(entry.getPos());
                }
            }
        } else {
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
            graphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.debug.pressToDebug", ClientUtils.translateKeyBind(KeyHandler.getInstance().keybindDebuggingDrone)), screenWidth / 2, screenHeight - 40, -65536);
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
        }
    }

    @Override
    public void tick() {
        this.programmerUnit.tick();
        this.showStart.f_93623_ = this.isDroneValid() && !this.selectedDrone.getProgWidgets().isEmpty();
        boolean bl = this.showActive.f_93623_ = this.isDroneValid() && this.selectedDrone.getActiveWidget() != null;
        if (this.followCheckbox.checked && this.isDroneValid() && this.selectedDrone.getActiveWidget() != null) {
            this.programmerUnit.gotoPiece(this.selectedDrone.getActiveWidget());
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (!this.isDroneValid()) {
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }
        IProgWidget widget = this.programmerUnit.getHoveredWidget((int)mouseX, (int)mouseY);
        if (mouseButton == 0) {
            this.areaShowingWidget = this.areaShowingWidget == widget ? null : this.programmerUnit.getHoveredWidget((int)mouseX, (int)mouseY);
        } else if (mouseButton == 1 && widget instanceof IAreaProvider) {
            IAreaProvider areaProvider = (IAreaProvider)((Object)widget);
            ((DroneDebugClientHandler)this.getClientUpgradeHandler()).getShownArea().clear();
            int widgetId = this.selectedDrone.getProgWidgets().indexOf(widget);
            if (areaShowWidgetId != widgetId) {
                HashSet area = Sets.newHashSet();
                areaProvider.getArea(area);
                ((DroneDebugClientHandler)this.getClientUpgradeHandler()).getShownArea().addAll(area);
                areaShowWidgetId = widgetId;
            } else {
                DroneDebuggerOptions.clearAreaShowWidgetId();
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double mouseButton) {
        return this.isDroneValid() && this.programmerUnit.getScrollBar().m_6050_(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.isDroneValid() && this.programmerUnit.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public boolean isToggleable() {
        return false;
    }

    @Override
    public boolean displaySettingsHeader() {
        return false;
    }

    private class DebugWidgetAreaRenderer
    extends ProgrammerWidgetAreaRenderer {
        DebugWidgetAreaRenderer(Screen parent, List<IProgWidget> progWidgets, int guiLeft, int guiTop, Rect2i bounds, int translatedX, int translatedY, int lastZoom) {
            super(progWidgets, guiLeft, guiTop, bounds, translatedX, translatedY, lastZoom);
            ProgrammerBlockEntity.updatePuzzleConnections(progWidgets);
        }

        @Override
        protected void addAdditionalInfoToTooltip(IProgWidget widget, List<Component> tooltip) {
            if (!DroneDebuggerOptions.this.isDroneValid()) {
                return;
            }
            int widgetId = DroneDebuggerOptions.this.selectedDrone.getProgWidgets().indexOf(widget);
            DroneDebugEntry entry = DroneDebuggerOptions.this.selectedDrone.getDebugger().getDebugEntry(widgetId);
            if (entry != null) {
                long elapsed = (System.currentTimeMillis() - entry.getReceivedTime()) / 50L;
                tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.debug.lastMessage", PneumaticCraftUtils.convertTicksToMinutesAndSeconds(elapsed, true)).m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237113_((String)"  \"").m_7220_((Component)PneumaticCraftUtils.xlate(entry.getMessage(), new Object[0])).m_130946_("\"  ").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
                if (entry.hasCoords()) {
                    tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.debug.hasPositions", new Object[0]).m_130940_(ChatFormatting.YELLOW));
                    tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.debug.clickToShow", new Object[0]).m_130940_(ChatFormatting.GREEN));
                }
            }
            if (widget instanceof IAreaProvider) {
                if (widgetId == areaShowWidgetId) {
                    tooltip.add((Component)Component.m_237113_((String)"Right-Click: ").m_7220_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.stopShowingArea", new Object[0])).m_130940_(ChatFormatting.GREEN));
                } else {
                    tooltip.add((Component)Component.m_237113_((String)"Right-Click: ").m_7220_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.showArea", new Object[0])).m_130940_(ChatFormatting.GREEN));
                }
            }
        }

        @Override
        protected void renderAdditionally(GuiGraphics graphics) {
            if (DroneDebuggerOptions.this.isDroneValid() && DroneDebuggerOptions.this.selectedDrone.getActiveWidget() != null) {
                this.drawBorder(graphics, DroneDebuggerOptions.this.selectedDrone.getActiveWidget(), -16711936);
                if (areaShowWidgetId >= 0) {
                    this.drawBorder(graphics, DroneDebuggerOptions.this.selectedDrone.getProgWidgets().get(areaShowWidgetId), -1606352992, 2);
                }
            }
        }
    }
}

