/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor;

import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.ITickableWidget;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.StatPanelLayout;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftScreen;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.ArmorMainScreen;
import me.desht.pneumaticcraft.client.gui.widget.PNCForgeSlider;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.CoreComponentsClientHandler;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;

public class ArmorStatMoveScreen
extends AbstractPneumaticCraftScreen {
    private final IGuiAnimatedStat movedStat;
    private final IArmorUpgradeClientHandler<?> renderHandler;
    private boolean clicked = false;
    private final List<IGuiAnimatedStat> otherStats = new ArrayList<IGuiAnimatedStat>();
    private final List<Component> helpText = new ArrayList<Component>();
    private final ResourceLocation statID;
    private WidgetCheckBox snapToGrid;
    private PNCForgeSlider gridSlider;
    private static boolean snap = false;
    private static int gridSize = 4;

    public ArmorStatMoveScreen(IArmorUpgradeClientHandler<?> renderHandler) {
        this(renderHandler, renderHandler.getID(), renderHandler.getAnimatedStat());
    }

    public ArmorStatMoveScreen(IArmorUpgradeClientHandler<?> renderHandler, ResourceLocation statID, @Nonnull IGuiAnimatedStat movedStat) {
        super((Component)Component.m_237113_((String)"Move Gui"));
        this.movedStat = movedStat;
        this.renderHandler = renderHandler;
        this.statID = statID;
        movedStat.openStat();
        CommonArmorHandler commonArmorHandler = CommonArmorHandler.getHandlerForPlayer();
        for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            List<IArmorUpgradeClientHandler<?>> renderHandlers = ClientArmorRegistry.getInstance().getHandlersForSlot(slot);
            for (int i = 0; i < renderHandlers.size(); ++i) {
                IGuiAnimatedStat stat;
                IArmorUpgradeClientHandler<?> upgradeRenderHandler = renderHandlers.get(i);
                if (!commonArmorHandler.isUpgradeInserted(slot, i) || !commonArmorHandler.isUpgradeEnabled(slot, i) || (stat = upgradeRenderHandler.getAnimatedStat()) == null || stat == movedStat) continue;
                this.otherStats.add(stat);
            }
        }
        CoreComponentsClientHandler mainOptions = ClientArmorRegistry.getInstance().getClientHandler(CommonUpgradeHandlers.coreComponentsHandler, CoreComponentsClientHandler.class);
        IGuiAnimatedStat testMessageStat = mainOptions.getTestMessageStat();
        if (movedStat != testMessageStat) {
            this.otherStats.add(testMessageStat);
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.snapToGrid = new WidgetCheckBox(10, this.f_96544_ * 3 / 5, 0xC0C0C0, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.snapToGrid", new Object[0]));
        this.snapToGrid.m_252865_((this.f_96543_ - this.snapToGrid.m_5711_()) / 2);
        this.snapToGrid.checked = snap;
        this.m_142416_((GuiEventListener)this.snapToGrid);
        this.gridSlider = new PNCForgeSlider(this.snapToGrid.m_252754_(), this.snapToGrid.m_252907_() + 12, this.snapToGrid.m_5711_(), 10, (Component)Component.m_237119_(), (Component)Component.m_237119_(), 1.0, 12.0, gridSize, true, null);
        this.m_142416_((GuiEventListener)this.gridSlider);
        MutableComponent msg = Component.m_237115_((String)"pneumaticcraft.armor.gui.misc.reset");
        this.m_142416_((GuiEventListener)new WidgetButtonExtended(this.gridSlider.m_252754_(), this.gridSlider.m_252907_() + 12, this.f_96547_.m_92852_((FormattedText)msg) + 20, 20, (Component)msg, b -> this.resetStatPosition()));
    }

    private void resetStatPosition() {
        Window window = Objects.requireNonNull(this.f_96541_).m_91268_();
        StatPanelLayout defLayout = this.renderHandler.getDefaultStatLayout();
        this.movedStat.setBaseX((int)(defLayout.x() * (float)window.m_85445_()));
        this.movedStat.setBaseY((int)(defLayout.y() * (float)window.m_85446_()));
        this.movedStat.setLeftSided(defLayout.expandsLeft());
        this.renderHandler.onResolutionChanged();
        this.save();
    }

    @Override
    protected ResourceLocation getTexture() {
        return null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.movedStat.getBounds().m_110087_((int)mouseX, (int)mouseY)) {
            if (mouseButton == 2) {
                this.movedStat.setLeftSided(!this.movedStat.isLeftSided());
                if (this.movedStat.isLeftSided() && this.movedStat.getBaseX() < 10) {
                    this.movedStat.setBaseX(10);
                } else if (!this.movedStat.isLeftSided() && this.movedStat.getBaseX() > this.f_96543_ - 10) {
                    this.movedStat.setBaseX(this.f_96543_ - 10);
                }
                this.save();
            } else if (mouseButton < 2) {
                this.clicked = true;
                this.reposition(this.movedStat, mouseX, mouseY);
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        if (this.clicked) {
            if (mouseButton == 0 || mouseButton == 1) {
                this.reposition(this.movedStat, mouseX, mouseY);
            }
            this.save();
            this.clicked = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dx, double dy) {
        if (this.clicked) {
            this.reposition(this.movedStat, mouseX, mouseY);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, mouseButton, dx, dy);
    }

    private void reposition(IGuiAnimatedStat stat, double x, double y) {
        if (snap) {
            x -= x % (double)gridSize;
            y -= y % (double)gridSize;
        }
        stat.setBaseX((int)x);
        stat.setBaseY((int)y);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_((Screen)ArmorMainScreen.getInstance());
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int x, int y, float partialTicks) {
        this.m_280273_(graphics);
        Rect2i bounds = GuiUtils.showPopupHelpScreen(graphics, this, this.f_96547_, this.helpText);
        this.snapToGrid.m_253211_(bounds.m_110086_() + bounds.m_110091_() + 15);
        this.gridSlider.m_253211_(this.snapToGrid.m_252907_() + 12);
        super.m_88315_(graphics, x, y, partialTicks);
        this.movedStat.renderStat(graphics, -1, -1, partialTicks);
        this.otherStats.forEach(stat -> {
            int c = stat.getBackgroundColor();
            stat.setBackgroundColor(0x30606060);
            stat.renderStat(graphics, -1, -1, partialTicks);
            stat.setBackgroundColor(c);
        });
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        snap = this.snapToGrid.checked;
        gridSize = this.gridSlider.getValueInt();
        this.gridSlider.f_93624_ = snap;
        this.movedStat.tickWidget();
        this.otherStats.forEach(ITickableWidget::tickWidget);
        if (this.helpText.isEmpty()) {
            this.helpText.add((Component)PneumaticCraftUtils.xlate(IArmorUpgradeHandler.getStringKey(this.renderHandler.getID()), new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.UNDERLINE}));
            this.helpText.add((Component)Component.m_237119_());
            this.helpText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.moveStat.move", new Object[0]));
            this.helpText.add((Component)Component.m_237113_((String)"<REPLACEME>"));
        }
        this.helpText.set(3, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.moveStat.expand" + (this.movedStat.isLeftSided() ? "Left" : "Right"), new Object[0]));
    }

    private void save() {
        Window window = Objects.requireNonNull(this.f_96541_).m_91268_();
        ArmorHUDLayout.INSTANCE.updateLayout(this.statID, (float)this.movedStat.getBaseX() / (float)window.m_85445_(), (float)this.movedStat.getBaseY() / (float)window.m_85446_(), this.movedStat.isLeftSided(), false);
    }
}

