/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.angelring.item.utils;

import java.util.Objects;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyItem
implements IEnergyStorage {
    private final ItemStack stack;
    private final int capacity;

    public EnergyItem(ItemStack stack, int capacity) {
        this.stack = stack;
        this.capacity = capacity;
    }

    public int receiveEnergy(int maxReceived, boolean simulate) {
        int stored = this.getEnergyStored();
        int received = Math.max(0, Math.min(maxReceived, this.getMaxEnergyStored() - stored));
        if (!simulate) {
            this.stack.m_41784_().m_128405_("energy", stored + received);
        }
        return received;
    }

    public int extractEnergy(int maxExtracted, boolean simulate) {
        int stored = this.getEnergyStored();
        int extracted = Math.max(0, Math.min(maxExtracted, stored));
        if (!simulate) {
            this.stack.m_41784_().m_128405_("energy", stored - extracted);
        }
        return extracted;
    }

    public int getEnergyStored() {
        return this.stack.m_41782_() && Objects.requireNonNull(this.stack.m_41783_()).m_128441_("energy") ? this.stack.m_41783_().m_128451_("energy") : 0;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return this.getEnergyStored() > 0;
    }

    public boolean canReceive() {
        return this.getEnergyStored() < this.getMaxEnergyStored();
    }
}

